# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WebhookResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'active': 'bool',
        'resource': 'WebhookCompactResource',
        'target': 'str',
        'created_at': 'datetime',
        'last_failure_at': 'datetime',
        'last_failure_content': 'str',
        'last_success_at': 'datetime',
        'filters': 'list[WebhookRequestFilters]'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'active': 'active',
        'resource': 'resource',
        'target': 'target',
        'created_at': 'created_at',
        'last_failure_at': 'last_failure_at',
        'last_failure_content': 'last_failure_content',
        'last_success_at': 'last_success_at',
        'filters': 'filters'
    }

    def __init__(self, gid=None, resource_type=None, active=None, resource=None, target=None, created_at=None, last_failure_at=None, last_failure_content=None, last_success_at=None, filters=None):  # noqa: E501
        """WebhookResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._active = None
        self._resource = None
        self._target = None
        self._created_at = None
        self._last_failure_at = None
        self._last_failure_content = None
        self._last_success_at = None
        self._filters = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if active is not None:
            self.active = active
        if resource is not None:
            self.resource = resource
        if target is not None:
            self.target = target
        if created_at is not None:
            self.created_at = created_at
        if last_failure_at is not None:
            self.last_failure_at = last_failure_at
        if last_failure_content is not None:
            self.last_failure_content = last_failure_content
        if last_success_at is not None:
            self.last_success_at = last_success_at
        if filters is not None:
            self.filters = filters

    @property
    def gid(self):
        """Gets the gid of this WebhookResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this WebhookResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this WebhookResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this WebhookResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this WebhookResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this WebhookResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this WebhookResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this WebhookResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def active(self):
        """Gets the active of this WebhookResponse.  # noqa: E501

        If true, the webhook will send events - if false it is considered inactive and will not generate events.  # noqa: E501

        :return: The active of this WebhookResponse.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this WebhookResponse.

        If true, the webhook will send events - if false it is considered inactive and will not generate events.  # noqa: E501

        :param active: The active of this WebhookResponse.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def resource(self):
        """Gets the resource of this WebhookResponse.  # noqa: E501


        :return: The resource of this WebhookResponse.  # noqa: E501
        :rtype: WebhookCompactResource
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this WebhookResponse.


        :param resource: The resource of this WebhookResponse.  # noqa: E501
        :type: WebhookCompactResource
        """

        self._resource = resource

    @property
    def target(self):
        """Gets the target of this WebhookResponse.  # noqa: E501

        The URL to receive the HTTP POST.  # noqa: E501

        :return: The target of this WebhookResponse.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this WebhookResponse.

        The URL to receive the HTTP POST.  # noqa: E501

        :param target: The target of this WebhookResponse.  # noqa: E501
        :type: str
        """

        self._target = target

    @property
    def created_at(self):
        """Gets the created_at of this WebhookResponse.  # noqa: E501

        The time at which this resource was created.  # noqa: E501

        :return: The created_at of this WebhookResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this WebhookResponse.

        The time at which this resource was created.  # noqa: E501

        :param created_at: The created_at of this WebhookResponse.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def last_failure_at(self):
        """Gets the last_failure_at of this WebhookResponse.  # noqa: E501

        The timestamp when the webhook last received an error when sending an event to the target.  # noqa: E501

        :return: The last_failure_at of this WebhookResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._last_failure_at

    @last_failure_at.setter
    def last_failure_at(self, last_failure_at):
        """Sets the last_failure_at of this WebhookResponse.

        The timestamp when the webhook last received an error when sending an event to the target.  # noqa: E501

        :param last_failure_at: The last_failure_at of this WebhookResponse.  # noqa: E501
        :type: datetime
        """

        self._last_failure_at = last_failure_at

    @property
    def last_failure_content(self):
        """Gets the last_failure_content of this WebhookResponse.  # noqa: E501

        The contents of the last error response sent to the webhook when attempting to deliver events to the target.  # noqa: E501

        :return: The last_failure_content of this WebhookResponse.  # noqa: E501
        :rtype: str
        """
        return self._last_failure_content

    @last_failure_content.setter
    def last_failure_content(self, last_failure_content):
        """Sets the last_failure_content of this WebhookResponse.

        The contents of the last error response sent to the webhook when attempting to deliver events to the target.  # noqa: E501

        :param last_failure_content: The last_failure_content of this WebhookResponse.  # noqa: E501
        :type: str
        """

        self._last_failure_content = last_failure_content

    @property
    def last_success_at(self):
        """Gets the last_success_at of this WebhookResponse.  # noqa: E501

        The timestamp when the webhook last successfully sent an event to the target.  # noqa: E501

        :return: The last_success_at of this WebhookResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._last_success_at

    @last_success_at.setter
    def last_success_at(self, last_success_at):
        """Sets the last_success_at of this WebhookResponse.

        The timestamp when the webhook last successfully sent an event to the target.  # noqa: E501

        :param last_success_at: The last_success_at of this WebhookResponse.  # noqa: E501
        :type: datetime
        """

        self._last_success_at = last_success_at

    @property
    def filters(self):
        """Gets the filters of this WebhookResponse.  # noqa: E501

        Whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.  # noqa: E501

        :return: The filters of this WebhookResponse.  # noqa: E501
        :rtype: list[WebhookRequestFilters]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this WebhookResponse.

        Whitelist of filters to apply to events from this webhook. If a webhook event passes any of the filters the event will be delivered; otherwise no event will be sent to the receiving server.  # noqa: E501

        :param filters: The filters of this WebhookResponse.  # noqa: E501
        :type: list[WebhookRequestFilters]
        """

        self._filters = filters

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WebhookResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebhookResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
