# coding: utf-8

"""
    Asana

    This is the interface for interacting with the [Asana Platform](https://developers.asana.com). Our API reference is generated from our [OpenAPI spec] (https://raw.githubusercontent.com/Asana/openapi/master/defs/asana_oas.yaml).  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WorkspaceResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gid': 'str',
        'resource_type': 'str',
        'name': 'str',
        'email_domains': 'list[str]',
        'is_organization': 'bool'
    }

    attribute_map = {
        'gid': 'gid',
        'resource_type': 'resource_type',
        'name': 'name',
        'email_domains': 'email_domains',
        'is_organization': 'is_organization'
    }

    def __init__(self, gid=None, resource_type=None, name=None, email_domains=None, is_organization=None):  # noqa: E501
        """WorkspaceResponse - a model defined in Swagger"""  # noqa: E501
        self._gid = None
        self._resource_type = None
        self._name = None
        self._email_domains = None
        self._is_organization = None
        self.discriminator = None
        if gid is not None:
            self.gid = gid
        if resource_type is not None:
            self.resource_type = resource_type
        if name is not None:
            self.name = name
        if email_domains is not None:
            self.email_domains = email_domains
        if is_organization is not None:
            self.is_organization = is_organization

    @property
    def gid(self):
        """Gets the gid of this WorkspaceResponse.  # noqa: E501

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :return: The gid of this WorkspaceResponse.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this WorkspaceResponse.

        Globally unique identifier of the resource, as a string.  # noqa: E501

        :param gid: The gid of this WorkspaceResponse.  # noqa: E501
        :type: str
        """

        self._gid = gid

    @property
    def resource_type(self):
        """Gets the resource_type of this WorkspaceResponse.  # noqa: E501

        The base type of this resource.  # noqa: E501

        :return: The resource_type of this WorkspaceResponse.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this WorkspaceResponse.

        The base type of this resource.  # noqa: E501

        :param resource_type: The resource_type of this WorkspaceResponse.  # noqa: E501
        :type: str
        """

        self._resource_type = resource_type

    @property
    def name(self):
        """Gets the name of this WorkspaceResponse.  # noqa: E501

        The name of the workspace.  # noqa: E501

        :return: The name of this WorkspaceResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WorkspaceResponse.

        The name of the workspace.  # noqa: E501

        :param name: The name of this WorkspaceResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def email_domains(self):
        """Gets the email_domains of this WorkspaceResponse.  # noqa: E501

        The email domains that are associated with this workspace.  # noqa: E501

        :return: The email_domains of this WorkspaceResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._email_domains

    @email_domains.setter
    def email_domains(self, email_domains):
        """Sets the email_domains of this WorkspaceResponse.

        The email domains that are associated with this workspace.  # noqa: E501

        :param email_domains: The email_domains of this WorkspaceResponse.  # noqa: E501
        :type: list[str]
        """

        self._email_domains = email_domains

    @property
    def is_organization(self):
        """Gets the is_organization of this WorkspaceResponse.  # noqa: E501

        Whether the workspace is an *organization*.  # noqa: E501

        :return: The is_organization of this WorkspaceResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_organization

    @is_organization.setter
    def is_organization(self, is_organization):
        """Sets the is_organization of this WorkspaceResponse.

        Whether the workspace is an *organization*.  # noqa: E501

        :param is_organization: The is_organization of this WorkspaceResponse.  # noqa: E501
        :type: bool
        """

        self._is_organization = is_organization

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WorkspaceResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkspaceResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
