# -*- coding: utf-8 -*-
from collective import dexteritytextindexer
from design.plone.contenttypes import _
from design.plone.contenttypes.interfaces.documento import IDocumento
from plone.app.textfield import RichText
from plone.app.z3cform.widget import RichTextFieldWidget
from plone.autoform import directives as form
from plone.autoform.interfaces import IFormFieldProvider
from plone.dexterity.interfaces import IDexterityContent
from plone.supermodel import model
from zope.component import adapter
from zope.interface import provider, implementer


class IDescrizioneEstesaSchema(model.Schema):
    descrizione_estesa = RichText(
        title=_(u"descrizione_estesa", default=u"Descrizione estesa"),
        required=False,
        description=_(
            "descrizione_estesa_help",
            default="Descrizione dettagliata e completa.",
        ),
    )

    form.widget("descrizione_estesa", RichTextFieldWidget)
    dexteritytextindexer.searchable("descrizione_estesa")


@provider(IFormFieldProvider)
class IDescrizioneEstesa(IDescrizioneEstesaSchema):
    """ """

    form.order_after(descrizione_estesa="IBasic.description")


@provider(IFormFieldProvider)
class IDescrizioneEstesaServizio(IDescrizioneEstesaSchema):
    """ """

    model.fieldset(
        "cose",
        label=_("cose_label", default=u"Cos'è"),
        fields=["descrizione_estesa"],
    )


@provider(IFormFieldProvider)
class IDescrizioneEstesaDocumento(IDescrizioneEstesaSchema):
    """ """

    model.fieldset(
        "descrizione",
        label=_("descrizione_label", default=u"Descrizione"),
        fields=["descrizione_estesa"],
    )


@implementer(IDescrizioneEstesa)
@adapter(IDexterityContent)
class DescrizioneEstesa(object):
    """"""

    def __init__(self, context):
        self.context = context


@implementer(IDescrizioneEstesaServizio)
@adapter(IDexterityContent)
class DescrizioneEstesaServizio(object):
    """"""

    def __init__(self, context):
        self.context = context


@implementer(IDescrizioneEstesaDocumento)
@adapter(IDocumento)
class DescrizioneEstesaDocumento(object):
    """"""

    def __init__(self, context):
        self.context = context
