function [] = runSearch(execution_id,configuration,csv_file, h_status)
%RUNSEARCH Executes a search process according to the given parameters
% global variables for light-weight fitness function evaluation
global A Cost Features H BM;


%% Read the dataset
T = readtable(csv_file);
Cost = table2array(T(:,19));          % test execution time is column 19
Features = table2array(T(:,1:16));    % ignore the time stamp (columns 17, 18)
H = h_status;

%% We normalize all the feautes (min-max normalizaton)
[m, n] = size(Features);
% for i = 1:n
%    Features(:,i) =  (Features(:,i) - min(Features(:,i)))/ (max(Features(:,i)) - min(Features(:,i)));
% end
%%

if ~strcmp("default-GA",configuration)
    [coeff,scores,latent, tsd, variance,mu] = pca(Features);
    if strcmp("10_feature_GA",configuration)
        Features = scores(:,1:10);  
    else
        Features = scores(:,1:6);  
    end
end

[pathstr,name,ext] = fileparts(csv_file);
BM = name
%% We compute the pairwse (Euclidean) distance between test cases
Differences = pdist(Features,"seuclidean");
Differences = squareform(Differences);
A = Differences;  % this variable is used in the fitness function evaluation
 
%% Genetic Algoritm (Chromosomes = test permutations)
options = optimoptions('ga');
options = optimoptions(options,'PopulationType', 'custom');
options = optimoptions(options,'PopulationSize', 100);
options = optimoptions(options,'MaxGenerations', 4000);
options = optimoptions(options,'CreationFcn', @initialPopulation);
options = optimoptions(options,'SelectionFcn', @selectionroulette);
options = optimoptions(options,'CrossoverFcn', @permutationCrossover);
options = optimoptions(options,'MutationFcn', @permutationMutation);
options = optimoptions(options,'FunctionTolerance', 0);
options = optimoptions(options,'MaxStallGenerations', 100);
options = optimoptions(options,'Display', 'off');
options = optimoptions(options,'PlotFcn', { @gaplotbestf, @gaplotscorediversity });
tic
[x,fval,exitflag,output,population,score] = ga(@fitness,m,[],[],[],[],[],[],[],[],options);
elapsed_time=toc
% x is the optimum permutation of test executions detected by ga
% fval is the fitness value of x
% population is the final population generated by ga
% score contains the fitness values of the individuals in the last population

%% Comparison in Fault detection

[a,b] = faultDetection(x, T, Cost); 
% a(1,i) is execution cost for running first i tests
% b(1,i) is the number of detected faults after running first i tests
plot(a, b, 'r');
hold on

APFD_c = trapz(a, b) / max(a) / max(b)
%% Save search information as a csv file


output_dir = strcat("../data/",name,"/",configuration,"/",int2str(execution_id),"/");
mkdir (output_dir)




writematrix(x,strcat(output_dir,"best-permutation.csv"))

rand_APFD = zeros(1,500);
%% Random permutations (baseline)
for i=1:500
    [a,b] = faultDetection(randperm(m), T, Cost); 
    plot(a, b, 'b');
    rand_APFD(1,i) = trapz(a, b) / max(a) / max(b);
end

writematrix(rand_APFD,strcat(output_dir,"rands.csv"))

avg_rand_APFD = mean(rand_APFD,2)
std_rand_APFD = std(rand_APFD)

mat = ["config" "execution_id" "best_fitness_value" "APFD" "elapsed_time" "avg_rand_APFD" "std_rand_APFD";configuration execution_id fval APFD_c elapsed_time avg_rand_APFD std_rand_APFD];
writematrix(mat,strcat(output_dir,"results.csv"))

title('Fault detection capability')
xlabel('Execution cost (s)') 
ylabel('Number of failures')

hold off
exportgraphics(gcf,strcat(output_dir,"plot.png"))
end

