import * as lambda from '@aws-cdk/aws-lambda';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
/**
 * Use a SQS queue as a Lambda destination.
 *
 * @stability stable
 */
export declare class SqsDestination implements lambda.IDestination {
    private readonly queue;
    /**
     * @stability stable
     */
    constructor(queue: sqs.IQueue);
    /**
     * Returns a destination configuration.
     *
     * @stability stable
     */
    bind(_scope: Construct, fn: lambda.IFunction, _options?: lambda.DestinationOptions): lambda.DestinationConfig;
}
