"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schedule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Schedule for canary runs
 */
class Schedule {
    constructor(
    /**
     * The Schedule expression
     */
    expressionString) {
        this.expressionString = expressionString;
    }
    /**
     * The canary will be executed once.
     */
    static once() {
        return new Schedule('rate(0 minutes)');
    }
    /**
     * Construct a schedule from a literal schedule expression. The expression must be in a `rate(number units)` format.
     * For example, `Schedule.expression('rate(10 minutes)')`
     *
     * @param expression The expression to use.
     */
    static expression(expression) {
        return new Schedule(expression);
    }
    /**
     * Construct a schedule from an interval. Allowed values: 0 (for a single run) or between 1 and 60 minutes.
     * To specify a single run, you can use `Schedule.once()`.
     *
     * @param interval The interval at which to run the canary
     */
    static rate(interval) {
        const minutes = interval.toMinutes();
        if (minutes > 60) {
            throw new Error('Schedule duration must be between 1 and 60 minutes');
        }
        if (minutes === 0) {
            return Schedule.once();
        }
        if (minutes === 1) {
            return new Schedule('rate(1 minute)');
        }
        return new Schedule(`rate(${minutes} minutes)`);
    }
    /**
     * Create a schedule from a set of cron fields
     */
    static cron(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_synthetics_CronOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.cron);
            }
            throw error;
        }
        if (options.weekDay !== undefined && options.day !== undefined) {
            throw new Error('Cannot supply both \'day\' and \'weekDay\', use at most one');
        }
        const minute = fallback(options.minute, '*');
        const hour = fallback(options.hour, '*');
        const month = fallback(options.month, '*');
        // Weekday defaults to '?' if not supplied. If it is supplied, day must become '?'
        const day = fallback(options.day, options.weekDay !== undefined ? '?' : '*');
        const weekDay = fallback(options.weekDay, '?');
        // '*' is only allowed in the year field
        const year = '*';
        return new Schedule(`cron(${minute} ${hour} ${day} ${month} ${weekDay} ${year})`);
    }
}
exports.Schedule = Schedule;
_a = JSII_RTTI_SYMBOL_1;
Schedule[_a] = { fqn: "@aws-cdk/aws-synthetics.Schedule", version: "1.187.0" };
function fallback(x, def) {
    return x ?? def;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NoZWR1bGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzY2hlZHVsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFFQTs7R0FFRztBQUNILE1BQWEsUUFBUTtJQTZEbkI7SUFDRTs7T0FFRztJQUNhLGdCQUF3QjtRQUF4QixxQkFBZ0IsR0FBaEIsZ0JBQWdCLENBQVE7S0FBSTtJQS9EOUM7O09BRUc7SUFDSSxNQUFNLENBQUMsSUFBSTtRQUNoQixPQUFPLElBQUksUUFBUSxDQUFDLGlCQUFpQixDQUFDLENBQUM7S0FDeEM7SUFFRDs7Ozs7T0FLRztJQUNJLE1BQU0sQ0FBQyxVQUFVLENBQUMsVUFBa0I7UUFDekMsT0FBTyxJQUFJLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUNqQztJQUVEOzs7OztPQUtHO0lBQ0ksTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFrQjtRQUNuQyxNQUFNLE9BQU8sR0FBRyxRQUFRLENBQUMsU0FBUyxFQUFFLENBQUM7UUFDckMsSUFBSSxPQUFPLEdBQUcsRUFBRSxFQUFFO1lBQ2hCLE1BQU0sSUFBSSxLQUFLLENBQUMsb0RBQW9ELENBQUMsQ0FBQztTQUN2RTtRQUNELElBQUksT0FBTyxLQUFLLENBQUMsRUFBRTtZQUNqQixPQUFPLFFBQVEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztTQUN4QjtRQUNELElBQUksT0FBTyxLQUFLLENBQUMsRUFBRTtZQUNqQixPQUFPLElBQUksUUFBUSxDQUFDLGdCQUFnQixDQUFDLENBQUM7U0FDdkM7UUFDRCxPQUFPLElBQUksUUFBUSxDQUFDLFFBQVEsT0FBTyxXQUFXLENBQUMsQ0FBQztLQUNqRDtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLElBQUksQ0FBQyxPQUFvQjs7Ozs7Ozs7OztRQUNyQyxJQUFJLE9BQU8sQ0FBQyxPQUFPLEtBQUssU0FBUyxJQUFJLE9BQU8sQ0FBQyxHQUFHLEtBQUssU0FBUyxFQUFFO1lBQzlELE1BQU0sSUFBSSxLQUFLLENBQUMsNkRBQTZELENBQUMsQ0FBQztTQUNoRjtRQUVELE1BQU0sTUFBTSxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQzdDLE1BQU0sSUFBSSxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3pDLE1BQU0sS0FBSyxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBRTNDLGtGQUFrRjtRQUNsRixNQUFNLEdBQUcsR0FBRyxRQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsRUFBRSxPQUFPLENBQUMsT0FBTyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUM3RSxNQUFNLE9BQU8sR0FBRyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsQ0FBQztRQUUvQyx3Q0FBd0M7UUFDeEMsTUFBTSxJQUFJLEdBQUcsR0FBRyxDQUFDO1FBRWpCLE9BQU8sSUFBSSxRQUFRLENBQUMsUUFBUSxNQUFNLElBQUksSUFBSSxJQUFJLEdBQUcsSUFBSSxLQUFLLElBQUksT0FBTyxJQUFJLElBQUksR0FBRyxDQUFDLENBQUM7S0FDbkY7O0FBM0RILDRCQWtFQzs7O0FBZ0RELFNBQVMsUUFBUSxDQUFDLENBQXFCLEVBQUUsR0FBVztJQUNsRCxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUM7QUFDbEIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IER1cmF0aW9uIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogU2NoZWR1bGUgZm9yIGNhbmFyeSBydW5zXG4gKi9cbmV4cG9ydCBjbGFzcyBTY2hlZHVsZSB7XG5cbiAgLyoqXG4gICAqIFRoZSBjYW5hcnkgd2lsbCBiZSBleGVjdXRlZCBvbmNlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBvbmNlKCk6IFNjaGVkdWxlIHtcbiAgICByZXR1cm4gbmV3IFNjaGVkdWxlKCdyYXRlKDAgbWludXRlcyknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3QgYSBzY2hlZHVsZSBmcm9tIGEgbGl0ZXJhbCBzY2hlZHVsZSBleHByZXNzaW9uLiBUaGUgZXhwcmVzc2lvbiBtdXN0IGJlIGluIGEgYHJhdGUobnVtYmVyIHVuaXRzKWAgZm9ybWF0LlxuICAgKiBGb3IgZXhhbXBsZSwgYFNjaGVkdWxlLmV4cHJlc3Npb24oJ3JhdGUoMTAgbWludXRlcyknKWBcbiAgICpcbiAgICogQHBhcmFtIGV4cHJlc3Npb24gVGhlIGV4cHJlc3Npb24gdG8gdXNlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBleHByZXNzaW9uKGV4cHJlc3Npb246IHN0cmluZyk6IFNjaGVkdWxlIHtcbiAgICByZXR1cm4gbmV3IFNjaGVkdWxlKGV4cHJlc3Npb24pO1xuICB9XG5cbiAgLyoqXG4gICAqIENvbnN0cnVjdCBhIHNjaGVkdWxlIGZyb20gYW4gaW50ZXJ2YWwuIEFsbG93ZWQgdmFsdWVzOiAwIChmb3IgYSBzaW5nbGUgcnVuKSBvciBiZXR3ZWVuIDEgYW5kIDYwIG1pbnV0ZXMuXG4gICAqIFRvIHNwZWNpZnkgYSBzaW5nbGUgcnVuLCB5b3UgY2FuIHVzZSBgU2NoZWR1bGUub25jZSgpYC5cbiAgICpcbiAgICogQHBhcmFtIGludGVydmFsIFRoZSBpbnRlcnZhbCBhdCB3aGljaCB0byBydW4gdGhlIGNhbmFyeVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByYXRlKGludGVydmFsOiBEdXJhdGlvbik6IFNjaGVkdWxlIHtcbiAgICBjb25zdCBtaW51dGVzID0gaW50ZXJ2YWwudG9NaW51dGVzKCk7XG4gICAgaWYgKG1pbnV0ZXMgPiA2MCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdTY2hlZHVsZSBkdXJhdGlvbiBtdXN0IGJlIGJldHdlZW4gMSBhbmQgNjAgbWludXRlcycpO1xuICAgIH1cbiAgICBpZiAobWludXRlcyA9PT0gMCkge1xuICAgICAgcmV0dXJuIFNjaGVkdWxlLm9uY2UoKTtcbiAgICB9XG4gICAgaWYgKG1pbnV0ZXMgPT09IDEpIHtcbiAgICAgIHJldHVybiBuZXcgU2NoZWR1bGUoJ3JhdGUoMSBtaW51dGUpJyk7XG4gICAgfVxuICAgIHJldHVybiBuZXcgU2NoZWR1bGUoYHJhdGUoJHttaW51dGVzfSBtaW51dGVzKWApO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZSBhIHNjaGVkdWxlIGZyb20gYSBzZXQgb2YgY3JvbiBmaWVsZHNcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgY3JvbihvcHRpb25zOiBDcm9uT3B0aW9ucyk6IFNjaGVkdWxlIHtcbiAgICBpZiAob3B0aW9ucy53ZWVrRGF5ICE9PSB1bmRlZmluZWQgJiYgb3B0aW9ucy5kYXkgIT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdDYW5ub3Qgc3VwcGx5IGJvdGggXFwnZGF5XFwnIGFuZCBcXCd3ZWVrRGF5XFwnLCB1c2UgYXQgbW9zdCBvbmUnKTtcbiAgICB9XG5cbiAgICBjb25zdCBtaW51dGUgPSBmYWxsYmFjayhvcHRpb25zLm1pbnV0ZSwgJyonKTtcbiAgICBjb25zdCBob3VyID0gZmFsbGJhY2sob3B0aW9ucy5ob3VyLCAnKicpO1xuICAgIGNvbnN0IG1vbnRoID0gZmFsbGJhY2sob3B0aW9ucy5tb250aCwgJyonKTtcblxuICAgIC8vIFdlZWtkYXkgZGVmYXVsdHMgdG8gJz8nIGlmIG5vdCBzdXBwbGllZC4gSWYgaXQgaXMgc3VwcGxpZWQsIGRheSBtdXN0IGJlY29tZSAnPydcbiAgICBjb25zdCBkYXkgPSBmYWxsYmFjayhvcHRpb25zLmRheSwgb3B0aW9ucy53ZWVrRGF5ICE9PSB1bmRlZmluZWQgPyAnPycgOiAnKicpO1xuICAgIGNvbnN0IHdlZWtEYXkgPSBmYWxsYmFjayhvcHRpb25zLndlZWtEYXksICc/Jyk7XG5cbiAgICAvLyAnKicgaXMgb25seSBhbGxvd2VkIGluIHRoZSB5ZWFyIGZpZWxkXG4gICAgY29uc3QgeWVhciA9ICcqJztcblxuICAgIHJldHVybiBuZXcgU2NoZWR1bGUoYGNyb24oJHttaW51dGV9ICR7aG91cn0gJHtkYXl9ICR7bW9udGh9ICR7d2Vla0RheX0gJHt5ZWFyfSlgKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoXG4gICAgLyoqXG4gICAgICogVGhlIFNjaGVkdWxlIGV4cHJlc3Npb25cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgZXhwcmVzc2lvblN0cmluZzogc3RyaW5nKSB7fVxufVxuXG5cbi8qKlxuICogT3B0aW9ucyB0byBjb25maWd1cmUgYSBjcm9uIGV4cHJlc3Npb25cbiAqXG4gKiBBbGwgZmllbGRzIGFyZSBzdHJpbmdzIHNvIHlvdSBjYW4gdXNlIGNvbXBsZXggZXhwcmVzc2lvbnMuIEFic2VuY2Ugb2ZcbiAqIGEgZmllbGQgaW1wbGllcyAnKicgb3IgJz8nLCB3aGljaGV2ZXIgb25lIGlzIGFwcHJvcHJpYXRlLlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvbkNsb3VkV2F0Y2gvbGF0ZXN0L21vbml0b3JpbmcvQ2xvdWRXYXRjaF9TeW50aGV0aWNzX0NhbmFyaWVzX2Nyb24uaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENyb25PcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBtaW51dGUgdG8gcnVuIHRoaXMgcnVsZSBhdFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEV2ZXJ5IG1pbnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgbWludXRlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgaG91ciB0byBydW4gdGhpcyBydWxlIGF0XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRXZlcnkgaG91clxuICAgKi9cbiAgcmVhZG9ubHkgaG91cj86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGRheSBvZiB0aGUgbW9udGggdG8gcnVuIHRoaXMgcnVsZSBhdFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEV2ZXJ5IGRheSBvZiB0aGUgbW9udGhcbiAgICovXG4gIHJlYWRvbmx5IGRheT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG1vbnRoIHRvIHJ1biB0aGlzIHJ1bGUgYXRcbiAgICpcbiAgICogQGRlZmF1bHQgLSBFdmVyeSBtb250aFxuICAgKi9cbiAgcmVhZG9ubHkgbW9udGg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBkYXkgb2YgdGhlIHdlZWsgdG8gcnVuIHRoaXMgcnVsZSBhdFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEFueSBkYXkgb2YgdGhlIHdlZWtcbiAgICovXG4gIHJlYWRvbmx5IHdlZWtEYXk/OiBzdHJpbmc7XG59XG5cbmZ1bmN0aW9uIGZhbGxiYWNrKHg6IHN0cmluZyB8IHVuZGVmaW5lZCwgZGVmOiBzdHJpbmcpOiBzdHJpbmcge1xuICByZXR1cm4geCA/PyBkZWY7XG59XG4iXX0=