from ..util import Model


class Category(Model):
	def __init__(self):
		self.__display_label = None
		self.__permissions_details = None
		self.__name = None
		self.__key_modified = dict()

	def get_display_label(self):
		"""
		The method to get the display_label

		Returns:
			string: A string value
		"""
		return self.__display_label

	def set_display_label(self, display_label):
		"""
		The method to set the value to display_label

		Parameters:
			display_label (string) : A string value
		"""
		self.__display_label = display_label
		self.__key_modified["display_label"] = 1

	def get_permissions_details(self):
		"""
		The method to get the permissions_details

		Returns:
			list: An instance of list
		"""
		return self.__permissions_details

	def set_permissions_details(self, permissions_details):
		"""
		The method to set the value to permissions_details

		Parameters:
			permissions_details (list) : An instance of list
		"""
		self.__permissions_details = permissions_details
		self.__key_modified["permissions_details"] = 1

	def get_name(self):
		"""
		The method to get the name

		Returns:
			string: A string value
		"""
		return self.__name

	def set_name(self, name):
		"""
		The method to set the value to name

		Parameters:
			name (string) : A string value
		"""
		self.__name = name
		self.__key_modified["name"] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string value

		Returns:
			int: A int value
		"""
		return self.__key_modified.get(key)

	def set_key_modified(self, modification, key):
		"""
		The method to mark the given key as modified

		Parameters:
			modification (int) : A int value
			key (string) : A string value
		"""
		self.__key_modified[key] = modification
