from ..util import Model

from .record_action_response import RecordActionResponse

class MultipleRecordSuccessResponse(Model, RecordActionResponse):
	def __init__(self):
		self.__data = None
		self.__wf_scheduler = None
		self.__success_count = None
		self.__locked_count = None
		self.__key_modified = dict()

	def get_data(self):
		"""
		The method to get the data

		Returns:
			list: An instance of list
		"""
		return self.__data

	def set_data(self, data):
		"""
		The method to set the value to data

		Parameters:
			data (list) : An instance of list
		"""
		self.__data = data
		self.__key_modified["data"] = 1

	def get_wf_scheduler(self):
		"""
		The method to get the wf_scheduler

		Returns:
			bool: A bool value
		"""
		return self.__wf_scheduler

	def set_wf_scheduler(self, wf_scheduler):
		"""
		The method to set the value to wf_scheduler

		Parameters:
			wf_scheduler (bool) : A bool value
		"""
		self.__wf_scheduler = wf_scheduler
		self.__key_modified["wf_scheduler"] = 1

	def get_success_count(self):
		"""
		The method to get the success_count

		Returns:
			string: A string value
		"""
		return self.__success_count

	def set_success_count(self, success_count):
		"""
		The method to set the value to success_count

		Parameters:
			success_count (string) : A string value
		"""
		self.__success_count = success_count
		self.__key_modified["success_count"] = 1

	def get_locked_count(self):
		"""
		The method to get the locked_count

		Returns:
			bool: A bool value
		"""
		return self.__locked_count

	def set_locked_count(self, locked_count):
		"""
		The method to set the value to locked_count

		Parameters:
			locked_count (bool) : A bool value
		"""
		self.__locked_count = locked_count
		self.__key_modified["locked_count"] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string value

		Returns:
			int: A int value
		"""
		return self.__key_modified.get(key)

	def set_key_modified(self, modification, key):
		"""
		The method to mark the given key as modified

		Parameters:
			modification (int) : A int value
			key (string) : A string value
		"""
		self.__key_modified[key] = modification
