import zipfile
from collections import abc
from io import BytesIO
from pandas._typing import FilePathOrBuffer as FilePathOrBuffer

from pandas.errors import AbstractMethodError as AbstractMethodError, DtypeWarning as DtypeWarning, EmptyDataError as EmptyDataError, ParserError as ParserError, ParserWarning as ParserWarning
from typing import Any, AnyStr, Dict, IO, Mapping, Optional, Tuple, Union, TypeVar
from urllib.parse import urlencode as urlencode

lzma: Any

T = TypeVar('T')

def is_url(url: Any) -> bool: ...
def validate_header_arg(header: Any) -> None: ...
def stringify_path(filepath_or_buffer: FilePathOrBuffer[AnyStr]) -> FilePathOrBuffer[AnyStr]: ...
def is_s3_url(url: Any) -> bool: ...
def is_gcs_url(url: Any) -> bool: ...
def urlopen(*args: Any, **kwargs: Any) -> Any: ...
def get_filepath_or_buffer(filepath_or_buffer: FilePathOrBuffer[T], encoding: Optional[str]=..., compression: Optional[str]=..., mode: Optional[str]=...) -> Any: ...
def file_path_to_url(path: str) -> str: ...
def get_compression_method(compression: Optional[Union[str, Mapping[str, str]]]) -> Tuple[Optional[str], Dict[str, str]]: ...
def infer_compression(filepath_or_buffer: FilePathOrBuffer[T], compression: Optional[str]) -> Optional[str]: ...
def get_handle(path_or_buf: Any, mode: str, encoding: Any = ..., compression: Optional[Union[str, Mapping[str, Any]]]=..., memory_map: bool=..., is_text: bool=...) -> Any: ...

class _BytesZipFile(zipfile.ZipFile, BytesIO):  # type: ignore
    archive_name: Any = ...
    def __init__(self, file: FilePathOrBuffer[T], mode: str, archive_name: Optional[str]=..., **kwargs: Any) -> None: ...
    def write(self, data: Any) -> None: ...  # type: ignore
    @property
    def closed(self) -> Any: ...

class _MMapWrapper(abc.Iterator[T]):
    mmap: Any = ...
    def __init__(self, f: IO[AnyStr]) -> None: ...
    def __getattr__(self, name: str) -> Any: ...
    def __iter__(self) -> _MMapWrapper[T]: ...
    def __next__(self) -> str: ...  # type: ignore
