# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'ServiceACLEntriesEntryArgs',
    'ServiceComputeBackendArgs',
    'ServiceComputeDictionaryArgs',
    'ServiceComputeDomainArgs',
    'ServiceComputeLoggingBigqueryArgs',
    'ServiceComputeLoggingBlobstorageArgs',
    'ServiceComputeLoggingCloudfileArgs',
    'ServiceComputeLoggingDatadogArgs',
    'ServiceComputeLoggingDigitaloceanArgs',
    'ServiceComputeLoggingElasticsearchArgs',
    'ServiceComputeLoggingFtpArgs',
    'ServiceComputeLoggingGcArgs',
    'ServiceComputeLoggingGooglepubsubArgs',
    'ServiceComputeLoggingHerokuArgs',
    'ServiceComputeLoggingHoneycombArgs',
    'ServiceComputeLoggingHttpArgs',
    'ServiceComputeLoggingKafkaArgs',
    'ServiceComputeLoggingKineseArgs',
    'ServiceComputeLoggingLogentryArgs',
    'ServiceComputeLoggingLogglyArgs',
    'ServiceComputeLoggingLogshuttleArgs',
    'ServiceComputeLoggingNewrelicArgs',
    'ServiceComputeLoggingOpenstackArgs',
    'ServiceComputeLoggingPapertrailArgs',
    'ServiceComputeLoggingS3Args',
    'ServiceComputeLoggingScalyrArgs',
    'ServiceComputeLoggingSftpArgs',
    'ServiceComputeLoggingSplunkArgs',
    'ServiceComputeLoggingSumologicArgs',
    'ServiceComputeLoggingSyslogArgs',
    'ServiceComputePackageArgs',
    'ServiceVclAclArgs',
    'ServiceVclBackendArgs',
    'ServiceVclCacheSettingArgs',
    'ServiceVclConditionArgs',
    'ServiceVclDictionaryArgs',
    'ServiceVclDirectorArgs',
    'ServiceVclDomainArgs',
    'ServiceVclDynamicsnippetArgs',
    'ServiceVclGzipArgs',
    'ServiceVclHeaderArgs',
    'ServiceVclHealthcheckArgs',
    'ServiceVclLoggingBigqueryArgs',
    'ServiceVclLoggingBlobstorageArgs',
    'ServiceVclLoggingCloudfileArgs',
    'ServiceVclLoggingDatadogArgs',
    'ServiceVclLoggingDigitaloceanArgs',
    'ServiceVclLoggingElasticsearchArgs',
    'ServiceVclLoggingFtpArgs',
    'ServiceVclLoggingGcArgs',
    'ServiceVclLoggingGooglepubsubArgs',
    'ServiceVclLoggingHerokusArgs',
    'ServiceVclLoggingHoneycombArgs',
    'ServiceVclLoggingHttpArgs',
    'ServiceVclLoggingKafkaArgs',
    'ServiceVclLoggingKineseArgs',
    'ServiceVclLoggingLogentryArgs',
    'ServiceVclLoggingLogglyArgs',
    'ServiceVclLoggingLogshuttleArgs',
    'ServiceVclLoggingNewrelicArgs',
    'ServiceVclLoggingOpenstackArgs',
    'ServiceVclLoggingPapertrailArgs',
    'ServiceVclLoggingS3Args',
    'ServiceVclLoggingScalyrArgs',
    'ServiceVclLoggingSftpArgs',
    'ServiceVclLoggingSplunkArgs',
    'ServiceVclLoggingSumologicArgs',
    'ServiceVclLoggingSyslogArgs',
    'ServiceVclRequestSettingArgs',
    'ServiceVclResponseObjectArgs',
    'ServiceVclSnippetArgs',
    'ServiceVclVclArgs',
    'ServiceVclWafArgs',
    'ServiceWafConfigurationRuleArgs',
    'ServiceWafConfigurationRuleExclusionArgs',
    'TlsSubscriptionManagedDnsChallengeArgs',
    'TlsSubscriptionManagedHttpChallengeArgs',
]

@pulumi.input_type
class ServiceACLEntriesEntryArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 negated: Optional[pulumi.Input[bool]] = None,
                 subnet: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip: An IP address that is the focus for the ACL
        :param pulumi.Input[str] comment: A personal freeform descriptive note
        :param pulumi.Input[str] id: The unique ID of the entry
        :param pulumi.Input[bool] negated: A boolean that will negate the match if true
        :param pulumi.Input[str] subnet: An optional subnet mask applied to the IP address
        """
        pulumi.set(__self__, "ip", ip)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        An IP address that is the focus for the ACL
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A personal freeform descriptive note
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID of the entry
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def negated(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean that will negate the match if true
        """
        return pulumi.get(self, "negated")

    @negated.setter
    def negated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negated", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        An optional subnet mask applied to the IP address
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class ServiceComputeBackendArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 auto_loadbalance: Optional[pulumi.Input[bool]] = None,
                 between_bytes_timeout: Optional[pulumi.Input[int]] = None,
                 connect_timeout: Optional[pulumi.Input[int]] = None,
                 error_threshold: Optional[pulumi.Input[int]] = None,
                 first_byte_timeout: Optional[pulumi.Input[int]] = None,
                 healthcheck: Optional[pulumi.Input[str]] = None,
                 max_conn: Optional[pulumi.Input[int]] = None,
                 max_tls_version: Optional[pulumi.Input[str]] = None,
                 min_tls_version: Optional[pulumi.Input[str]] = None,
                 override_host: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 shield: Optional[pulumi.Input[str]] = None,
                 ssl_ca_cert: Optional[pulumi.Input[str]] = None,
                 ssl_cert_hostname: Optional[pulumi.Input[str]] = None,
                 ssl_check_cert: Optional[pulumi.Input[bool]] = None,
                 ssl_ciphers: Optional[pulumi.Input[str]] = None,
                 ssl_client_cert: Optional[pulumi.Input[str]] = None,
                 ssl_client_key: Optional[pulumi.Input[str]] = None,
                 ssl_hostname: Optional[pulumi.Input[str]] = None,
                 ssl_sni_hostname: Optional[pulumi.Input[str]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: An IPv4, hostname, or IPv6 address for the Backend
        :param pulumi.Input[str] name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[bool] auto_loadbalance: Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        :param pulumi.Input[int] between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param pulumi.Input[int] connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param pulumi.Input[int] error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param pulumi.Input[int] first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param pulumi.Input[str] healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param pulumi.Input[int] max_conn: Maximum number of connections for this Backend. Default `200`
        :param pulumi.Input[str] max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param pulumi.Input[str] min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param pulumi.Input[str] override_host: The hostname to override the Host header
        :param pulumi.Input[int] port: The port number on which the Backend responds. Default `80`
        :param pulumi.Input[str] shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param pulumi.Input[str] ssl_ca_cert: CA certificate attached to origin.
        :param pulumi.Input[str] ssl_cert_hostname: Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all
        :param pulumi.Input[bool] ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param pulumi.Input[str] ssl_ciphers: Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        :param pulumi.Input[str] ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param pulumi.Input[str] ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param pulumi.Input[str] ssl_hostname: Used for both SNI during the TLS handshake and to validate the cert
        :param pulumi.Input[str] ssl_sni_hostname: Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all
        :param pulumi.Input[bool] use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param pulumi.Input[int] weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if auto_loadbalance is not None:
            pulumi.set(__self__, "auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_hostname is not None:
            warnings.warn("""Use ssl_cert_hostname and ssl_sni_hostname instead.""", DeprecationWarning)
            pulumi.log.warn("""ssl_hostname is deprecated: Use ssl_cert_hostname and ssl_sni_hostname instead.""")
        if ssl_hostname is not None:
            pulumi.set(__self__, "ssl_hostname", ssl_hostname)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        """
        return pulumi.get(self, "auto_loadbalance")

    @auto_loadbalance.setter
    def auto_loadbalance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_loadbalance", value)

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @between_bytes_timeout.setter
    def between_bytes_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "between_bytes_timeout", value)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @error_threshold.setter
    def error_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "error_threshold", value)

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @first_byte_timeout.setter
    def first_byte_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "first_byte_timeout", value)

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @healthcheck.setter
    def healthcheck(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "healthcheck", value)

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @max_conn.setter
    def max_conn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_conn", value)

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @max_tls_version.setter
    def max_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_tls_version", value)

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_tls_version", value)

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @override_host.setter
    def override_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "override_host", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def shield(self) -> Optional[pulumi.Input[str]]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @shield.setter
    def shield(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shield", value)

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @ssl_ca_cert.setter
    def ssl_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ca_cert", value)

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @ssl_cert_hostname.setter
    def ssl_cert_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_cert_hostname", value)

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[pulumi.Input[bool]]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @ssl_check_cert.setter
    def ssl_check_cert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_check_cert", value)

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[pulumi.Input[str]]:
        """
        Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        """
        return pulumi.get(self, "ssl_ciphers")

    @ssl_ciphers.setter
    def ssl_ciphers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ciphers", value)

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @ssl_client_cert.setter
    def ssl_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_client_cert", value)

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @ssl_client_key.setter
    def ssl_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_client_key", value)

    @property
    @pulumi.getter(name="sslHostname")
    def ssl_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Used for both SNI during the TLS handshake and to validate the cert
        """
        return pulumi.get(self, "ssl_hostname")

    @ssl_hostname.setter
    def ssl_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_hostname", value)

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @ssl_sni_hostname.setter
    def ssl_sni_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_sni_hostname", value)

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @use_ssl.setter
    def use_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ssl", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ServiceComputeDictionaryArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 dictionary_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 write_only: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary
        :param pulumi.Input[bool] force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @dictionary_id.setter
    def dictionary_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dictionary_id", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "write_only")

    @write_only.setter
    def write_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_only", value)


@pulumi.input_type
class ServiceComputeDomainArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param pulumi.Input[str] comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)


@pulumi.input_type
class ServiceComputeLoggingBigqueryArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 email: pulumi.Input[str],
                 name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 secret_key: pulumi.Input[str],
                 table: pulumi.Input[str],
                 template: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset: The ID of your BigQuery dataset
        :param pulumi.Input[str] email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param pulumi.Input[str] name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] project_id: The ID of your GCP project
        :param pulumi.Input[str] secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param pulumi.Input[str] table: The ID of your BigQuery table
        :param pulumi.Input[str] template: BigQuery table name suffix template
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[str]:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def table(self) -> pulumi.Input[str]:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: pulumi.Input[str]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class ServiceComputeLoggingBlobstorageArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 container: pulumi.Input[str],
                 name: pulumi.Input[str],
                 sas_token: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 file_max_bytes: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param pulumi.Input[str] container: The name of the Azure Blob Storage container in which to store logs
        :param pulumi.Input[str] name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[int] file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param pulumi.Input[int] period: How frequently the logs should be transferred in seconds. Default `3600`
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> pulumi.Input[str]:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "sas_token", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @file_max_bytes.setter
    def file_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_max_bytes", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceComputeLoggingCloudfileArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[str],
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 user: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_key: Your Cloud File account access key
        :param pulumi.Input[str] bucket_name: The name of your Cloud Files container
        :param pulumi.Input[str] name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] user: The username for your Cloud Files account
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: The path to upload logs to
        :param pulumi.Input[int] period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param pulumi.Input[str] public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[str]:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceComputeLoggingDatadogArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The API key from your Datadog account
        :param pulumi.Input[str] region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class ServiceComputeLoggingDigitaloceanArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[str],
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 secret_key: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_key: Your DigitalOcean Spaces account access key
        :param pulumi.Input[str] bucket_name: The name of the DigitalOcean Space
        :param pulumi.Input[str] name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] secret_key: Your DigitalOcean Spaces account secret key
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: The path to upload logs to
        :param pulumi.Input[int] period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[str]:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[str]:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceComputeLoggingElasticsearchArgs:
    def __init__(__self__, *,
                 index: pulumi.Input[str],
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 request_max_bytes: Optional[pulumi.Input[int]] = None,
                 request_max_entries: Optional[pulumi.Input[int]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] index: The name of the Elasticsearch index to send documents (logs) to
        :param pulumi.Input[str] name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] url: The Elasticsearch URL to stream logs to
        :param pulumi.Input[str] password: BasicAuth password for Elasticsearch
        :param pulumi.Input[str] pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param pulumi.Input[int] request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param pulumi.Input[int] request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param pulumi.Input[str] user: BasicAuth username for Elasticsearch
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> pulumi.Input[str]:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: pulumi.Input[str]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @request_max_bytes.setter
    def request_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_bytes", value)

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @request_max_entries.setter
    def request_max_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_entries", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceComputeLoggingFtpArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 path: pulumi.Input[str],
                 user: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The FTP address to stream logs to
        :param pulumi.Input[str] name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] password: The password for the server (for anonymous use an email address)
        :param pulumi.Input[str] path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param pulumi.Input[str] user: The username for the server (can be `anonymous`)
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[int] period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param pulumi.Input[int] port: The port number. Default: `21`
        :param pulumi.Input[str] public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceComputeLoggingGcArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: The name of the bucket in which to store the logs
        :param pulumi.Input[str] name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param pulumi.Input[int] period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param pulumi.Input[str] secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        :param pulumi.Input[str] user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceComputeLoggingGooglepubsubArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 secret_key: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 user: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] project_id: The ID of your Google Cloud Platform project
        :param pulumi.Input[str] secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param pulumi.Input[str] topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param pulumi.Input[str] user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[str]:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceComputeLoggingHerokuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param pulumi.Input[str] url: The URL to stream logs to
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ServiceComputeLoggingHoneycombArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 name: pulumi.Input[str],
                 token: pulumi.Input[str]):
        """
        :param pulumi.Input[str] dataset: The Honeycomb Dataset you want to log to
        :param pulumi.Input[str] name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The Write Key from the Account page of your Honeycomb account
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class ServiceComputeLoggingHttpArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 content_type: Optional[pulumi.Input[str]] = None,
                 header_name: Optional[pulumi.Input[str]] = None,
                 header_value: Optional[pulumi.Input[str]] = None,
                 json_format: Optional[pulumi.Input[str]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 request_max_bytes: Optional[pulumi.Input[int]] = None,
                 request_max_entries: Optional[pulumi.Input[int]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] url: URL that log data will be sent to. Must use the https protocol
        :param pulumi.Input[str] content_type: Value of the `Content-Type` header sent with the request
        :param pulumi.Input[str] header_name: Custom header sent with the request
        :param pulumi.Input[str] header_value: Value of the custom header sent with the request
        :param pulumi.Input[str] json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param pulumi.Input[int] request_max_bytes: The maximum number of bytes sent in one request
        :param pulumi.Input[int] request_max_entries: The maximum number of logs sent in one request
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_hostname: Used during the TLS handshake to validate the certificate
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_value", value)

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[pulumi.Input[str]]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @json_format.setter
    def json_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "json_format", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @request_max_bytes.setter
    def request_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_bytes", value)

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @request_max_entries.setter
    def request_max_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_entries", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)


@pulumi.input_type
class ServiceComputeLoggingKafkaArgs:
    def __init__(__self__, *,
                 brokers: pulumi.Input[str],
                 name: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 auth_method: Optional[pulumi.Input[str]] = None,
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 parse_log_keyvals: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 request_max_bytes: Optional[pulumi.Input[int]] = None,
                 required_acks: Optional[pulumi.Input[str]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None,
                 use_tls: Optional[pulumi.Input[bool]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param pulumi.Input[str] name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] topic: The Kafka topic to send logs to
        :param pulumi.Input[str] auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param pulumi.Input[bool] parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param pulumi.Input[str] password: SASL Pass
        :param pulumi.Input[int] request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param pulumi.Input[str] required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1`	Wait for all in-sync replicas to respond
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param pulumi.Input[bool] use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param pulumi.Input[str] user: SASL User
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if parse_log_keyvals is not None:
            pulumi.set(__self__, "parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def brokers(self) -> pulumi.Input[str]:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @brokers.setter
    def brokers(self, value: pulumi.Input[str]):
        pulumi.set(self, "brokers", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[str]]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_method", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @parse_log_keyvals.setter
    def parse_log_keyvals(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_log_keyvals", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @request_max_bytes.setter
    def request_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_bytes", value)

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[pulumi.Input[str]]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1`	Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @required_acks.setter
    def required_acks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "required_acks", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @use_tls.setter
    def use_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tls", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        SASL User
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceComputeLoggingKineseArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 access_key: Optional[pulumi.Input[str]] = None,
                 iam_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] topic: The Kinesis stream name
        :param pulumi.Input[str] access_key: The AWS access key to be used to write to the stream
        :param pulumi.Input[str] iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param pulumi.Input[str] region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param pulumi.Input[str] secret_key: The AWS secret access key to authenticate with
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)


@pulumi.input_type
class ServiceComputeLoggingLogentryArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 use_tls: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param pulumi.Input[int] port: The port number configured in Logentries
        :param pulumi.Input[bool] use_tls: Whether to use TLS for secure logging
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")

    @use_tls.setter
    def use_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tls", value)


@pulumi.input_type
class ServiceComputeLoggingLogglyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class ServiceComputeLoggingLogshuttleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The data authentication token associated with this endpoint
        :param pulumi.Input[str] url: Your Log Shuttle endpoint URL
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ServiceComputeLoggingNewrelicArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The Insert API key from the Account page of your New Relic account
        :param pulumi.Input[str] region: The region that log data will be sent to. Default: `US`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class ServiceComputeLoggingOpenstackArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[str],
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 user: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_key: Your OpenStack account access key
        :param pulumi.Input[str] bucket_name: The name of your OpenStack container
        :param pulumi.Input[str] name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] url: Your OpenStack auth url
        :param pulumi.Input[str] user: The username for your OpenStack account
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param pulumi.Input[int] period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[str]:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceComputeLoggingPapertrailArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 port: pulumi.Input[int]):
        """
        :param pulumi.Input[str] address: The address of the Papertrail endpoint
        :param pulumi.Input[str] name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[int] port: The port associated with the address where the Papertrail endpoint can be accessed
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ServiceComputeLoggingS3Args:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 acl: Optional[pulumi.Input[str]] = None,
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 redundancy: Optional[pulumi.Input[str]] = None,
                 s3_access_key: Optional[pulumi.Input[str]] = None,
                 s3_iam_role: Optional[pulumi.Input[str]] = None,
                 s3_secret_key: Optional[pulumi.Input[str]] = None,
                 server_side_encryption: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: The name of the bucket in which to store the logs
        :param pulumi.Input[str] name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param pulumi.Input[int] period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `reduced_redundancy`, `standard_ia`, or `onezone_ia`
        :param pulumi.Input[str] s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param pulumi.Input[str] s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param pulumi.Input[str] s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param pulumi.Input[str] server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param pulumi.Input[str] server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            pulumi.set(__self__, "s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `reduced_redundancy`, `standard_ia`, or `onezone_ia`
        """
        return pulumi.get(self, "redundancy")

    @redundancy.setter
    def redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy", value)

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @s3_access_key.setter
    def s3_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_access_key", value)

    @property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @s3_iam_role.setter
    def s3_iam_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_iam_role", value)

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @s3_secret_key.setter
    def s3_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_secret_key", value)

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_encryption", value)

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @server_side_encryption_kms_key_id.setter
    def server_side_encryption_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_encryption_kms_key_id", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceComputeLoggingScalyrArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The token to use for authentication (https://www.scalyr.com/keys)
        :param pulumi.Input[str] region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class ServiceComputeLoggingSftpArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 path: pulumi.Input[str],
                 ssh_known_hosts: pulumi.Input[str],
                 user: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The SFTP address to stream logs to
        :param pulumi.Input[str] name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param pulumi.Input[str] ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param pulumi.Input[str] user: The username for the server
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param pulumi.Input[int] period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param pulumi.Input[int] port: The port the SFTP service listens on. (Default: `22`)
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> pulumi.Input[str]:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @ssh_known_hosts.setter
    def ssh_known_hosts(self, value: pulumi.Input[str]):
        pulumi.set(self, "ssh_known_hosts", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceComputeLoggingSplunkArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 url: pulumi.Input[str],
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None,
                 use_tls: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The Splunk token to be used for authentication
        :param pulumi.Input[str] url: The Splunk URL to stream logs to
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param pulumi.Input[str] tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param pulumi.Input[bool] use_tls: Whether to use TLS for secure logging. Default: `false`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use TLS for secure logging. Default: `false`
        """
        return pulumi.get(self, "use_tls")

    @use_tls.setter
    def use_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tls", value)


@pulumi.input_type
class ServiceComputeLoggingSumologicArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 message_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] url: The URL to Sumologic collector endpoint
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)


@pulumi.input_type
class ServiceComputeLoggingSyslogArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 message_type: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 use_tls: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] address: A hostname or IPv4 address of the Syslog endpoint
        :param pulumi.Input[str] name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[int] port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param pulumi.Input[str] tls_hostname: Used during the TLS handshake to validate the certificate
        :param pulumi.Input[str] token: Whether to prepend each message with a specific token
        :param pulumi.Input[bool] use_tls: Whether to use TLS for secure logging. Default `false`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")

    @use_tls.setter
    def use_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tls", value)


@pulumi.input_type
class ServiceComputePackageArgs:
    def __init__(__self__, *,
                 filename: pulumi.Input[str],
                 source_code_hash: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] filename: The path to the Wasm deployment package within your local filesystem
        """
        pulumi.set(__self__, "filename", filename)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)

    @property
    @pulumi.getter
    def filename(self) -> pulumi.Input[str]:
        """
        The path to the Wasm deployment package within your local filesystem
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source_code_hash")

    @source_code_hash.setter
    def source_code_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_code_hash", value)


@pulumi.input_type
class ServiceVclAclArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 acl_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        :param pulumi.Input[str] acl_id: The ID of the ACL
        :param pulumi.Input[bool] force_destroy: Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ACL
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)


@pulumi.input_type
class ServiceVclBackendArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 auto_loadbalance: Optional[pulumi.Input[bool]] = None,
                 between_bytes_timeout: Optional[pulumi.Input[int]] = None,
                 connect_timeout: Optional[pulumi.Input[int]] = None,
                 error_threshold: Optional[pulumi.Input[int]] = None,
                 first_byte_timeout: Optional[pulumi.Input[int]] = None,
                 healthcheck: Optional[pulumi.Input[str]] = None,
                 max_conn: Optional[pulumi.Input[int]] = None,
                 max_tls_version: Optional[pulumi.Input[str]] = None,
                 min_tls_version: Optional[pulumi.Input[str]] = None,
                 override_host: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 request_condition: Optional[pulumi.Input[str]] = None,
                 shield: Optional[pulumi.Input[str]] = None,
                 ssl_ca_cert: Optional[pulumi.Input[str]] = None,
                 ssl_cert_hostname: Optional[pulumi.Input[str]] = None,
                 ssl_check_cert: Optional[pulumi.Input[bool]] = None,
                 ssl_ciphers: Optional[pulumi.Input[str]] = None,
                 ssl_client_cert: Optional[pulumi.Input[str]] = None,
                 ssl_client_key: Optional[pulumi.Input[str]] = None,
                 ssl_hostname: Optional[pulumi.Input[str]] = None,
                 ssl_sni_hostname: Optional[pulumi.Input[str]] = None,
                 use_ssl: Optional[pulumi.Input[bool]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: An IPv4, hostname, or IPv6 address for the Backend
        :param pulumi.Input[str] name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[bool] auto_loadbalance: Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        :param pulumi.Input[int] between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param pulumi.Input[int] connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param pulumi.Input[int] error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param pulumi.Input[int] first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param pulumi.Input[str] healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param pulumi.Input[int] max_conn: Maximum number of connections for this Backend. Default `200`
        :param pulumi.Input[str] max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param pulumi.Input[str] min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param pulumi.Input[str] override_host: The hostname to override the Host header
        :param pulumi.Input[int] port: The port number on which the Backend responds. Default `80`
        :param pulumi.Input[str] request_condition: Name of a condition, which if met, will select this backend during a request.
        :param pulumi.Input[str] shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param pulumi.Input[str] ssl_ca_cert: CA certificate attached to origin.
        :param pulumi.Input[str] ssl_cert_hostname: Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all
        :param pulumi.Input[bool] ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param pulumi.Input[str] ssl_ciphers: Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        :param pulumi.Input[str] ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param pulumi.Input[str] ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param pulumi.Input[str] ssl_hostname: Used for both SNI during the TLS handshake and to validate the cert
        :param pulumi.Input[str] ssl_sni_hostname: Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all
        :param pulumi.Input[bool] use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param pulumi.Input[int] weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if auto_loadbalance is not None:
            pulumi.set(__self__, "auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_hostname is not None:
            warnings.warn("""Use ssl_cert_hostname and ssl_sni_hostname instead.""", DeprecationWarning)
            pulumi.log.warn("""ssl_hostname is deprecated: Use ssl_cert_hostname and ssl_sni_hostname instead.""")
        if ssl_hostname is not None:
            pulumi.set(__self__, "ssl_hostname", ssl_hostname)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        """
        return pulumi.get(self, "auto_loadbalance")

    @auto_loadbalance.setter
    def auto_loadbalance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_loadbalance", value)

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @between_bytes_timeout.setter
    def between_bytes_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "between_bytes_timeout", value)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @error_threshold.setter
    def error_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "error_threshold", value)

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @first_byte_timeout.setter
    def first_byte_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "first_byte_timeout", value)

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @healthcheck.setter
    def healthcheck(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "healthcheck", value)

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @max_conn.setter
    def max_conn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_conn", value)

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @max_tls_version.setter
    def max_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_tls_version", value)

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_tls_version", value)

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @override_host.setter
    def override_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "override_host", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a condition, which if met, will select this backend during a request.
        """
        return pulumi.get(self, "request_condition")

    @request_condition.setter
    def request_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_condition", value)

    @property
    @pulumi.getter
    def shield(self) -> Optional[pulumi.Input[str]]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @shield.setter
    def shield(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shield", value)

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @ssl_ca_cert.setter
    def ssl_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ca_cert", value)

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @ssl_cert_hostname.setter
    def ssl_cert_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_cert_hostname", value)

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[pulumi.Input[bool]]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @ssl_check_cert.setter
    def ssl_check_cert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_check_cert", value)

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[pulumi.Input[str]]:
        """
        Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        """
        return pulumi.get(self, "ssl_ciphers")

    @ssl_ciphers.setter
    def ssl_ciphers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ciphers", value)

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @ssl_client_cert.setter
    def ssl_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_client_cert", value)

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @ssl_client_key.setter
    def ssl_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_client_key", value)

    @property
    @pulumi.getter(name="sslHostname")
    def ssl_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Used for both SNI during the TLS handshake and to validate the cert
        """
        return pulumi.get(self, "ssl_hostname")

    @ssl_hostname.setter
    def ssl_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_hostname", value)

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @ssl_sni_hostname.setter
    def ssl_sni_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_sni_hostname", value)

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @use_ssl.setter
    def use_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ssl", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ServiceVclCacheSettingArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 cache_condition: Optional[pulumi.Input[str]] = None,
                 stale_ttl: Optional[pulumi.Input[int]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] action: One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        :param pulumi.Input[str] cache_condition: Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        :param pulumi.Input[int] stale_ttl: Max "Time To Live" for stale (unreachable) objects
        :param pulumi.Input[int] ttl: The Time-To-Live (TTL) for the object
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if stale_ttl is not None:
            pulumi.set(__self__, "stale_ttl", stale_ttl)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @cache_condition.setter
    def cache_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_condition", value)

    @property
    @pulumi.getter(name="staleTtl")
    def stale_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Max "Time To Live" for stale (unreachable) objects
        """
        return pulumi.get(self, "stale_ttl")

    @stale_ttl.setter
    def stale_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stale_ttl", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The Time-To-Live (TTL) for the object
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class ServiceVclConditionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 statement: pulumi.Input[str],
                 type: pulumi.Input[str],
                 priority: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] statement: The statement used to determine if the condition is met
        :param pulumi.Input[str] type: Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        :param pulumi.Input[int] priority: A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def statement(self) -> pulumi.Input[str]:
        """
        The statement used to determine if the condition is met
        """
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: pulumi.Input[str]):
        pulumi.set(self, "statement", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class ServiceVclDictionaryArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 dictionary_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 write_only: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary
        :param pulumi.Input[bool] force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @dictionary_id.setter
    def dictionary_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dictionary_id", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "write_only")

    @write_only.setter
    def write_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_only", value)


@pulumi.input_type
class ServiceVclDirectorArgs:
    def __init__(__self__, *,
                 backends: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 quorum: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 shield: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backends: Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        :param pulumi.Input[str] name: Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] comment: An optional comment about the Director
        :param pulumi.Input[int] quorum: Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        :param pulumi.Input[int] retries: How many backends to search if it fails. Default `5`
        :param pulumi.Input[str] shield: Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        :param pulumi.Input[int] type: Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if quorum is not None:
            pulumi.set(__self__, "quorum", quorum)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def backends(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        An optional comment about the Director
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def quorum(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        """
        return pulumi.get(self, "quorum")

    @quorum.setter
    def quorum(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quorum", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        How many backends to search if it fails. Default `5`
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def shield(self) -> Optional[pulumi.Input[str]]:
        """
        Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        """
        return pulumi.get(self, "shield")

    @shield.setter
    def shield(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shield", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceVclDomainArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param pulumi.Input[str] comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)


@pulumi.input_type
class ServiceVclDynamicsnippetArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 priority: Optional[pulumi.Input[int]] = None,
                 snippet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param pulumi.Input[int] priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        :param pulumi.Input[str] snippet_id: The ID of the dynamic snippet
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if snippet_id is not None:
            pulumi.set(__self__, "snippet_id", snippet_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dynamic snippet
        """
        return pulumi.get(self, "snippet_id")

    @snippet_id.setter
    def snippet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snippet_id", value)


@pulumi.input_type
class ServiceVclGzipArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 cache_condition: Optional[pulumi.Input[str]] = None,
                 content_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] name: A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] cache_condition: Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] content_types: The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] extensions: File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content_types is not None:
            pulumi.set(__self__, "content_types", content_types)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @cache_condition.setter
    def cache_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_condition", value)

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        """
        return pulumi.get(self, "content_types")

    @content_types.setter
    def content_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "content_types", value)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "extensions", value)


@pulumi.input_type
class ServiceVclHeaderArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 destination: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 cache_condition: Optional[pulumi.Input[str]] = None,
                 ignore_if_set: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 regex: Optional[pulumi.Input[str]] = None,
                 request_condition: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 substitution: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        :param pulumi.Input[str] destination: The name of the header that is going to be affected by the Action
        :param pulumi.Input[str] name: Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] type: The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        :param pulumi.Input[str] cache_condition: Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        :param pulumi.Input[bool] ignore_if_set: Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        :param pulumi.Input[int] priority: Lower priorities execute first. Default: `100`
        :param pulumi.Input[str] regex: Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        :param pulumi.Input[str] request_condition: Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        :param pulumi.Input[str] response_condition: Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param pulumi.Input[str] source: Variable to be used as a source for the header content (Does not apply to `delete` action.)
        :param pulumi.Input[str] substitution: Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if ignore_if_set is not None:
            pulumi.set(__self__, "ignore_if_set", ignore_if_set)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitution is not None:
            pulumi.set(__self__, "substitution", substitution)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        The name of the header that is going to be affected by the Action
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @cache_condition.setter
    def cache_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_condition", value)

    @property
    @pulumi.getter(name="ignoreIfSet")
    def ignore_if_set(self) -> Optional[pulumi.Input[bool]]:
        """
        Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        """
        return pulumi.get(self, "ignore_if_set")

    @ignore_if_set.setter
    def ignore_if_set(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_if_set", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Lower priorities execute first. Default: `100`
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @request_condition.setter
    def request_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_condition", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Variable to be used as a source for the header content (Does not apply to `delete` action.)
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def substitution(self) -> Optional[pulumi.Input[str]]:
        """
        Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        return pulumi.get(self, "substitution")

    @substitution.setter
    def substitution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "substitution", value)


@pulumi.input_type
class ServiceVclHealthcheckArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 name: pulumi.Input[str],
                 path: pulumi.Input[str],
                 check_interval: Optional[pulumi.Input[int]] = None,
                 expected_response: Optional[pulumi.Input[int]] = None,
                 http_version: Optional[pulumi.Input[str]] = None,
                 initial: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 window: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] host: The Host header to send for this Healthcheck
        :param pulumi.Input[str] name: A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] path: The path to check
        :param pulumi.Input[int] check_interval: How often to run the Healthcheck in milliseconds. Default `5000`
        :param pulumi.Input[int] expected_response: The status code expected from the host. Default `200`
        :param pulumi.Input[str] http_version: Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        :param pulumi.Input[int] initial: When loading a config, the initial number of probes to be seen as OK. Default `3`
        :param pulumi.Input[str] method: Which HTTP method to use. Default `HEAD`
        :param pulumi.Input[int] threshold: How many Healthchecks must succeed to be considered healthy. Default `3`
        :param pulumi.Input[int] timeout: Timeout in milliseconds. Default `500`
        :param pulumi.Input[int] window: The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if expected_response is not None:
            pulumi.set(__self__, "expected_response", expected_response)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        The Host header to send for this Healthcheck
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path to check
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[pulumi.Input[int]]:
        """
        How often to run the Healthcheck in milliseconds. Default `5000`
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "check_interval", value)

    @property
    @pulumi.getter(name="expectedResponse")
    def expected_response(self) -> Optional[pulumi.Input[int]]:
        """
        The status code expected from the host. Default `200`
        """
        return pulumi.get(self, "expected_response")

    @expected_response.setter
    def expected_response(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_response", value)

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_version", value)

    @property
    @pulumi.getter
    def initial(self) -> Optional[pulumi.Input[int]]:
        """
        When loading a config, the initial number of probes to be seen as OK. Default `3`
        """
        return pulumi.get(self, "initial")

    @initial.setter
    def initial(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        Which HTTP method to use. Default `HEAD`
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[int]]:
        """
        How many Healthchecks must succeed to be considered healthy. Default `3`
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout in milliseconds. Default `500`
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input[int]]:
        """
        The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "window", value)


@pulumi.input_type
class ServiceVclLoggingBigqueryArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 email: pulumi.Input[str],
                 name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 secret_key: pulumi.Input[str],
                 table: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset: The ID of your BigQuery dataset
        :param pulumi.Input[str] email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param pulumi.Input[str] name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] project_id: The ID of your GCP project
        :param pulumi.Input[str] secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param pulumi.Input[str] table: The ID of your BigQuery table
        :param pulumi.Input[str] format: The logging format desired.
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[str] response_condition: Name of a condition to apply this logging.
        :param pulumi.Input[str] template: BigQuery table name suffix template
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[str]:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def table(self) -> pulumi.Input[str]:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: pulumi.Input[str]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The logging format desired.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class ServiceVclLoggingBlobstorageArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 container: pulumi.Input[str],
                 name: pulumi.Input[str],
                 sas_token: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 file_max_bytes: Optional[pulumi.Input[int]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param pulumi.Input[str] container: The name of the Azure Blob Storage container in which to store logs
        :param pulumi.Input[str] name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[int] file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param pulumi.Input[int] period: How frequently the logs should be transferred in seconds. Default `3600`
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] response_condition: The name of the condition to apply
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> pulumi.Input[str]:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "sas_token", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @file_max_bytes.setter
    def file_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_max_bytes", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceVclLoggingCloudfileArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[str],
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 user: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_key: Your Cloud File account access key
        :param pulumi.Input[str] bucket_name: The name of your Cloud Files container
        :param pulumi.Input[str] name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] user: The username for your Cloud Files account
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] format: Apache style log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: The path to upload logs to
        :param pulumi.Input[int] period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param pulumi.Input[str] public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[str]:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceVclLoggingDatadogArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The API key from your Datadog account
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[str] region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param pulumi.Input[str] response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingDigitaloceanArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[str],
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 secret_key: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_key: Your DigitalOcean Spaces account access key
        :param pulumi.Input[str] bucket_name: The name of the DigitalOcean Space
        :param pulumi.Input[str] name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] secret_key: Your DigitalOcean Spaces account secret key
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param pulumi.Input[str] format: Apache style log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: The path to upload logs to
        :param pulumi.Input[int] period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[str]:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[str]:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceVclLoggingElasticsearchArgs:
    def __init__(__self__, *,
                 index: pulumi.Input[str],
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 request_max_bytes: Optional[pulumi.Input[int]] = None,
                 request_max_entries: Optional[pulumi.Input[int]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] index: The name of the Elasticsearch index to send documents (logs) to
        :param pulumi.Input[str] name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] url: The Elasticsearch URL to stream logs to
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param pulumi.Input[str] password: BasicAuth password for Elasticsearch
        :param pulumi.Input[str] pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[int] request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param pulumi.Input[int] request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param pulumi.Input[str] response_condition: The name of the condition to apply
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param pulumi.Input[str] user: BasicAuth username for Elasticsearch
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> pulumi.Input[str]:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: pulumi.Input[str]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @request_max_bytes.setter
    def request_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_bytes", value)

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @request_max_entries.setter
    def request_max_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_entries", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceVclLoggingFtpArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 path: pulumi.Input[str],
                 user: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The FTP address to stream logs to
        :param pulumi.Input[str] name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] password: The password for the server (for anonymous use an email address)
        :param pulumi.Input[str] path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param pulumi.Input[str] user: The username for the server (can be `anonymous`)
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[int] period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[int] port: The port number. Default: `21`
        :param pulumi.Input[str] public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] response_condition: The name of the condition to apply.
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceVclLoggingGcArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: The name of the bucket in which to store the logs
        :param pulumi.Input[str] name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param pulumi.Input[int] period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[str] response_condition: Name of a condition to apply this logging.
        :param pulumi.Input[str] secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        :param pulumi.Input[str] user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceVclLoggingGooglepubsubArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 secret_key: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 user: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] project_id: The ID of your Google Cloud Platform project
        :param pulumi.Input[str] secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param pulumi.Input[str] topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param pulumi.Input[str] user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        :param pulumi.Input[str] format: Apache style log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[str]:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingHerokusArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 url: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param pulumi.Input[str] url: The URL to stream logs to
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingHoneycombArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset: The Honeycomb Dataset you want to log to
        :param pulumi.Input[str] name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The Write Key from the Account page of your Honeycomb account
        :param pulumi.Input[str] format: Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingHttpArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 content_type: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 header_name: Optional[pulumi.Input[str]] = None,
                 header_value: Optional[pulumi.Input[str]] = None,
                 json_format: Optional[pulumi.Input[str]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 request_max_bytes: Optional[pulumi.Input[int]] = None,
                 request_max_entries: Optional[pulumi.Input[int]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] url: URL that log data will be sent to. Must use the https protocol
        :param pulumi.Input[str] content_type: Value of the `Content-Type` header sent with the request
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param pulumi.Input[str] header_name: Custom header sent with the request
        :param pulumi.Input[str] header_value: Value of the custom header sent with the request
        :param pulumi.Input[str] json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed
        :param pulumi.Input[int] request_max_bytes: The maximum number of bytes sent in one request
        :param pulumi.Input[int] request_max_entries: The maximum number of logs sent in one request
        :param pulumi.Input[str] response_condition: The name of the condition to apply
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_hostname: Used during the TLS handshake to validate the certificate
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_value", value)

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[pulumi.Input[str]]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @json_format.setter
    def json_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "json_format", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @request_max_bytes.setter
    def request_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_bytes", value)

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @request_max_entries.setter
    def request_max_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_entries", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)


@pulumi.input_type
class ServiceVclLoggingKafkaArgs:
    def __init__(__self__, *,
                 brokers: pulumi.Input[str],
                 name: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 auth_method: Optional[pulumi.Input[str]] = None,
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 parse_log_keyvals: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 request_max_bytes: Optional[pulumi.Input[int]] = None,
                 required_acks: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None,
                 use_tls: Optional[pulumi.Input[bool]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param pulumi.Input[str] name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] topic: The Kafka topic to send logs to
        :param pulumi.Input[str] auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param pulumi.Input[str] format: Apache style log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param pulumi.Input[bool] parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param pulumi.Input[str] password: SASL Pass
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[int] request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param pulumi.Input[str] required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1`	Wait for all in-sync replicas to respond
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param pulumi.Input[str] tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param pulumi.Input[bool] use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param pulumi.Input[str] user: SASL User
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if parse_log_keyvals is not None:
            pulumi.set(__self__, "parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def brokers(self) -> pulumi.Input[str]:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @brokers.setter
    def brokers(self, value: pulumi.Input[str]):
        pulumi.set(self, "brokers", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[str]]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_method", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @parse_log_keyvals.setter
    def parse_log_keyvals(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_log_keyvals", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @request_max_bytes.setter
    def request_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_max_bytes", value)

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[pulumi.Input[str]]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1`	Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @required_acks.setter
    def required_acks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "required_acks", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @use_tls.setter
    def use_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tls", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        SASL User
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceVclLoggingKineseArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 access_key: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 iam_role: Optional[pulumi.Input[str]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] topic: The Kinesis stream name
        :param pulumi.Input[str] access_key: The AWS access key to be used to write to the stream
        :param pulumi.Input[str] format: Apache style log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[str] iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param pulumi.Input[str] region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param pulumi.Input[str] secret_key: The AWS secret access key to authenticate with
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)


@pulumi.input_type
class ServiceVclLoggingLogentryArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 use_tls: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[int] port: The port number configured in Logentries
        :param pulumi.Input[str] response_condition: Name of blockAttributes condition to apply this logging.
        :param pulumi.Input[bool] use_tls: Whether to use TLS for secure logging
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")

    @use_tls.setter
    def use_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tls", value)


@pulumi.input_type
class ServiceVclLoggingLogglyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingLogshuttleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 url: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The data authentication token associated with this endpoint
        :param pulumi.Input[str] url: Your Log Shuttle endpoint URL
        :param pulumi.Input[str] format: Apache style log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingNewrelicArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The Insert API key from the Account page of your New Relic account
        :param pulumi.Input[str] format: Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[str] region: The region that log data will be sent to. Default: `US`
        :param pulumi.Input[str] response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingOpenstackArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[str],
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 user: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] access_key: Your OpenStack account access key
        :param pulumi.Input[str] bucket_name: The name of your OpenStack container
        :param pulumi.Input[str] name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] url: Your OpenStack auth url
        :param pulumi.Input[str] user: The username for your OpenStack account
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] format: Apache style log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param pulumi.Input[int] period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[str]:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceVclLoggingPapertrailArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The address of the Papertrail endpoint
        :param pulumi.Input[str] name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[int] port: The port associated with the address where the Papertrail endpoint can be accessed
        :param pulumi.Input[str] format: A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingS3Args:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 acl: Optional[pulumi.Input[str]] = None,
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 redundancy: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 s3_access_key: Optional[pulumi.Input[str]] = None,
                 s3_iam_role: Optional[pulumi.Input[str]] = None,
                 s3_secret_key: Optional[pulumi.Input[str]] = None,
                 server_side_encryption: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: The name of the bucket in which to store the logs
        :param pulumi.Input[str] name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2).
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param pulumi.Input[int] period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `reduced_redundancy`, `standard_ia`, or `onezone_ia`
        :param pulumi.Input[str] response_condition: Name of blockAttributes condition to apply this logging.
        :param pulumi.Input[str] s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param pulumi.Input[str] s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param pulumi.Input[str] s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param pulumi.Input[str] server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param pulumi.Input[str] server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            pulumi.set(__self__, "s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `reduced_redundancy`, `standard_ia`, or `onezone_ia`
        """
        return pulumi.get(self, "redundancy")

    @redundancy.setter
    def redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundancy", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @s3_access_key.setter
    def s3_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_access_key", value)

    @property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @s3_iam_role.setter
    def s3_iam_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_iam_role", value)

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @s3_secret_key.setter
    def s3_secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_secret_key", value)

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_encryption", value)

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @server_side_encryption_kms_key_id.setter
    def server_side_encryption_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_encryption_kms_key_id", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceVclLoggingScalyrArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The token to use for authentication (https://www.scalyr.com/keys)
        :param pulumi.Input[str] format: Apache style log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[str] region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param pulumi.Input[str] response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingSftpArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 path: pulumi.Input[str],
                 ssh_known_hosts: pulumi.Input[str],
                 user: pulumi.Input[str],
                 compression_codec: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 gzip_level: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: The SFTP address to stream logs to
        :param pulumi.Input[str] name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param pulumi.Input[str] ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param pulumi.Input[str] user: The username for the server
        :param pulumi.Input[str] compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting.
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param pulumi.Input[int] gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param pulumi.Input[int] period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[int] port: The port the SFTP service listens on. (Default: `22`)
        :param pulumi.Input[str] public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param pulumi.Input[str] response_condition: The name of the condition to apply.
        :param pulumi.Input[str] secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param pulumi.Input[str] timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> pulumi.Input[str]:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @ssh_known_hosts.setter
    def ssh_known_hosts(self, value: pulumi.Input[str]):
        pulumi.set(self, "ssh_known_hosts", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[str]]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_codec", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[pulumi.Input[int]]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @gzip_level.setter
    def gzip_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gzip_level", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)


@pulumi.input_type
class ServiceVclLoggingSplunkArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 token: pulumi.Input[str],
                 url: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None,
                 use_tls: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] token: The Splunk token to be used for authentication
        :param pulumi.Input[str] url: The Splunk URL to stream logs to
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed
        :param pulumi.Input[str] response_condition: The name of the condition to apply
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param pulumi.Input[str] tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param pulumi.Input[bool] use_tls: Whether to use TLS for secure logging. Default: `false`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use TLS for secure logging. Default: `false`
        """
        return pulumi.get(self, "use_tls")

    @use_tls.setter
    def use_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tls", value)


@pulumi.input_type
class ServiceVclLoggingSumologicArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] url: The URL to Sumologic collector endpoint
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting
        :param pulumi.Input[int] format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[str] response_condition: Name of blockAttributes condition to apply this logging.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)


@pulumi.input_type
class ServiceVclLoggingSyslogArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 format: Optional[pulumi.Input[str]] = None,
                 format_version: Optional[pulumi.Input[int]] = None,
                 message_type: Optional[pulumi.Input[str]] = None,
                 placement: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 response_condition: Optional[pulumi.Input[str]] = None,
                 tls_ca_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_cert: Optional[pulumi.Input[str]] = None,
                 tls_client_key: Optional[pulumi.Input[str]] = None,
                 tls_hostname: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 use_tls: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] address: A hostname or IPv4 address of the Syslog endpoint
        :param pulumi.Input[str] name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] format: Apache-style string or VCL variables to use for log formatting
        :param pulumi.Input[int] format_version: The version of the custom logging format. Can be either 1 or 2. (Default: 2)
        :param pulumi.Input[str] message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param pulumi.Input[str] placement: Where in the generated VCL the logging call should be placed.
        :param pulumi.Input[int] port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param pulumi.Input[str] response_condition: Name of blockAttributes condition to apply this logging.
        :param pulumi.Input[str] tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param pulumi.Input[str] tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param pulumi.Input[str] tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param pulumi.Input[str] tls_hostname: Used during the TLS handshake to validate the certificate
        :param pulumi.Input[str] token: Whether to prepend each message with a specific token
        :param pulumi.Input[bool] use_tls: Whether to use TLS for secure logging. Default `false`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the custom logging format. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "format_version", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[str]]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input[str]]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @response_condition.setter
    def response_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_condition", value)

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @tls_ca_cert.setter
    def tls_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ca_cert", value)

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_cert", value)

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key", value)

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @tls_hostname.setter
    def tls_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_hostname", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")

    @use_tls.setter
    def use_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tls", value)


@pulumi.input_type
class ServiceVclRequestSettingArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 bypass_busy_wait: Optional[pulumi.Input[bool]] = None,
                 default_host: Optional[pulumi.Input[str]] = None,
                 force_miss: Optional[pulumi.Input[bool]] = None,
                 force_ssl: Optional[pulumi.Input[bool]] = None,
                 geo_headers: Optional[pulumi.Input[bool]] = None,
                 hash_keys: Optional[pulumi.Input[str]] = None,
                 max_stale_age: Optional[pulumi.Input[int]] = None,
                 request_condition: Optional[pulumi.Input[str]] = None,
                 timer_support: Optional[pulumi.Input[bool]] = None,
                 xff: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] action: Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        :param pulumi.Input[bool] bypass_busy_wait: Disable collapsed forwarding, so you don't wait for other objects to origin
        :param pulumi.Input[str] default_host: Sets the host header
        :param pulumi.Input[bool] force_miss: Force a cache miss for the request. If specified, can be `true` or `false`
        :param pulumi.Input[bool] force_ssl: Forces the request to use SSL (Redirects a non-SSL request to SSL)
        :param pulumi.Input[bool] geo_headers: Injects Fastly-Geo-Country, Fastly-Geo-City, and Fastly-Geo-Region into the request headers
        :param pulumi.Input[str] hash_keys: Comma separated list of varnish request object fields that should be in the hash key
        :param pulumi.Input[int] max_stale_age: How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        :param pulumi.Input[str] request_condition: Name of already defined `condition` to determine if this request setting should be applied
        :param pulumi.Input[bool] timer_support: Injects the X-Timer info into the request for viewing origin fetch durations
        :param pulumi.Input[str] xff: X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bypass_busy_wait is not None:
            pulumi.set(__self__, "bypass_busy_wait", bypass_busy_wait)
        if default_host is not None:
            pulumi.set(__self__, "default_host", default_host)
        if force_miss is not None:
            pulumi.set(__self__, "force_miss", force_miss)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if geo_headers is not None:
            warnings.warn("""'geo_headers' attribute has been deprecated and will be removed in the next major version release""", DeprecationWarning)
            pulumi.log.warn("""geo_headers is deprecated: 'geo_headers' attribute has been deprecated and will be removed in the next major version release""")
        if geo_headers is not None:
            pulumi.set(__self__, "geo_headers", geo_headers)
        if hash_keys is not None:
            pulumi.set(__self__, "hash_keys", hash_keys)
        if max_stale_age is not None:
            pulumi.set(__self__, "max_stale_age", max_stale_age)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if timer_support is not None:
            pulumi.set(__self__, "timer_support", timer_support)
        if xff is not None:
            pulumi.set(__self__, "xff", xff)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="bypassBusyWait")
    def bypass_busy_wait(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable collapsed forwarding, so you don't wait for other objects to origin
        """
        return pulumi.get(self, "bypass_busy_wait")

    @bypass_busy_wait.setter
    def bypass_busy_wait(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bypass_busy_wait", value)

    @property
    @pulumi.getter(name="defaultHost")
    def default_host(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the host header
        """
        return pulumi.get(self, "default_host")

    @default_host.setter
    def default_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_host", value)

    @property
    @pulumi.getter(name="forceMiss")
    def force_miss(self) -> Optional[pulumi.Input[bool]]:
        """
        Force a cache miss for the request. If specified, can be `true` or `false`
        """
        return pulumi.get(self, "force_miss")

    @force_miss.setter
    def force_miss(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_miss", value)

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces the request to use SSL (Redirects a non-SSL request to SSL)
        """
        return pulumi.get(self, "force_ssl")

    @force_ssl.setter
    def force_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_ssl", value)

    @property
    @pulumi.getter(name="geoHeaders")
    def geo_headers(self) -> Optional[pulumi.Input[bool]]:
        """
        Injects Fastly-Geo-Country, Fastly-Geo-City, and Fastly-Geo-Region into the request headers
        """
        return pulumi.get(self, "geo_headers")

    @geo_headers.setter
    def geo_headers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "geo_headers", value)

    @property
    @pulumi.getter(name="hashKeys")
    def hash_keys(self) -> Optional[pulumi.Input[str]]:
        """
        Comma separated list of varnish request object fields that should be in the hash key
        """
        return pulumi.get(self, "hash_keys")

    @hash_keys.setter
    def hash_keys(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hash_keys", value)

    @property
    @pulumi.getter(name="maxStaleAge")
    def max_stale_age(self) -> Optional[pulumi.Input[int]]:
        """
        How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        """
        return pulumi.get(self, "max_stale_age")

    @max_stale_age.setter
    def max_stale_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_stale_age", value)

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of already defined `condition` to determine if this request setting should be applied
        """
        return pulumi.get(self, "request_condition")

    @request_condition.setter
    def request_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_condition", value)

    @property
    @pulumi.getter(name="timerSupport")
    def timer_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Injects the X-Timer info into the request for viewing origin fetch durations
        """
        return pulumi.get(self, "timer_support")

    @timer_support.setter
    def timer_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "timer_support", value)

    @property
    @pulumi.getter
    def xff(self) -> Optional[pulumi.Input[str]]:
        """
        X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        return pulumi.get(self, "xff")

    @xff.setter
    def xff(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xff", value)


@pulumi.input_type
class ServiceVclResponseObjectArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 cache_condition: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 request_condition: Optional[pulumi.Input[str]] = None,
                 response: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param pulumi.Input[str] content: The content to deliver for the response object
        :param pulumi.Input[str] content_type: The MIME type of the content
        :param pulumi.Input[str] request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        :param pulumi.Input[str] response: The HTTP Response. Default `OK`
        :param pulumi.Input[int] status: The HTTP Status Code. Default `200`
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @cache_condition.setter
    def cache_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_condition", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The content to deliver for the response object
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        The MIME type of the content
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @request_condition.setter
    def request_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_condition", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP Response. Default `OK`
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP Status Code. Default `200`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ServiceVclSnippetArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 priority: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] content: The VCL code that specifies exactly what the snippet does
        :param pulumi.Input[str] name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[str] type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param pulumi.Input[int] priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class ServiceVclVclArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 name: pulumi.Input[str],
                 main: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] content: The custom VCL code to upload
        :param pulumi.Input[str] name: A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        :param pulumi.Input[bool] main: If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        if main is not None:
            pulumi.set(__self__, "main", main)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        The custom VCL code to upload
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def main(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        return pulumi.get(self, "main")

    @main.setter
    def main(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "main", value)


@pulumi.input_type
class ServiceVclWafArgs:
    def __init__(__self__, *,
                 response_object: pulumi.Input[str],
                 disabled: Optional[pulumi.Input[bool]] = None,
                 prefetch_condition: Optional[pulumi.Input[str]] = None,
                 waf_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] response_object: The name of the response object used by the Web Application Firewall
        :param pulumi.Input[bool] disabled: A flag used to completely disable a Web Application Firewall. This is intended to only be used in an emergency
        :param pulumi.Input[str] prefetch_condition: The `condition` to determine which requests will be run past your Fastly WAF. This `condition` must be of type `PREFETCH`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param pulumi.Input[str] waf_id: The ID of the WAF
        """
        pulumi.set(__self__, "response_object", response_object)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if prefetch_condition is not None:
            pulumi.set(__self__, "prefetch_condition", prefetch_condition)
        if waf_id is not None:
            pulumi.set(__self__, "waf_id", waf_id)

    @property
    @pulumi.getter(name="responseObject")
    def response_object(self) -> pulumi.Input[str]:
        """
        The name of the response object used by the Web Application Firewall
        """
        return pulumi.get(self, "response_object")

    @response_object.setter
    def response_object(self, value: pulumi.Input[str]):
        pulumi.set(self, "response_object", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag used to completely disable a Web Application Firewall. This is intended to only be used in an emergency
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="prefetchCondition")
    def prefetch_condition(self) -> Optional[pulumi.Input[str]]:
        """
        The `condition` to determine which requests will be run past your Fastly WAF. This `condition` must be of type `PREFETCH`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "prefetch_condition")

    @prefetch_condition.setter
    def prefetch_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefetch_condition", value)

    @property
    @pulumi.getter(name="wafId")
    def waf_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the WAF
        """
        return pulumi.get(self, "waf_id")

    @waf_id.setter
    def waf_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "waf_id", value)


@pulumi.input_type
class ServiceWafConfigurationRuleArgs:
    def __init__(__self__, *,
                 modsec_rule_id: pulumi.Input[int],
                 status: pulumi.Input[str],
                 revision: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] modsec_rule_id: The Web Application Firewall rule's modsecurity ID
        :param pulumi.Input[str] status: The Web Application Firewall rule's status. Allowed values are (`log`, `block` and `score`)
        :param pulumi.Input[int] revision: The Web Application Firewall rule's revision. The latest revision will be used if this is not provided
        """
        pulumi.set(__self__, "modsec_rule_id", modsec_rule_id)
        pulumi.set(__self__, "status", status)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter(name="modsecRuleId")
    def modsec_rule_id(self) -> pulumi.Input[int]:
        """
        The Web Application Firewall rule's modsecurity ID
        """
        return pulumi.get(self, "modsec_rule_id")

    @modsec_rule_id.setter
    def modsec_rule_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "modsec_rule_id", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        The Web Application Firewall rule's status. Allowed values are (`log`, `block` and `score`)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[int]]:
        """
        The Web Application Firewall rule's revision. The latest revision will be used if this is not provided
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "revision", value)


@pulumi.input_type
class ServiceWafConfigurationRuleExclusionArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[str],
                 exclusion_type: pulumi.Input[str],
                 name: pulumi.Input[str],
                 modsec_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 number: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] condition: A conditional expression in VCL used to determine if the condition is met
        :param pulumi.Input[str] exclusion_type: The type of rule exclusion. Values are `rule` to exclude the specified rule(s), or `waf` to disable the Web Application Firewall
        :param pulumi.Input[str] name: The name of rule exclusion
        :param pulumi.Input[Sequence[pulumi.Input[int]]] modsec_rule_ids: Set of modsecurity IDs to be excluded. No rules should be provided when `exclusion_type` is `waf`. The rules need to be configured on the Web Application Firewall to be excluded
        :param pulumi.Input[int] number: The numeric ID assigned to the WAF Rule Exclusion
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "exclusion_type", exclusion_type)
        pulumi.set(__self__, "name", name)
        if modsec_rule_ids is not None:
            pulumi.set(__self__, "modsec_rule_ids", modsec_rule_ids)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[str]:
        """
        A conditional expression in VCL used to determine if the condition is met
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="exclusionType")
    def exclusion_type(self) -> pulumi.Input[str]:
        """
        The type of rule exclusion. Values are `rule` to exclude the specified rule(s), or `waf` to disable the Web Application Firewall
        """
        return pulumi.get(self, "exclusion_type")

    @exclusion_type.setter
    def exclusion_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "exclusion_type", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of rule exclusion
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="modsecRuleIds")
    def modsec_rule_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Set of modsecurity IDs to be excluded. No rules should be provided when `exclusion_type` is `waf`. The rules need to be configured on the Web Application Firewall to be excluded
        """
        return pulumi.get(self, "modsec_rule_ids")

    @modsec_rule_ids.setter
    def modsec_rule_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "modsec_rule_ids", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[int]]:
        """
        The numeric ID assigned to the WAF Rule Exclusion
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number", value)


@pulumi.input_type
class TlsSubscriptionManagedDnsChallengeArgs:
    def __init__(__self__, *,
                 record_name: Optional[pulumi.Input[str]] = None,
                 record_type: Optional[pulumi.Input[str]] = None,
                 record_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] record_name: The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        :param pulumi.Input[str] record_type: The type of DNS record to add, e.g. `A`, or `CNAME`.
        :param pulumi.Input[str] record_value: The value to which the DNS record should point, e.g. `xxxxx.fastly-validations.com`.
        """
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_value is not None:
            pulumi.set(__self__, "record_value", record_value)

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        """
        return pulumi.get(self, "record_name")

    @record_name.setter
    def record_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_name", value)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of DNS record to add, e.g. `A`, or `CNAME`.
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_type", value)

    @property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to which the DNS record should point, e.g. `xxxxx.fastly-validations.com`.
        """
        return pulumi.get(self, "record_value")

    @record_value.setter
    def record_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_value", value)


@pulumi.input_type
class TlsSubscriptionManagedHttpChallengeArgs:
    def __init__(__self__, *,
                 record_name: Optional[pulumi.Input[str]] = None,
                 record_type: Optional[pulumi.Input[str]] = None,
                 record_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] record_name: The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        :param pulumi.Input[str] record_type: The type of DNS record to add, e.g. `A`, or `CNAME`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] record_values: A list with the value(s) to which the DNS record should point.
        """
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_values is not None:
            pulumi.set(__self__, "record_values", record_values)

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        """
        return pulumi.get(self, "record_name")

    @record_name.setter
    def record_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_name", value)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of DNS record to add, e.g. `A`, or `CNAME`.
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_type", value)

    @property
    @pulumi.getter(name="recordValues")
    def record_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list with the value(s) to which the DNS record should point.
        """
        return pulumi.get(self, "record_values")

    @record_values.setter
    def record_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "record_values", value)


