# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['render_svg_icons']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['render_svg_icons = render_svg_icons:main']}

setup_kwargs = {
    'name': 'render-svg-icons',
    'version': '0.1.0',
    'description': 'Python script to render SVG icons to PNG icons in various sizes',
    'long_description': '`render-svg-icons` is a python script for rendering SVG icons to PNG icons in various sizes. While it runs on both Linux and macOS, it currently uses a specific SVG template and a folder structure based on [the XDG Icon Theme Specification](https://specifications.freedesktop.org/icon-theme-spec/latest/).\n\n# Provenance\n\nI\'ve come across the progenitor of this script in multiple places. It seems to have originated with GNOME, but it\'s not entirely clear.\n\n# Development Status\n\n`render-svg-icons` _should_ basically work for its original purpose of rendering XDG icon themes. I plan to continue adapting the code to make it easier to use and to allow for more flexible use cases in the future.\n\nWhile I plan to leave the command-line interface more or less intact, it and the implementation thereof shouldn\'t be considered stable at the moment. If you plan to call `render-svg-icons` as a dependency, you should specify an exact version you know to work for your purposes.\n\n# Installation\n\nFor day-to-day use, you should install `render-svg-icons` from PyPI:\n\n```bash\n$ pip install render-svg-icons\n```\n\nFor development purposes, you can build and install `render-svg-icons` from the cloned repository using [Poetry](https://python-poetry.org/).\n\nTo install Poetry, run:\n\n```bash\n$ curl -sSL https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python -\n```\n\nThen, from the `render-svg-icons` cloned repository, run:\n\n```bash\n$ poetry build\n$ pip install --force-reinstall dist/*.whl\n```\n\nThis will install the repository code in the same manner as the PyPI version. (The `--force-reinstall` causes it to overwrite any other installed version.)\n\nTo uninstall either version of `render-svg-icons`, run:\n\n```bash\n$ pip uninstall render-svg-icons\n```\n\n# Dependencies\n\n`render-svg-icons` requires both [Inkscape](https://inkscape.org/) and [OptiPNG](http://optipng.sourceforge.net/).\n\n## Linux\n\nTo install Inkscape and OptiPNG on, e.g., Debian, Ubuntu, etc.:\n\n```bash\n$ sudo apt install inkscape optipng\n```\n\n(For Fedora, Arch, etc., I\'m sure you know what you\'re doing.)\n\n## macOS\n\nTo install Inkscape and OptiPNG on macOS, first install [Homebrew](https://brew.sh/) if you haven\'t already:\n\n```bash\n% /bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"\n```\n\nThen use Homebrew to install Inkscape and OptiPNG:\n\n```\n% brew install inkscape optipng\n```\n\nYou can probably use other installation methods, but you may need to specify the executable path if it\'s different from the one used by Homebrew.\n\n## Other Platforms\n\n`render-svg-icons` isn\'t currently compatible with platforms other than Linux and macOS. If you\'d like to use this on another platform, please [open an issue](https://github.com/elsiehupp/render-svg-icons/issues/new) or [a pull request](https://github.com/elsiehupp/render-svg-icons/compare).\n\n# Usage\n\nAfter installation:\n\n```bash\n$ render_svg_icons --help\n\n┌──────────────────────────────────────────────────┐\n│ Render icons from SVG to PNG                     │\n└──────────────────────────────────────────────────┘\n┌──────────────────────────────────────────────────┐\n│ Usage                                            │\n├──────────────────────────────────────────────────┤\n│ $ render_svg_icons                               │\n│       [--help]                                   │\n│       [--base_dpi BASE_DPI]                      │\n│       [--categories [CATEGORIES]]                │\n│       [--filter FILTER]                          │\n│       [--inkscape_path INKSCAPE_PATH]            │\n│       [--individual_icons [INDIVIDUAL_ICONS]]    │\n│       [--optipng_path OPTIPNG_PATH]              │\n│       [--output_path OUTPUT_PATH]                │\n│       [--scaling_factors [SCALING_FACTORS]]      │\n│       [--verbose]                                │\n│                                                  │\n└──────────────────────────────────────────────────┘\n┌──────────────────────────────────────────────────┐\n│ Optional Arguments                               │\n├──────────────────────────────────────────────────┤\n│ --help                                           │\n│                                                  │\n│   Show this help message and exit.               │\n│                                                  │\n│ --base_dpi BASE_DPI                              │\n│                                                  │\n│   dpi to use for rendering (by default 96)       │\n│                                                  │\n│ --categories [CATEGORIES]                        │\n│                                                  │\n│   categories of icons to render (by default all) │\n│                                                  │\n│ --filter FILTER                                  │\n│                                                  │\n│   Inkscape filter to apply while rendering       │\n│   (by default none)                              │\n│                                                  │\n│ --inkscape_path INKSCAPE_PATH                    │\n│                                                  │\n│   path of Inkscape executable                    │\n│   (if the script can\'t find it)                  │\n│                                                  │\n│ --individual_icons [INDIVIDUAL_ICONS]            │\n│                                                  │\n│   individual icon names (without extensions)     │\n│   to render (by default all)                     │\n│                                                  │\n│ --optipng_path OPTIPNG_PATH                      │\n│                                                  │\n│   path of OptiPNG executable                     │\n│   (if the script can\'t find it)                  │\n│                                                  │\n│ --output_path OUTPUT_PATH                        │\n│                                                  │\n│   output directory (by default \'.\')              │\n│                                                  │\n│ --scaling_factors [SCALING_FACTORS]              │\n│                                                  │\n│   scaling factors to render at                   │\n│   (by default [1, 2], e.g. 100% & 200%)          │\n│                                                  │\n│ --verbose                                        │\n│                                                  │\n│   print verbose output to the terminal           │\n│                                                  │\n└──────────────────────────────────────────────────┘\n```\n\n# License\n\n`render-svg-icons` is published under the GPLv3 or later (i.e. you can use it for proprietary purposes via the command line, but you can only link to it from other GPL code).',
    'author': 'GNOME icon developers',
    'author_email': None,
    'maintainer': 'Elsie Hupp',
    'maintainer_email': 'github@elsiehupp.com',
    'url': 'https://github.com/elsiehupp/render-svg-icons',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
