from .card import *

__all__ = [
    "default_cards",
]

_DEFAULT_CARDS: list[type[Card]] = [
    # Equipment Card
    ## Talents ##
    AbsorbingPrism,
    AbyssalMayhemHydrospout,
    AratakiIchiban,
    ColdBloodedStrike,
    DescentOfDivinity,
    EmbraceOfWinds,
    FloralSidewinder,
    GalesOfReverie,
    GrandExpectation,
    IGotYourBack,
    KantenSenmyouBlessing,
    KeenSight,
    LandsOfDandelion,
    MysticalAbandon,
    NaganoharaMeteorSwarm,
    PaidInFull,
    PoeticsOfFuubutsu,
    PoundingSurprise,
    ProliferatingSpores,
    ProphecyOfSubmersion,
    RiteOfResurrection,
    SanguineRouge,
    SinOfPride,
    StalwartAndTrue,
    StellarPredator,
    StrategicReserve,
    StreamingSurge,
    TamakushiCasket,
    TheScentRemained,
    TheSeedOfStoredKnowledge,
    TheShrinesSacredShade,
    ThunderingPenance,
    TranscendentAutomaton,
    UndividedHeart,
    WellspingOfWarLust,
    ## Weapons ##
    ### Bow ###
    AmosBow,
    ElegyForTheEnd,
    KingsSquire,
    RavenBow,
    SacrificialBow,
    ### Catalyst ###
    AThousandFloatingDreams,
    FruitOfFulfillment,
    MagicGuide,
    SacrificialFragments,
    ### Claymore ###
    SacrificialGreatsword,
    TheBell,
    WhiteIronGreatsword,
    WolfsGravestone,
    ### Polearm ###
    EngulfingLightning,
    LithicSpear,
    Moonpiercer,
    VortexVanquisher,
    WhiteTassel,
    ### Sword ###
    AquilaFavonia,
    FavoniusSword,
    SacrificialSword,
    TravelersHandySword,
    ## Artifact ##
    FlowingRings,
    GamblersEarrings,
    GeneralsAncientHelm,
    GildedDreams,
    HeartOfKhvarenasBrilliance,
    InstructorsCap,
    ShadowOfTheSandKing,
    TenacityOfTheMillelith,
    VourukashasGlow,

    # Event Card
    AbyssalSummons,
    BlessingOfTheDivineRelicsInstallation,
    CalxsArts,
    ChangingShifts,
    ElementalResonanceEnduringRock,
    ElementalResonanceFerventFlames,
    ElementalResonanceHighVoltage,
    ElementalResonanceImpetuousWinds,
    ElementalResonanceShatteringIce,
    ElementalResonanceSoothingWater,
    ElementalResonanceSprawlingGreenery,
    ElementalResonanceWovenFlames,
    ElementalResonanceWovenIce,
    ElementalResonanceWovenStone,
    ElementalResonanceWovenThunder,
    ElementalResonanceWovenWaters,
    ElementalResonanceWovenWeeds,
    ElementalResonanceWovenWinds,
    GuardiansOath,
    HeavyStrike,
    IHaventLostYet,
    LeaveItToMe,
    Lyresong,
    MasterOfWeaponry,
    NatureAndWisdom,
    QuickKnit,
    SendOff,
    Starsigns,
    StoneAndContracts,
    Strategize,
    TheBestestTravelCompanion,
    TheBoarPrincess,
    ThunderAndEternity,
    TossUp,
    WhenTheCraneReturned,
    WhereIsTheUnseenRazor,
    WindAndFreedom,

    ## Event Card / Arcane Legend ##
    AncientCourtyard,
    CovenantOfRock,
    FreshWindOfFreedom,
    InEveryHouseAStove,
    JoyousCelebration,
    PassingOfJudgment,

    ## Event Card / Food ##
    AdeptusTemptation,
    ButterCrab,
    JueyunGuoba,
    LotusFlowerCrisp,
    MondstadtHashBrown,
    MushroomPizza,
    MintyMeatRolls,
    NorthernSmokedChicken,
    SweetMadame,
    TandooriRoastChicken,
    TeyvatFriedEgg,

    # Support Card
    ## Support Card / Companion ##
    ChangTheNinth,
    ChefMao,
    Dunyarzad,
    Liben,
    LiuSu,
    Mamere,
    MasterZhang,
    Paimon,
    Rana,
    Setaria,
    Timaeus,
    Wagner,
    Xudong,
    YayoiNanatsuki,
    ## Support Card / Item ##
    NRE,
    ParametricTransformer,
    TreasureSeekingSeelie,
    ## Support Card / Location ##
    KnightsOfFavoniusLibrary,
    LiyueHarborWharf,
    SumeruCity,
    Tenshukaku,
    Vanarana,
]

_DEFAULT_CARDS_FSET = None


def default_cards() -> frozenset[type[Card]]:
    global _DEFAULT_CARDS_FSET
    if _DEFAULT_CARDS_FSET is None:
        _DEFAULT_CARDS_FSET = frozenset(_DEFAULT_CARDS)
    return _DEFAULT_CARDS_FSET
