import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a Fastly service dictionary.
 *
 * @schema CfnDictionaryProps
 */
export interface CfnDictionaryProps {
    /**
     * Name for the Dictionary
     *
     * @schema CfnDictionaryProps#Name
     */
    readonly name: string;
    /**
     * Date and time in ISO 8601 format.
     *
     * @schema CfnDictionaryProps#DeletedAt
     */
    readonly deletedAt?: Date;
    /**
     * Alphanumeric string identifying the service. Read-only.
     *
     * @schema CfnDictionaryProps#ServiceId
     */
    readonly serviceId: string;
    /**
     * Alphanumeric string identifying the service version.
     *
     * @schema CfnDictionaryProps#VersionId
     */
    readonly versionId: string;
}
/**
 * Converts an object of type 'CfnDictionaryProps' to JSON representation.
 */
export declare function toJson_CfnDictionaryProps(obj: CfnDictionaryProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Fastly::Dictionary::Dictionary`
 *
 * @cloudformationResource Fastly::Dictionary::Dictionary
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
export declare class CfnDictionary extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Fastly::Dictionary::Dictionary";
    /**
     * Resource props.
     */
    readonly props: CfnDictionaryProps;
    /**
     * Attribute `Fastly::Dictionary::Dictionary.WriteOnly`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrWriteOnly: cdk.IResolvable;
    /**
     * Attribute `Fastly::Dictionary::Dictionary.CreatedAt`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrCreatedAt: string;
    /**
     * Attribute `Fastly::Dictionary::Dictionary.Id`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrId: string;
    /**
     * Attribute `Fastly::Dictionary::Dictionary.UpdatedAt`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrUpdatedAt: string;
    /**
     * Attribute `Fastly::Dictionary::Dictionary.Version`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrVersion: string;
    /**
     * Create a new `Fastly::Dictionary::Dictionary`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDictionaryProps);
}
