"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDictionary = exports.toJson_CfnDictionaryProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnDictionaryProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnDictionaryProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'DeletedAt': obj.deletedAt?.toISOString(),
        'ServiceId': obj.serviceId,
        'VersionId': obj.versionId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnDictionaryProps = toJson_CfnDictionaryProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Fastly::Dictionary::Dictionary`
 *
 * @cloudformationResource Fastly::Dictionary::Dictionary
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
class CfnDictionary extends cdk.CfnResource {
    /**
     * Create a new `Fastly::Dictionary::Dictionary`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDictionary.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnDictionaryProps(props) });
        this.props = props;
        this.attrWriteOnly = this.getAtt('WriteOnly');
        this.attrCreatedAt = cdk.Token.asString(this.getAtt('CreatedAt'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrUpdatedAt = cdk.Token.asString(this.getAtt('UpdatedAt'));
        this.attrVersion = cdk.Token.asString(this.getAtt('Version'));
    }
}
exports.CfnDictionary = CfnDictionary;
_a = JSII_RTTI_SYMBOL_1;
CfnDictionary[_a] = { fqn: "@cdk-cloudformation/fastly-dictionary-dictionary.CfnDictionary", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnDictionary.CFN_RESOURCE_TYPE_NAME = "Fastly::Dictionary::Dictionary";
//# sourceMappingURL=data:application/json;base64,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