"""
Exceptions generated by the various modules 

"""
class InvalidConfiguration(Exception):     
    """
    Configuration error. 
    
    Raise this for invalid conf,args and test data. 
    """
    def __init__(self, message, elements): 
        super(InvalidConfiguration, self).__init__(message) 
        self.elements = elements 

    def __str__(self): 
        s = super(InvalidConfiguration, self).__str__()
        return s + ": " + str(self.elements) 

class InvalidTransform(Exception):     
    """
    Invalid transform. 

    Raise this from Transform and Model modules. 
    """
    def __init__(self, message, elements=[]): 
        super(InvalidTransform, self).__init__(message) 
        self.elements = elements         

class InvalidPlugin(Exception):
    """
    Invalid plugin

    Raise this from generic non-transform plugins
    """    
    def __init__(self, message, elements=[]): 
        super(InvalidPlugin, self).__init__(message) 
        self.elements = elements
        
class InvalidSkin(Exception):     
    """
    Invalid Skin

    Raise this from skin module
    """
    def __init__(self, message, elements=[]): 
        super(InvalidSkin, self).__init__(message) 
        self.elements = elements         

class Unsupported(Exception):     
    """
    Unsupported functionality 

    Raise this if there is missing configuration or unsupported
    conbombination of parameters.
    """
    def __init__(self, message, elements=[]): 
        super(Unsupported, self).__init__(message) 
        self.elements = elements         

class InvalidNode(Exception):
    """
    Could not find a transform/model/other subclass of 
    Node with a given name
    """
    pass


        
