# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# pylint: disable=wildcard-import
"""NLP toolkit."""

import warnings
import mxnet

from . import loss
from . import data
from . import embedding
from . import model
from . import metric
from . import utils
from . import vocab
from . import optimizer
from . import initializer
from .vocab import Vocab

__version__ = '0.9.1'

__all__ = ['data',
           'model',
           'embedding',
           'Vocab',
           'vocab',
           'loss',
           'initializer',
           'optimizer',
           'utils',
           'metric']

warnings.filterwarnings(module='gluonnlp', action='default', category=DeprecationWarning)
utils.version.check_version('1.6.0', warning_only=True, library=mxnet)
