"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaProxyIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) The Lambda Proxy integration resource for HTTP API.
 *
 * @experimental
 */
class LambdaProxyIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        const route = options.route;
        this.props.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(route.node)}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.apiId,
                resourceName: `*/*${(_b = route.path) !== null && _b !== void 0 ? _b : ''}`,
            }),
        });
        return {
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_c = this.props.payloadFormatVersion) !== null && _c !== void 0 ? _c : aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_2_0,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
_a = JSII_RTTI_SYMBOL_1;
LambdaProxyIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.LambdaProxyIntegration", version: "2.0.0-alpha.3" };
//# sourceMappingURL=data:application/json;base64,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