"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaWebSocketIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Lambda WebSocket Integration.
 *
 * @experimental
 */
class LambdaWebSocketIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        const route = options.route;
        this.props.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(route.node)}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.webSocketApi.apiId,
                resourceName: `*/*${route.routeKey}`,
            }),
        });
        const integrationUri = aws_cdk_lib_1.Stack.of(route).formatArn({
            service: 'apigateway',
            account: 'lambda',
            resource: 'path/2015-03-31/functions',
            resourceName: `${this.props.handler.functionArn}/invocations`,
        });
        return {
            type: aws_apigatewayv2_alpha_1.WebSocketIntegrationType.AWS_PROXY,
            uri: integrationUri,
        };
    }
}
exports.LambdaWebSocketIntegration = LambdaWebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
LambdaWebSocketIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.LambdaWebSocketIntegration", version: "2.0.0-alpha.3" };
//# sourceMappingURL=data:application/json;base64,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