# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 spark_version: pulumi.Input[str],
                 apply_policy_default_values: Optional[pulumi.Input[bool]] = None,
                 autoscale: Optional[pulumi.Input['ClusterAutoscaleArgs']] = None,
                 autotermination_minutes: Optional[pulumi.Input[int]] = None,
                 aws_attributes: Optional[pulumi.Input['ClusterAwsAttributesArgs']] = None,
                 azure_attributes: Optional[pulumi.Input['ClusterAzureAttributesArgs']] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_log_conf: Optional[pulumi.Input['ClusterClusterLogConfArgs']] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 data_security_mode: Optional[pulumi.Input[str]] = None,
                 docker_image: Optional[pulumi.Input['ClusterDockerImageArgs']] = None,
                 driver_instance_pool_id: Optional[pulumi.Input[str]] = None,
                 driver_node_type_id: Optional[pulumi.Input[str]] = None,
                 enable_elastic_disk: Optional[pulumi.Input[bool]] = None,
                 enable_local_disk_encryption: Optional[pulumi.Input[bool]] = None,
                 gcp_attributes: Optional[pulumi.Input['ClusterGcpAttributesArgs']] = None,
                 idempotency_token: Optional[pulumi.Input[str]] = None,
                 init_scripts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInitScriptArgs']]]] = None,
                 instance_pool_id: Optional[pulumi.Input[str]] = None,
                 is_pinned: Optional[pulumi.Input[bool]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLibraryArgs']]]] = None,
                 node_type_id: Optional[pulumi.Input[str]] = None,
                 num_workers: Optional[pulumi.Input[int]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 single_user_name: Optional[pulumi.Input[str]] = None,
                 spark_conf: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_env_vars: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 workload_type: Optional[pulumi.Input['ClusterWorkloadTypeArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] spark_version: [Runtime version](https://docs.databricks.com/runtime/index.html) of the cluster. Any supported get_spark_version id.  We advise using Cluster Policies to restrict the list of versions for simplicity while maintaining enough control.
        :param pulumi.Input[bool] apply_policy_default_values: Whether to use policy default values for missing cluster attributes.
        :param pulumi.Input[int] autotermination_minutes: Automatically terminate the cluster after being inactive for this time in minutes. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable automatic termination. Defaults to `60`.  _We highly recommend having this setting present for Interactive/BI clusters._
        :param pulumi.Input[str] cluster_name: Cluster name, which doesn’t have to be unique. If not specified at creation, the cluster name will be an empty string.
        :param pulumi.Input[Mapping[str, Any]] custom_tags: Additional tags for cluster resources. Databricks will tag all cluster resources (e.g., AWS EC2 instances and EBS volumes) with these tags in addition to `default_tags`.
        :param pulumi.Input[str] data_security_mode: Select the security features of the cluster. Unity Catalog requires `SINGLE_USER` or `USER_ISOLATION` mode. `LEGACY_PASSTHROUGH` for passthrough cluster and `LEGACY_TABLE_ACL` for Table ACL cluster. Default to `NONE`, i.e. no security feature enabled.
        :param pulumi.Input[str] driver_instance_pool_id: similar to `instance_pool_id`, but for driver node. If omitted, and `instance_pool_id` is specified, then the driver will be allocated from that pool.
        :param pulumi.Input[str] driver_node_type_id: The node type of the Spark driver. This field is optional; if unset, API will set the driver node type to the same value as `node_type_id` defined above.
        :param pulumi.Input[bool] enable_elastic_disk: If you don’t want to allocate a fixed number of EBS volumes at cluster creation time, use autoscaling local storage. With autoscaling local storage, Databricks monitors the amount of free disk space available on your cluster’s Spark workers. If a worker begins to run too low on disk, Databricks automatically attaches a new EBS volume to the worker before it runs out of disk space. EBS volumes are attached up to a limit of 5 TB of total disk space per instance (including the instance’s local storage). To scale down EBS usage, make sure you have `autotermination_minutes` and `autoscale` attributes set. More documentation available at [cluster configuration page](https://docs.databricks.com/clusters/configure.html#autoscaling-local-storage-1).
        :param pulumi.Input[bool] enable_local_disk_encryption: Some instance types you use to run clusters may have locally attached disks. Databricks may store shuffle data or temporary data on these locally attached disks. To ensure that all data at rest is encrypted for all storage types, including shuffle data stored temporarily on your cluster’s local disks, you can enable local disk encryption. When local disk encryption is enabled, Databricks generates an encryption key locally unique to each cluster node and uses it to encrypt all data stored on local disks. The scope of the key is local to each cluster node and is destroyed along with the cluster node itself. During its lifetime, the key resides in memory for encryption and decryption and is stored encrypted on the disk. _Your workloads may run more slowly because of the performance impact of reading and writing encrypted data to and from local volumes. This feature is not available for all Azure Databricks subscriptions. Contact your Microsoft or Databricks account representative to request access._
        :param pulumi.Input[str] idempotency_token: An optional token to guarantee the idempotency of cluster creation requests. If an active cluster with the provided token already exists, the request will not create a new cluster, but it will return the existing running cluster's ID instead. If you specify the idempotency token, upon failure, you can retry until the request succeeds. Databricks platform guarantees to launch exactly one cluster with that idempotency token. This token should have at most 64 characters.
        :param pulumi.Input[str] instance_pool_id: - To reduce cluster start time, you can attach a cluster to a predefined pool of idle instances. When attached to a pool, a cluster allocates its driver and worker nodes from the pool. If the pool does not have sufficient idle resources to accommodate the cluster’s request, it expands by allocating new instances from the instance provider. When an attached cluster changes its state to `TERMINATED`, the instances it used are returned to the pool and reused by a different cluster.
        :param pulumi.Input[bool] is_pinned: boolean value specifying if the cluster is pinned (not pinned by default). You must be a Databricks administrator to use this.  The pinned clusters' maximum number is [limited to 70](https://docs.databricks.com/clusters/clusters-manage.html#pin-a-cluster), so `apply` may fail if you have more than that.
        :param pulumi.Input[str] node_type_id: Any supported get_node_type id. If `instance_pool_id` is specified, this field is not needed.
        :param pulumi.Input[str] policy_id: Identifier of Cluster Policy to validate cluster and preset certain defaults. *The primary use for cluster policies is to allow users to create policy-scoped clusters via UI rather than sharing configuration for API-created clusters.* For example, when you specify `policy_id` of [external metastore](https://docs.databricks.com/administration-guide/clusters/policies.html#external-metastore-policy) policy, you still have to fill in relevant keys for `spark_conf`.
        :param pulumi.Input[str] single_user_name: The optional user name of the user to assign to an interactive cluster. This field is required when using standard AAD Passthrough for Azure Data Lake Storage (ADLS) with a single-user cluster (i.e., not high-concurrency clusters).
        :param pulumi.Input[Mapping[str, Any]] spark_conf: Map with key-value pairs to fine-tune Spark clusters, where you can provide custom [Spark configuration properties](https://spark.apache.org/docs/latest/configuration.html) in a cluster configuration.
        :param pulumi.Input[Mapping[str, Any]] spark_env_vars: Map with environment variable key-value pairs to fine-tune Spark clusters. Key-value pairs of the form (X,Y) are exported (i.e., X='Y') while launching the driver and workers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: SSH public key contents that will be added to each Spark node in this cluster. The corresponding private keys can be used to login with the user name ubuntu on port 2200. You can specify up to 10 keys.
        """
        pulumi.set(__self__, "spark_version", spark_version)
        if apply_policy_default_values is not None:
            pulumi.set(__self__, "apply_policy_default_values", apply_policy_default_values)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if autotermination_minutes is not None:
            pulumi.set(__self__, "autotermination_minutes", autotermination_minutes)
        if aws_attributes is not None:
            pulumi.set(__self__, "aws_attributes", aws_attributes)
        if azure_attributes is not None:
            pulumi.set(__self__, "azure_attributes", azure_attributes)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_log_conf is not None:
            pulumi.set(__self__, "cluster_log_conf", cluster_log_conf)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if data_security_mode is not None:
            pulumi.set(__self__, "data_security_mode", data_security_mode)
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if driver_instance_pool_id is not None:
            pulumi.set(__self__, "driver_instance_pool_id", driver_instance_pool_id)
        if driver_node_type_id is not None:
            pulumi.set(__self__, "driver_node_type_id", driver_node_type_id)
        if enable_elastic_disk is not None:
            pulumi.set(__self__, "enable_elastic_disk", enable_elastic_disk)
        if enable_local_disk_encryption is not None:
            pulumi.set(__self__, "enable_local_disk_encryption", enable_local_disk_encryption)
        if gcp_attributes is not None:
            pulumi.set(__self__, "gcp_attributes", gcp_attributes)
        if idempotency_token is not None:
            pulumi.set(__self__, "idempotency_token", idempotency_token)
        if init_scripts is not None:
            pulumi.set(__self__, "init_scripts", init_scripts)
        if instance_pool_id is not None:
            pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if is_pinned is not None:
            pulumi.set(__self__, "is_pinned", is_pinned)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if node_type_id is not None:
            pulumi.set(__self__, "node_type_id", node_type_id)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if single_user_name is not None:
            pulumi.set(__self__, "single_user_name", single_user_name)
        if spark_conf is not None:
            pulumi.set(__self__, "spark_conf", spark_conf)
        if spark_env_vars is not None:
            pulumi.set(__self__, "spark_env_vars", spark_env_vars)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> pulumi.Input[str]:
        """
        [Runtime version](https://docs.databricks.com/runtime/index.html) of the cluster. Any supported get_spark_version id.  We advise using Cluster Policies to restrict the list of versions for simplicity while maintaining enough control.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="applyPolicyDefaultValues")
    def apply_policy_default_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use policy default values for missing cluster attributes.
        """
        return pulumi.get(self, "apply_policy_default_values")

    @apply_policy_default_values.setter
    def apply_policy_default_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_policy_default_values", value)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input['ClusterAutoscaleArgs']]:
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input['ClusterAutoscaleArgs']]):
        pulumi.set(self, "autoscale", value)

    @property
    @pulumi.getter(name="autoterminationMinutes")
    def autotermination_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Automatically terminate the cluster after being inactive for this time in minutes. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable automatic termination. Defaults to `60`.  _We highly recommend having this setting present for Interactive/BI clusters._
        """
        return pulumi.get(self, "autotermination_minutes")

    @autotermination_minutes.setter
    def autotermination_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "autotermination_minutes", value)

    @property
    @pulumi.getter(name="awsAttributes")
    def aws_attributes(self) -> Optional[pulumi.Input['ClusterAwsAttributesArgs']]:
        return pulumi.get(self, "aws_attributes")

    @aws_attributes.setter
    def aws_attributes(self, value: Optional[pulumi.Input['ClusterAwsAttributesArgs']]):
        pulumi.set(self, "aws_attributes", value)

    @property
    @pulumi.getter(name="azureAttributes")
    def azure_attributes(self) -> Optional[pulumi.Input['ClusterAzureAttributesArgs']]:
        return pulumi.get(self, "azure_attributes")

    @azure_attributes.setter
    def azure_attributes(self, value: Optional[pulumi.Input['ClusterAzureAttributesArgs']]):
        pulumi.set(self, "azure_attributes", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="clusterLogConf")
    def cluster_log_conf(self) -> Optional[pulumi.Input['ClusterClusterLogConfArgs']]:
        return pulumi.get(self, "cluster_log_conf")

    @cluster_log_conf.setter
    def cluster_log_conf(self, value: Optional[pulumi.Input['ClusterClusterLogConfArgs']]):
        pulumi.set(self, "cluster_log_conf", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster name, which doesn’t have to be unique. If not specified at creation, the cluster name will be an empty string.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Additional tags for cluster resources. Databricks will tag all cluster resources (e.g., AWS EC2 instances and EBS volumes) with these tags in addition to `default_tags`.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "custom_tags", value)

    @property
    @pulumi.getter(name="dataSecurityMode")
    def data_security_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Select the security features of the cluster. Unity Catalog requires `SINGLE_USER` or `USER_ISOLATION` mode. `LEGACY_PASSTHROUGH` for passthrough cluster and `LEGACY_TABLE_ACL` for Table ACL cluster. Default to `NONE`, i.e. no security feature enabled.
        """
        return pulumi.get(self, "data_security_mode")

    @data_security_mode.setter
    def data_security_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_security_mode", value)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[pulumi.Input['ClusterDockerImageArgs']]:
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: Optional[pulumi.Input['ClusterDockerImageArgs']]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter(name="driverInstancePoolId")
    def driver_instance_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        similar to `instance_pool_id`, but for driver node. If omitted, and `instance_pool_id` is specified, then the driver will be allocated from that pool.
        """
        return pulumi.get(self, "driver_instance_pool_id")

    @driver_instance_pool_id.setter
    def driver_instance_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_instance_pool_id", value)

    @property
    @pulumi.getter(name="driverNodeTypeId")
    def driver_node_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        The node type of the Spark driver. This field is optional; if unset, API will set the driver node type to the same value as `node_type_id` defined above.
        """
        return pulumi.get(self, "driver_node_type_id")

    @driver_node_type_id.setter
    def driver_node_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_node_type_id", value)

    @property
    @pulumi.getter(name="enableElasticDisk")
    def enable_elastic_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        If you don’t want to allocate a fixed number of EBS volumes at cluster creation time, use autoscaling local storage. With autoscaling local storage, Databricks monitors the amount of free disk space available on your cluster’s Spark workers. If a worker begins to run too low on disk, Databricks automatically attaches a new EBS volume to the worker before it runs out of disk space. EBS volumes are attached up to a limit of 5 TB of total disk space per instance (including the instance’s local storage). To scale down EBS usage, make sure you have `autotermination_minutes` and `autoscale` attributes set. More documentation available at [cluster configuration page](https://docs.databricks.com/clusters/configure.html#autoscaling-local-storage-1).
        """
        return pulumi.get(self, "enable_elastic_disk")

    @enable_elastic_disk.setter
    def enable_elastic_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_elastic_disk", value)

    @property
    @pulumi.getter(name="enableLocalDiskEncryption")
    def enable_local_disk_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Some instance types you use to run clusters may have locally attached disks. Databricks may store shuffle data or temporary data on these locally attached disks. To ensure that all data at rest is encrypted for all storage types, including shuffle data stored temporarily on your cluster’s local disks, you can enable local disk encryption. When local disk encryption is enabled, Databricks generates an encryption key locally unique to each cluster node and uses it to encrypt all data stored on local disks. The scope of the key is local to each cluster node and is destroyed along with the cluster node itself. During its lifetime, the key resides in memory for encryption and decryption and is stored encrypted on the disk. _Your workloads may run more slowly because of the performance impact of reading and writing encrypted data to and from local volumes. This feature is not available for all Azure Databricks subscriptions. Contact your Microsoft or Databricks account representative to request access._
        """
        return pulumi.get(self, "enable_local_disk_encryption")

    @enable_local_disk_encryption.setter
    def enable_local_disk_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_local_disk_encryption", value)

    @property
    @pulumi.getter(name="gcpAttributes")
    def gcp_attributes(self) -> Optional[pulumi.Input['ClusterGcpAttributesArgs']]:
        return pulumi.get(self, "gcp_attributes")

    @gcp_attributes.setter
    def gcp_attributes(self, value: Optional[pulumi.Input['ClusterGcpAttributesArgs']]):
        pulumi.set(self, "gcp_attributes", value)

    @property
    @pulumi.getter(name="idempotencyToken")
    def idempotency_token(self) -> Optional[pulumi.Input[str]]:
        """
        An optional token to guarantee the idempotency of cluster creation requests. If an active cluster with the provided token already exists, the request will not create a new cluster, but it will return the existing running cluster's ID instead. If you specify the idempotency token, upon failure, you can retry until the request succeeds. Databricks platform guarantees to launch exactly one cluster with that idempotency token. This token should have at most 64 characters.
        """
        return pulumi.get(self, "idempotency_token")

    @idempotency_token.setter
    def idempotency_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idempotency_token", value)

    @property
    @pulumi.getter(name="initScripts")
    def init_scripts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInitScriptArgs']]]]:
        return pulumi.get(self, "init_scripts")

    @init_scripts.setter
    def init_scripts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInitScriptArgs']]]]):
        pulumi.set(self, "init_scripts", value)

    @property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        - To reduce cluster start time, you can attach a cluster to a predefined pool of idle instances. When attached to a pool, a cluster allocates its driver and worker nodes from the pool. If the pool does not have sufficient idle resources to accommodate the cluster’s request, it expands by allocating new instances from the instance provider. When an attached cluster changes its state to `TERMINATED`, the instances it used are returned to the pool and reused by a different cluster.
        """
        return pulumi.get(self, "instance_pool_id")

    @instance_pool_id.setter
    def instance_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_pool_id", value)

    @property
    @pulumi.getter(name="isPinned")
    def is_pinned(self) -> Optional[pulumi.Input[bool]]:
        """
        boolean value specifying if the cluster is pinned (not pinned by default). You must be a Databricks administrator to use this.  The pinned clusters' maximum number is [limited to 70](https://docs.databricks.com/clusters/clusters-manage.html#pin-a-cluster), so `apply` may fail if you have more than that.
        """
        return pulumi.get(self, "is_pinned")

    @is_pinned.setter
    def is_pinned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pinned", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLibraryArgs']]]]:
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        Any supported get_node_type id. If `instance_pool_id` is specified, this field is not needed.
        """
        return pulumi.get(self, "node_type_id")

    @node_type_id.setter
    def node_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_id", value)

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_workers", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of Cluster Policy to validate cluster and preset certain defaults. *The primary use for cluster policies is to allow users to create policy-scoped clusters via UI rather than sharing configuration for API-created clusters.* For example, when you specify `policy_id` of [external metastore](https://docs.databricks.com/administration-guide/clusters/policies.html#external-metastore-policy) policy, you still have to fill in relevant keys for `spark_conf`.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="singleUserName")
    def single_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The optional user name of the user to assign to an interactive cluster. This field is required when using standard AAD Passthrough for Azure Data Lake Storage (ADLS) with a single-user cluster (i.e., not high-concurrency clusters).
        """
        return pulumi.get(self, "single_user_name")

    @single_user_name.setter
    def single_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_user_name", value)

    @property
    @pulumi.getter(name="sparkConf")
    def spark_conf(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Map with key-value pairs to fine-tune Spark clusters, where you can provide custom [Spark configuration properties](https://spark.apache.org/docs/latest/configuration.html) in a cluster configuration.
        """
        return pulumi.get(self, "spark_conf")

    @spark_conf.setter
    def spark_conf(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "spark_conf", value)

    @property
    @pulumi.getter(name="sparkEnvVars")
    def spark_env_vars(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Map with environment variable key-value pairs to fine-tune Spark clusters. Key-value pairs of the form (X,Y) are exported (i.e., X='Y') while launching the driver and workers.
        """
        return pulumi.get(self, "spark_env_vars")

    @spark_env_vars.setter
    def spark_env_vars(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "spark_env_vars", value)

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        SSH public key contents that will be added to each Spark node in this cluster. The corresponding private keys can be used to login with the user name ubuntu on port 2200. You can specify up to 10 keys.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input['ClusterWorkloadTypeArgs']]:
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input['ClusterWorkloadTypeArgs']]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 apply_policy_default_values: Optional[pulumi.Input[bool]] = None,
                 autoscale: Optional[pulumi.Input['ClusterAutoscaleArgs']] = None,
                 autotermination_minutes: Optional[pulumi.Input[int]] = None,
                 aws_attributes: Optional[pulumi.Input['ClusterAwsAttributesArgs']] = None,
                 azure_attributes: Optional[pulumi.Input['ClusterAzureAttributesArgs']] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_log_conf: Optional[pulumi.Input['ClusterClusterLogConfArgs']] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 data_security_mode: Optional[pulumi.Input[str]] = None,
                 default_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 docker_image: Optional[pulumi.Input['ClusterDockerImageArgs']] = None,
                 driver_instance_pool_id: Optional[pulumi.Input[str]] = None,
                 driver_node_type_id: Optional[pulumi.Input[str]] = None,
                 enable_elastic_disk: Optional[pulumi.Input[bool]] = None,
                 enable_local_disk_encryption: Optional[pulumi.Input[bool]] = None,
                 gcp_attributes: Optional[pulumi.Input['ClusterGcpAttributesArgs']] = None,
                 idempotency_token: Optional[pulumi.Input[str]] = None,
                 init_scripts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInitScriptArgs']]]] = None,
                 instance_pool_id: Optional[pulumi.Input[str]] = None,
                 is_pinned: Optional[pulumi.Input[bool]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLibraryArgs']]]] = None,
                 node_type_id: Optional[pulumi.Input[str]] = None,
                 num_workers: Optional[pulumi.Input[int]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 single_user_name: Optional[pulumi.Input[str]] = None,
                 spark_conf: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_env_vars: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_version: Optional[pulumi.Input[str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input['ClusterWorkloadTypeArgs']] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[bool] apply_policy_default_values: Whether to use policy default values for missing cluster attributes.
        :param pulumi.Input[int] autotermination_minutes: Automatically terminate the cluster after being inactive for this time in minutes. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable automatic termination. Defaults to `60`.  _We highly recommend having this setting present for Interactive/BI clusters._
        :param pulumi.Input[str] cluster_name: Cluster name, which doesn’t have to be unique. If not specified at creation, the cluster name will be an empty string.
        :param pulumi.Input[Mapping[str, Any]] custom_tags: Additional tags for cluster resources. Databricks will tag all cluster resources (e.g., AWS EC2 instances and EBS volumes) with these tags in addition to `default_tags`.
        :param pulumi.Input[str] data_security_mode: Select the security features of the cluster. Unity Catalog requires `SINGLE_USER` or `USER_ISOLATION` mode. `LEGACY_PASSTHROUGH` for passthrough cluster and `LEGACY_TABLE_ACL` for Table ACL cluster. Default to `NONE`, i.e. no security feature enabled.
        :param pulumi.Input[Mapping[str, Any]] default_tags: (map) Tags that are added by Databricks by default, regardless of any custom_tags that may have been added. These include: Vendor: Databricks, Creator: <username_of_creator>, ClusterName: <name_of_cluster>, ClusterId: <id_of_cluster>, Name: <Databricks internal use>
        :param pulumi.Input[str] driver_instance_pool_id: similar to `instance_pool_id`, but for driver node. If omitted, and `instance_pool_id` is specified, then the driver will be allocated from that pool.
        :param pulumi.Input[str] driver_node_type_id: The node type of the Spark driver. This field is optional; if unset, API will set the driver node type to the same value as `node_type_id` defined above.
        :param pulumi.Input[bool] enable_elastic_disk: If you don’t want to allocate a fixed number of EBS volumes at cluster creation time, use autoscaling local storage. With autoscaling local storage, Databricks monitors the amount of free disk space available on your cluster’s Spark workers. If a worker begins to run too low on disk, Databricks automatically attaches a new EBS volume to the worker before it runs out of disk space. EBS volumes are attached up to a limit of 5 TB of total disk space per instance (including the instance’s local storage). To scale down EBS usage, make sure you have `autotermination_minutes` and `autoscale` attributes set. More documentation available at [cluster configuration page](https://docs.databricks.com/clusters/configure.html#autoscaling-local-storage-1).
        :param pulumi.Input[bool] enable_local_disk_encryption: Some instance types you use to run clusters may have locally attached disks. Databricks may store shuffle data or temporary data on these locally attached disks. To ensure that all data at rest is encrypted for all storage types, including shuffle data stored temporarily on your cluster’s local disks, you can enable local disk encryption. When local disk encryption is enabled, Databricks generates an encryption key locally unique to each cluster node and uses it to encrypt all data stored on local disks. The scope of the key is local to each cluster node and is destroyed along with the cluster node itself. During its lifetime, the key resides in memory for encryption and decryption and is stored encrypted on the disk. _Your workloads may run more slowly because of the performance impact of reading and writing encrypted data to and from local volumes. This feature is not available for all Azure Databricks subscriptions. Contact your Microsoft or Databricks account representative to request access._
        :param pulumi.Input[str] idempotency_token: An optional token to guarantee the idempotency of cluster creation requests. If an active cluster with the provided token already exists, the request will not create a new cluster, but it will return the existing running cluster's ID instead. If you specify the idempotency token, upon failure, you can retry until the request succeeds. Databricks platform guarantees to launch exactly one cluster with that idempotency token. This token should have at most 64 characters.
        :param pulumi.Input[str] instance_pool_id: - To reduce cluster start time, you can attach a cluster to a predefined pool of idle instances. When attached to a pool, a cluster allocates its driver and worker nodes from the pool. If the pool does not have sufficient idle resources to accommodate the cluster’s request, it expands by allocating new instances from the instance provider. When an attached cluster changes its state to `TERMINATED`, the instances it used are returned to the pool and reused by a different cluster.
        :param pulumi.Input[bool] is_pinned: boolean value specifying if the cluster is pinned (not pinned by default). You must be a Databricks administrator to use this.  The pinned clusters' maximum number is [limited to 70](https://docs.databricks.com/clusters/clusters-manage.html#pin-a-cluster), so `apply` may fail if you have more than that.
        :param pulumi.Input[str] node_type_id: Any supported get_node_type id. If `instance_pool_id` is specified, this field is not needed.
        :param pulumi.Input[str] policy_id: Identifier of Cluster Policy to validate cluster and preset certain defaults. *The primary use for cluster policies is to allow users to create policy-scoped clusters via UI rather than sharing configuration for API-created clusters.* For example, when you specify `policy_id` of [external metastore](https://docs.databricks.com/administration-guide/clusters/policies.html#external-metastore-policy) policy, you still have to fill in relevant keys for `spark_conf`.
        :param pulumi.Input[str] single_user_name: The optional user name of the user to assign to an interactive cluster. This field is required when using standard AAD Passthrough for Azure Data Lake Storage (ADLS) with a single-user cluster (i.e., not high-concurrency clusters).
        :param pulumi.Input[Mapping[str, Any]] spark_conf: Map with key-value pairs to fine-tune Spark clusters, where you can provide custom [Spark configuration properties](https://spark.apache.org/docs/latest/configuration.html) in a cluster configuration.
        :param pulumi.Input[Mapping[str, Any]] spark_env_vars: Map with environment variable key-value pairs to fine-tune Spark clusters. Key-value pairs of the form (X,Y) are exported (i.e., X='Y') while launching the driver and workers.
        :param pulumi.Input[str] spark_version: [Runtime version](https://docs.databricks.com/runtime/index.html) of the cluster. Any supported get_spark_version id.  We advise using Cluster Policies to restrict the list of versions for simplicity while maintaining enough control.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: SSH public key contents that will be added to each Spark node in this cluster. The corresponding private keys can be used to login with the user name ubuntu on port 2200. You can specify up to 10 keys.
        :param pulumi.Input[str] state: (string) State of the cluster.
        """
        if apply_policy_default_values is not None:
            pulumi.set(__self__, "apply_policy_default_values", apply_policy_default_values)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if autotermination_minutes is not None:
            pulumi.set(__self__, "autotermination_minutes", autotermination_minutes)
        if aws_attributes is not None:
            pulumi.set(__self__, "aws_attributes", aws_attributes)
        if azure_attributes is not None:
            pulumi.set(__self__, "azure_attributes", azure_attributes)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_log_conf is not None:
            pulumi.set(__self__, "cluster_log_conf", cluster_log_conf)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if data_security_mode is not None:
            pulumi.set(__self__, "data_security_mode", data_security_mode)
        if default_tags is not None:
            pulumi.set(__self__, "default_tags", default_tags)
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if driver_instance_pool_id is not None:
            pulumi.set(__self__, "driver_instance_pool_id", driver_instance_pool_id)
        if driver_node_type_id is not None:
            pulumi.set(__self__, "driver_node_type_id", driver_node_type_id)
        if enable_elastic_disk is not None:
            pulumi.set(__self__, "enable_elastic_disk", enable_elastic_disk)
        if enable_local_disk_encryption is not None:
            pulumi.set(__self__, "enable_local_disk_encryption", enable_local_disk_encryption)
        if gcp_attributes is not None:
            pulumi.set(__self__, "gcp_attributes", gcp_attributes)
        if idempotency_token is not None:
            pulumi.set(__self__, "idempotency_token", idempotency_token)
        if init_scripts is not None:
            pulumi.set(__self__, "init_scripts", init_scripts)
        if instance_pool_id is not None:
            pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if is_pinned is not None:
            pulumi.set(__self__, "is_pinned", is_pinned)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if node_type_id is not None:
            pulumi.set(__self__, "node_type_id", node_type_id)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if single_user_name is not None:
            pulumi.set(__self__, "single_user_name", single_user_name)
        if spark_conf is not None:
            pulumi.set(__self__, "spark_conf", spark_conf)
        if spark_env_vars is not None:
            pulumi.set(__self__, "spark_env_vars", spark_env_vars)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="applyPolicyDefaultValues")
    def apply_policy_default_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use policy default values for missing cluster attributes.
        """
        return pulumi.get(self, "apply_policy_default_values")

    @apply_policy_default_values.setter
    def apply_policy_default_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_policy_default_values", value)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input['ClusterAutoscaleArgs']]:
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input['ClusterAutoscaleArgs']]):
        pulumi.set(self, "autoscale", value)

    @property
    @pulumi.getter(name="autoterminationMinutes")
    def autotermination_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Automatically terminate the cluster after being inactive for this time in minutes. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable automatic termination. Defaults to `60`.  _We highly recommend having this setting present for Interactive/BI clusters._
        """
        return pulumi.get(self, "autotermination_minutes")

    @autotermination_minutes.setter
    def autotermination_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "autotermination_minutes", value)

    @property
    @pulumi.getter(name="awsAttributes")
    def aws_attributes(self) -> Optional[pulumi.Input['ClusterAwsAttributesArgs']]:
        return pulumi.get(self, "aws_attributes")

    @aws_attributes.setter
    def aws_attributes(self, value: Optional[pulumi.Input['ClusterAwsAttributesArgs']]):
        pulumi.set(self, "aws_attributes", value)

    @property
    @pulumi.getter(name="azureAttributes")
    def azure_attributes(self) -> Optional[pulumi.Input['ClusterAzureAttributesArgs']]:
        return pulumi.get(self, "azure_attributes")

    @azure_attributes.setter
    def azure_attributes(self, value: Optional[pulumi.Input['ClusterAzureAttributesArgs']]):
        pulumi.set(self, "azure_attributes", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="clusterLogConf")
    def cluster_log_conf(self) -> Optional[pulumi.Input['ClusterClusterLogConfArgs']]:
        return pulumi.get(self, "cluster_log_conf")

    @cluster_log_conf.setter
    def cluster_log_conf(self, value: Optional[pulumi.Input['ClusterClusterLogConfArgs']]):
        pulumi.set(self, "cluster_log_conf", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster name, which doesn’t have to be unique. If not specified at creation, the cluster name will be an empty string.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Additional tags for cluster resources. Databricks will tag all cluster resources (e.g., AWS EC2 instances and EBS volumes) with these tags in addition to `default_tags`.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "custom_tags", value)

    @property
    @pulumi.getter(name="dataSecurityMode")
    def data_security_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Select the security features of the cluster. Unity Catalog requires `SINGLE_USER` or `USER_ISOLATION` mode. `LEGACY_PASSTHROUGH` for passthrough cluster and `LEGACY_TABLE_ACL` for Table ACL cluster. Default to `NONE`, i.e. no security feature enabled.
        """
        return pulumi.get(self, "data_security_mode")

    @data_security_mode.setter
    def data_security_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_security_mode", value)

    @property
    @pulumi.getter(name="defaultTags")
    def default_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (map) Tags that are added by Databricks by default, regardless of any custom_tags that may have been added. These include: Vendor: Databricks, Creator: <username_of_creator>, ClusterName: <name_of_cluster>, ClusterId: <id_of_cluster>, Name: <Databricks internal use>
        """
        return pulumi.get(self, "default_tags")

    @default_tags.setter
    def default_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "default_tags", value)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[pulumi.Input['ClusterDockerImageArgs']]:
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: Optional[pulumi.Input['ClusterDockerImageArgs']]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter(name="driverInstancePoolId")
    def driver_instance_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        similar to `instance_pool_id`, but for driver node. If omitted, and `instance_pool_id` is specified, then the driver will be allocated from that pool.
        """
        return pulumi.get(self, "driver_instance_pool_id")

    @driver_instance_pool_id.setter
    def driver_instance_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_instance_pool_id", value)

    @property
    @pulumi.getter(name="driverNodeTypeId")
    def driver_node_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        The node type of the Spark driver. This field is optional; if unset, API will set the driver node type to the same value as `node_type_id` defined above.
        """
        return pulumi.get(self, "driver_node_type_id")

    @driver_node_type_id.setter
    def driver_node_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_node_type_id", value)

    @property
    @pulumi.getter(name="enableElasticDisk")
    def enable_elastic_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        If you don’t want to allocate a fixed number of EBS volumes at cluster creation time, use autoscaling local storage. With autoscaling local storage, Databricks monitors the amount of free disk space available on your cluster’s Spark workers. If a worker begins to run too low on disk, Databricks automatically attaches a new EBS volume to the worker before it runs out of disk space. EBS volumes are attached up to a limit of 5 TB of total disk space per instance (including the instance’s local storage). To scale down EBS usage, make sure you have `autotermination_minutes` and `autoscale` attributes set. More documentation available at [cluster configuration page](https://docs.databricks.com/clusters/configure.html#autoscaling-local-storage-1).
        """
        return pulumi.get(self, "enable_elastic_disk")

    @enable_elastic_disk.setter
    def enable_elastic_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_elastic_disk", value)

    @property
    @pulumi.getter(name="enableLocalDiskEncryption")
    def enable_local_disk_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Some instance types you use to run clusters may have locally attached disks. Databricks may store shuffle data or temporary data on these locally attached disks. To ensure that all data at rest is encrypted for all storage types, including shuffle data stored temporarily on your cluster’s local disks, you can enable local disk encryption. When local disk encryption is enabled, Databricks generates an encryption key locally unique to each cluster node and uses it to encrypt all data stored on local disks. The scope of the key is local to each cluster node and is destroyed along with the cluster node itself. During its lifetime, the key resides in memory for encryption and decryption and is stored encrypted on the disk. _Your workloads may run more slowly because of the performance impact of reading and writing encrypted data to and from local volumes. This feature is not available for all Azure Databricks subscriptions. Contact your Microsoft or Databricks account representative to request access._
        """
        return pulumi.get(self, "enable_local_disk_encryption")

    @enable_local_disk_encryption.setter
    def enable_local_disk_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_local_disk_encryption", value)

    @property
    @pulumi.getter(name="gcpAttributes")
    def gcp_attributes(self) -> Optional[pulumi.Input['ClusterGcpAttributesArgs']]:
        return pulumi.get(self, "gcp_attributes")

    @gcp_attributes.setter
    def gcp_attributes(self, value: Optional[pulumi.Input['ClusterGcpAttributesArgs']]):
        pulumi.set(self, "gcp_attributes", value)

    @property
    @pulumi.getter(name="idempotencyToken")
    def idempotency_token(self) -> Optional[pulumi.Input[str]]:
        """
        An optional token to guarantee the idempotency of cluster creation requests. If an active cluster with the provided token already exists, the request will not create a new cluster, but it will return the existing running cluster's ID instead. If you specify the idempotency token, upon failure, you can retry until the request succeeds. Databricks platform guarantees to launch exactly one cluster with that idempotency token. This token should have at most 64 characters.
        """
        return pulumi.get(self, "idempotency_token")

    @idempotency_token.setter
    def idempotency_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idempotency_token", value)

    @property
    @pulumi.getter(name="initScripts")
    def init_scripts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInitScriptArgs']]]]:
        return pulumi.get(self, "init_scripts")

    @init_scripts.setter
    def init_scripts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterInitScriptArgs']]]]):
        pulumi.set(self, "init_scripts", value)

    @property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        - To reduce cluster start time, you can attach a cluster to a predefined pool of idle instances. When attached to a pool, a cluster allocates its driver and worker nodes from the pool. If the pool does not have sufficient idle resources to accommodate the cluster’s request, it expands by allocating new instances from the instance provider. When an attached cluster changes its state to `TERMINATED`, the instances it used are returned to the pool and reused by a different cluster.
        """
        return pulumi.get(self, "instance_pool_id")

    @instance_pool_id.setter
    def instance_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_pool_id", value)

    @property
    @pulumi.getter(name="isPinned")
    def is_pinned(self) -> Optional[pulumi.Input[bool]]:
        """
        boolean value specifying if the cluster is pinned (not pinned by default). You must be a Databricks administrator to use this.  The pinned clusters' maximum number is [limited to 70](https://docs.databricks.com/clusters/clusters-manage.html#pin-a-cluster), so `apply` may fail if you have more than that.
        """
        return pulumi.get(self, "is_pinned")

    @is_pinned.setter
    def is_pinned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pinned", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLibraryArgs']]]]:
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        Any supported get_node_type id. If `instance_pool_id` is specified, this field is not needed.
        """
        return pulumi.get(self, "node_type_id")

    @node_type_id.setter
    def node_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_id", value)

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_workers", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of Cluster Policy to validate cluster and preset certain defaults. *The primary use for cluster policies is to allow users to create policy-scoped clusters via UI rather than sharing configuration for API-created clusters.* For example, when you specify `policy_id` of [external metastore](https://docs.databricks.com/administration-guide/clusters/policies.html#external-metastore-policy) policy, you still have to fill in relevant keys for `spark_conf`.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="singleUserName")
    def single_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The optional user name of the user to assign to an interactive cluster. This field is required when using standard AAD Passthrough for Azure Data Lake Storage (ADLS) with a single-user cluster (i.e., not high-concurrency clusters).
        """
        return pulumi.get(self, "single_user_name")

    @single_user_name.setter
    def single_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "single_user_name", value)

    @property
    @pulumi.getter(name="sparkConf")
    def spark_conf(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Map with key-value pairs to fine-tune Spark clusters, where you can provide custom [Spark configuration properties](https://spark.apache.org/docs/latest/configuration.html) in a cluster configuration.
        """
        return pulumi.get(self, "spark_conf")

    @spark_conf.setter
    def spark_conf(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "spark_conf", value)

    @property
    @pulumi.getter(name="sparkEnvVars")
    def spark_env_vars(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Map with environment variable key-value pairs to fine-tune Spark clusters. Key-value pairs of the form (X,Y) are exported (i.e., X='Y') while launching the driver and workers.
        """
        return pulumi.get(self, "spark_env_vars")

    @spark_env_vars.setter
    def spark_env_vars(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "spark_env_vars", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[pulumi.Input[str]]:
        """
        [Runtime version](https://docs.databricks.com/runtime/index.html) of the cluster. Any supported get_spark_version id.  We advise using Cluster Policies to restrict the list of versions for simplicity while maintaining enough control.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        SSH public key contents that will be added to each Spark node in this cluster. The corresponding private keys can be used to login with the user name ubuntu on port 2200. You can specify up to 10 keys.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (string) State of the cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input['ClusterWorkloadTypeArgs']]:
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input['ClusterWorkloadTypeArgs']]):
        pulumi.set(self, "workload_type", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_policy_default_values: Optional[pulumi.Input[bool]] = None,
                 autoscale: Optional[pulumi.Input[pulumi.InputType['ClusterAutoscaleArgs']]] = None,
                 autotermination_minutes: Optional[pulumi.Input[int]] = None,
                 aws_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterAwsAttributesArgs']]] = None,
                 azure_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterAzureAttributesArgs']]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_log_conf: Optional[pulumi.Input[pulumi.InputType['ClusterClusterLogConfArgs']]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 data_security_mode: Optional[pulumi.Input[str]] = None,
                 docker_image: Optional[pulumi.Input[pulumi.InputType['ClusterDockerImageArgs']]] = None,
                 driver_instance_pool_id: Optional[pulumi.Input[str]] = None,
                 driver_node_type_id: Optional[pulumi.Input[str]] = None,
                 enable_elastic_disk: Optional[pulumi.Input[bool]] = None,
                 enable_local_disk_encryption: Optional[pulumi.Input[bool]] = None,
                 gcp_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterGcpAttributesArgs']]] = None,
                 idempotency_token: Optional[pulumi.Input[str]] = None,
                 init_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterInitScriptArgs']]]]] = None,
                 instance_pool_id: Optional[pulumi.Input[str]] = None,
                 is_pinned: Optional[pulumi.Input[bool]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterLibraryArgs']]]]] = None,
                 node_type_id: Optional[pulumi.Input[str]] = None,
                 num_workers: Optional[pulumi.Input[int]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 single_user_name: Optional[pulumi.Input[str]] = None,
                 spark_conf: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_env_vars: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_version: Optional[pulumi.Input[str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 workload_type: Optional[pulumi.Input[pulumi.InputType['ClusterWorkloadTypeArgs']]] = None,
                 __props__=None):
        """
        ## Import

        The resource cluster can be imported using cluster id. bash

        ```sh
         $ pulumi import databricks:index/cluster:Cluster this <cluster-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_policy_default_values: Whether to use policy default values for missing cluster attributes.
        :param pulumi.Input[int] autotermination_minutes: Automatically terminate the cluster after being inactive for this time in minutes. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable automatic termination. Defaults to `60`.  _We highly recommend having this setting present for Interactive/BI clusters._
        :param pulumi.Input[str] cluster_name: Cluster name, which doesn’t have to be unique. If not specified at creation, the cluster name will be an empty string.
        :param pulumi.Input[Mapping[str, Any]] custom_tags: Additional tags for cluster resources. Databricks will tag all cluster resources (e.g., AWS EC2 instances and EBS volumes) with these tags in addition to `default_tags`.
        :param pulumi.Input[str] data_security_mode: Select the security features of the cluster. Unity Catalog requires `SINGLE_USER` or `USER_ISOLATION` mode. `LEGACY_PASSTHROUGH` for passthrough cluster and `LEGACY_TABLE_ACL` for Table ACL cluster. Default to `NONE`, i.e. no security feature enabled.
        :param pulumi.Input[str] driver_instance_pool_id: similar to `instance_pool_id`, but for driver node. If omitted, and `instance_pool_id` is specified, then the driver will be allocated from that pool.
        :param pulumi.Input[str] driver_node_type_id: The node type of the Spark driver. This field is optional; if unset, API will set the driver node type to the same value as `node_type_id` defined above.
        :param pulumi.Input[bool] enable_elastic_disk: If you don’t want to allocate a fixed number of EBS volumes at cluster creation time, use autoscaling local storage. With autoscaling local storage, Databricks monitors the amount of free disk space available on your cluster’s Spark workers. If a worker begins to run too low on disk, Databricks automatically attaches a new EBS volume to the worker before it runs out of disk space. EBS volumes are attached up to a limit of 5 TB of total disk space per instance (including the instance’s local storage). To scale down EBS usage, make sure you have `autotermination_minutes` and `autoscale` attributes set. More documentation available at [cluster configuration page](https://docs.databricks.com/clusters/configure.html#autoscaling-local-storage-1).
        :param pulumi.Input[bool] enable_local_disk_encryption: Some instance types you use to run clusters may have locally attached disks. Databricks may store shuffle data or temporary data on these locally attached disks. To ensure that all data at rest is encrypted for all storage types, including shuffle data stored temporarily on your cluster’s local disks, you can enable local disk encryption. When local disk encryption is enabled, Databricks generates an encryption key locally unique to each cluster node and uses it to encrypt all data stored on local disks. The scope of the key is local to each cluster node and is destroyed along with the cluster node itself. During its lifetime, the key resides in memory for encryption and decryption and is stored encrypted on the disk. _Your workloads may run more slowly because of the performance impact of reading and writing encrypted data to and from local volumes. This feature is not available for all Azure Databricks subscriptions. Contact your Microsoft or Databricks account representative to request access._
        :param pulumi.Input[str] idempotency_token: An optional token to guarantee the idempotency of cluster creation requests. If an active cluster with the provided token already exists, the request will not create a new cluster, but it will return the existing running cluster's ID instead. If you specify the idempotency token, upon failure, you can retry until the request succeeds. Databricks platform guarantees to launch exactly one cluster with that idempotency token. This token should have at most 64 characters.
        :param pulumi.Input[str] instance_pool_id: - To reduce cluster start time, you can attach a cluster to a predefined pool of idle instances. When attached to a pool, a cluster allocates its driver and worker nodes from the pool. If the pool does not have sufficient idle resources to accommodate the cluster’s request, it expands by allocating new instances from the instance provider. When an attached cluster changes its state to `TERMINATED`, the instances it used are returned to the pool and reused by a different cluster.
        :param pulumi.Input[bool] is_pinned: boolean value specifying if the cluster is pinned (not pinned by default). You must be a Databricks administrator to use this.  The pinned clusters' maximum number is [limited to 70](https://docs.databricks.com/clusters/clusters-manage.html#pin-a-cluster), so `apply` may fail if you have more than that.
        :param pulumi.Input[str] node_type_id: Any supported get_node_type id. If `instance_pool_id` is specified, this field is not needed.
        :param pulumi.Input[str] policy_id: Identifier of Cluster Policy to validate cluster and preset certain defaults. *The primary use for cluster policies is to allow users to create policy-scoped clusters via UI rather than sharing configuration for API-created clusters.* For example, when you specify `policy_id` of [external metastore](https://docs.databricks.com/administration-guide/clusters/policies.html#external-metastore-policy) policy, you still have to fill in relevant keys for `spark_conf`.
        :param pulumi.Input[str] single_user_name: The optional user name of the user to assign to an interactive cluster. This field is required when using standard AAD Passthrough for Azure Data Lake Storage (ADLS) with a single-user cluster (i.e., not high-concurrency clusters).
        :param pulumi.Input[Mapping[str, Any]] spark_conf: Map with key-value pairs to fine-tune Spark clusters, where you can provide custom [Spark configuration properties](https://spark.apache.org/docs/latest/configuration.html) in a cluster configuration.
        :param pulumi.Input[Mapping[str, Any]] spark_env_vars: Map with environment variable key-value pairs to fine-tune Spark clusters. Key-value pairs of the form (X,Y) are exported (i.e., X='Y') while launching the driver and workers.
        :param pulumi.Input[str] spark_version: [Runtime version](https://docs.databricks.com/runtime/index.html) of the cluster. Any supported get_spark_version id.  We advise using Cluster Policies to restrict the list of versions for simplicity while maintaining enough control.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: SSH public key contents that will be added to each Spark node in this cluster. The corresponding private keys can be used to login with the user name ubuntu on port 2200. You can specify up to 10 keys.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        The resource cluster can be imported using cluster id. bash

        ```sh
         $ pulumi import databricks:index/cluster:Cluster this <cluster-id>
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_policy_default_values: Optional[pulumi.Input[bool]] = None,
                 autoscale: Optional[pulumi.Input[pulumi.InputType['ClusterAutoscaleArgs']]] = None,
                 autotermination_minutes: Optional[pulumi.Input[int]] = None,
                 aws_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterAwsAttributesArgs']]] = None,
                 azure_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterAzureAttributesArgs']]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_log_conf: Optional[pulumi.Input[pulumi.InputType['ClusterClusterLogConfArgs']]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 data_security_mode: Optional[pulumi.Input[str]] = None,
                 docker_image: Optional[pulumi.Input[pulumi.InputType['ClusterDockerImageArgs']]] = None,
                 driver_instance_pool_id: Optional[pulumi.Input[str]] = None,
                 driver_node_type_id: Optional[pulumi.Input[str]] = None,
                 enable_elastic_disk: Optional[pulumi.Input[bool]] = None,
                 enable_local_disk_encryption: Optional[pulumi.Input[bool]] = None,
                 gcp_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterGcpAttributesArgs']]] = None,
                 idempotency_token: Optional[pulumi.Input[str]] = None,
                 init_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterInitScriptArgs']]]]] = None,
                 instance_pool_id: Optional[pulumi.Input[str]] = None,
                 is_pinned: Optional[pulumi.Input[bool]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterLibraryArgs']]]]] = None,
                 node_type_id: Optional[pulumi.Input[str]] = None,
                 num_workers: Optional[pulumi.Input[int]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 single_user_name: Optional[pulumi.Input[str]] = None,
                 spark_conf: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_env_vars: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_version: Optional[pulumi.Input[str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 workload_type: Optional[pulumi.Input[pulumi.InputType['ClusterWorkloadTypeArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["apply_policy_default_values"] = apply_policy_default_values
            __props__.__dict__["autoscale"] = autoscale
            __props__.__dict__["autotermination_minutes"] = autotermination_minutes
            __props__.__dict__["aws_attributes"] = aws_attributes
            __props__.__dict__["azure_attributes"] = azure_attributes
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["cluster_log_conf"] = cluster_log_conf
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["custom_tags"] = custom_tags
            __props__.__dict__["data_security_mode"] = data_security_mode
            __props__.__dict__["docker_image"] = docker_image
            __props__.__dict__["driver_instance_pool_id"] = driver_instance_pool_id
            __props__.__dict__["driver_node_type_id"] = driver_node_type_id
            __props__.__dict__["enable_elastic_disk"] = enable_elastic_disk
            __props__.__dict__["enable_local_disk_encryption"] = enable_local_disk_encryption
            __props__.__dict__["gcp_attributes"] = gcp_attributes
            __props__.__dict__["idempotency_token"] = idempotency_token
            __props__.__dict__["init_scripts"] = init_scripts
            __props__.__dict__["instance_pool_id"] = instance_pool_id
            __props__.__dict__["is_pinned"] = is_pinned
            __props__.__dict__["libraries"] = libraries
            __props__.__dict__["node_type_id"] = node_type_id
            __props__.__dict__["num_workers"] = num_workers
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["single_user_name"] = single_user_name
            __props__.__dict__["spark_conf"] = spark_conf
            __props__.__dict__["spark_env_vars"] = spark_env_vars
            if spark_version is None and not opts.urn:
                raise TypeError("Missing required property 'spark_version'")
            __props__.__dict__["spark_version"] = spark_version
            __props__.__dict__["ssh_public_keys"] = ssh_public_keys
            __props__.__dict__["workload_type"] = workload_type
            __props__.__dict__["default_tags"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["url"] = None
        super(Cluster, __self__).__init__(
            'databricks:index/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_policy_default_values: Optional[pulumi.Input[bool]] = None,
            autoscale: Optional[pulumi.Input[pulumi.InputType['ClusterAutoscaleArgs']]] = None,
            autotermination_minutes: Optional[pulumi.Input[int]] = None,
            aws_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterAwsAttributesArgs']]] = None,
            azure_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterAzureAttributesArgs']]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            cluster_log_conf: Optional[pulumi.Input[pulumi.InputType['ClusterClusterLogConfArgs']]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            custom_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            data_security_mode: Optional[pulumi.Input[str]] = None,
            default_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            docker_image: Optional[pulumi.Input[pulumi.InputType['ClusterDockerImageArgs']]] = None,
            driver_instance_pool_id: Optional[pulumi.Input[str]] = None,
            driver_node_type_id: Optional[pulumi.Input[str]] = None,
            enable_elastic_disk: Optional[pulumi.Input[bool]] = None,
            enable_local_disk_encryption: Optional[pulumi.Input[bool]] = None,
            gcp_attributes: Optional[pulumi.Input[pulumi.InputType['ClusterGcpAttributesArgs']]] = None,
            idempotency_token: Optional[pulumi.Input[str]] = None,
            init_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterInitScriptArgs']]]]] = None,
            instance_pool_id: Optional[pulumi.Input[str]] = None,
            is_pinned: Optional[pulumi.Input[bool]] = None,
            libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterLibraryArgs']]]]] = None,
            node_type_id: Optional[pulumi.Input[str]] = None,
            num_workers: Optional[pulumi.Input[int]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            single_user_name: Optional[pulumi.Input[str]] = None,
            spark_conf: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            spark_env_vars: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            spark_version: Optional[pulumi.Input[str]] = None,
            ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            workload_type: Optional[pulumi.Input[pulumi.InputType['ClusterWorkloadTypeArgs']]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_policy_default_values: Whether to use policy default values for missing cluster attributes.
        :param pulumi.Input[int] autotermination_minutes: Automatically terminate the cluster after being inactive for this time in minutes. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable automatic termination. Defaults to `60`.  _We highly recommend having this setting present for Interactive/BI clusters._
        :param pulumi.Input[str] cluster_name: Cluster name, which doesn’t have to be unique. If not specified at creation, the cluster name will be an empty string.
        :param pulumi.Input[Mapping[str, Any]] custom_tags: Additional tags for cluster resources. Databricks will tag all cluster resources (e.g., AWS EC2 instances and EBS volumes) with these tags in addition to `default_tags`.
        :param pulumi.Input[str] data_security_mode: Select the security features of the cluster. Unity Catalog requires `SINGLE_USER` or `USER_ISOLATION` mode. `LEGACY_PASSTHROUGH` for passthrough cluster and `LEGACY_TABLE_ACL` for Table ACL cluster. Default to `NONE`, i.e. no security feature enabled.
        :param pulumi.Input[Mapping[str, Any]] default_tags: (map) Tags that are added by Databricks by default, regardless of any custom_tags that may have been added. These include: Vendor: Databricks, Creator: <username_of_creator>, ClusterName: <name_of_cluster>, ClusterId: <id_of_cluster>, Name: <Databricks internal use>
        :param pulumi.Input[str] driver_instance_pool_id: similar to `instance_pool_id`, but for driver node. If omitted, and `instance_pool_id` is specified, then the driver will be allocated from that pool.
        :param pulumi.Input[str] driver_node_type_id: The node type of the Spark driver. This field is optional; if unset, API will set the driver node type to the same value as `node_type_id` defined above.
        :param pulumi.Input[bool] enable_elastic_disk: If you don’t want to allocate a fixed number of EBS volumes at cluster creation time, use autoscaling local storage. With autoscaling local storage, Databricks monitors the amount of free disk space available on your cluster’s Spark workers. If a worker begins to run too low on disk, Databricks automatically attaches a new EBS volume to the worker before it runs out of disk space. EBS volumes are attached up to a limit of 5 TB of total disk space per instance (including the instance’s local storage). To scale down EBS usage, make sure you have `autotermination_minutes` and `autoscale` attributes set. More documentation available at [cluster configuration page](https://docs.databricks.com/clusters/configure.html#autoscaling-local-storage-1).
        :param pulumi.Input[bool] enable_local_disk_encryption: Some instance types you use to run clusters may have locally attached disks. Databricks may store shuffle data or temporary data on these locally attached disks. To ensure that all data at rest is encrypted for all storage types, including shuffle data stored temporarily on your cluster’s local disks, you can enable local disk encryption. When local disk encryption is enabled, Databricks generates an encryption key locally unique to each cluster node and uses it to encrypt all data stored on local disks. The scope of the key is local to each cluster node and is destroyed along with the cluster node itself. During its lifetime, the key resides in memory for encryption and decryption and is stored encrypted on the disk. _Your workloads may run more slowly because of the performance impact of reading and writing encrypted data to and from local volumes. This feature is not available for all Azure Databricks subscriptions. Contact your Microsoft or Databricks account representative to request access._
        :param pulumi.Input[str] idempotency_token: An optional token to guarantee the idempotency of cluster creation requests. If an active cluster with the provided token already exists, the request will not create a new cluster, but it will return the existing running cluster's ID instead. If you specify the idempotency token, upon failure, you can retry until the request succeeds. Databricks platform guarantees to launch exactly one cluster with that idempotency token. This token should have at most 64 characters.
        :param pulumi.Input[str] instance_pool_id: - To reduce cluster start time, you can attach a cluster to a predefined pool of idle instances. When attached to a pool, a cluster allocates its driver and worker nodes from the pool. If the pool does not have sufficient idle resources to accommodate the cluster’s request, it expands by allocating new instances from the instance provider. When an attached cluster changes its state to `TERMINATED`, the instances it used are returned to the pool and reused by a different cluster.
        :param pulumi.Input[bool] is_pinned: boolean value specifying if the cluster is pinned (not pinned by default). You must be a Databricks administrator to use this.  The pinned clusters' maximum number is [limited to 70](https://docs.databricks.com/clusters/clusters-manage.html#pin-a-cluster), so `apply` may fail if you have more than that.
        :param pulumi.Input[str] node_type_id: Any supported get_node_type id. If `instance_pool_id` is specified, this field is not needed.
        :param pulumi.Input[str] policy_id: Identifier of Cluster Policy to validate cluster and preset certain defaults. *The primary use for cluster policies is to allow users to create policy-scoped clusters via UI rather than sharing configuration for API-created clusters.* For example, when you specify `policy_id` of [external metastore](https://docs.databricks.com/administration-guide/clusters/policies.html#external-metastore-policy) policy, you still have to fill in relevant keys for `spark_conf`.
        :param pulumi.Input[str] single_user_name: The optional user name of the user to assign to an interactive cluster. This field is required when using standard AAD Passthrough for Azure Data Lake Storage (ADLS) with a single-user cluster (i.e., not high-concurrency clusters).
        :param pulumi.Input[Mapping[str, Any]] spark_conf: Map with key-value pairs to fine-tune Spark clusters, where you can provide custom [Spark configuration properties](https://spark.apache.org/docs/latest/configuration.html) in a cluster configuration.
        :param pulumi.Input[Mapping[str, Any]] spark_env_vars: Map with environment variable key-value pairs to fine-tune Spark clusters. Key-value pairs of the form (X,Y) are exported (i.e., X='Y') while launching the driver and workers.
        :param pulumi.Input[str] spark_version: [Runtime version](https://docs.databricks.com/runtime/index.html) of the cluster. Any supported get_spark_version id.  We advise using Cluster Policies to restrict the list of versions for simplicity while maintaining enough control.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: SSH public key contents that will be added to each Spark node in this cluster. The corresponding private keys can be used to login with the user name ubuntu on port 2200. You can specify up to 10 keys.
        :param pulumi.Input[str] state: (string) State of the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["apply_policy_default_values"] = apply_policy_default_values
        __props__.__dict__["autoscale"] = autoscale
        __props__.__dict__["autotermination_minutes"] = autotermination_minutes
        __props__.__dict__["aws_attributes"] = aws_attributes
        __props__.__dict__["azure_attributes"] = azure_attributes
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_log_conf"] = cluster_log_conf
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["custom_tags"] = custom_tags
        __props__.__dict__["data_security_mode"] = data_security_mode
        __props__.__dict__["default_tags"] = default_tags
        __props__.__dict__["docker_image"] = docker_image
        __props__.__dict__["driver_instance_pool_id"] = driver_instance_pool_id
        __props__.__dict__["driver_node_type_id"] = driver_node_type_id
        __props__.__dict__["enable_elastic_disk"] = enable_elastic_disk
        __props__.__dict__["enable_local_disk_encryption"] = enable_local_disk_encryption
        __props__.__dict__["gcp_attributes"] = gcp_attributes
        __props__.__dict__["idempotency_token"] = idempotency_token
        __props__.__dict__["init_scripts"] = init_scripts
        __props__.__dict__["instance_pool_id"] = instance_pool_id
        __props__.__dict__["is_pinned"] = is_pinned
        __props__.__dict__["libraries"] = libraries
        __props__.__dict__["node_type_id"] = node_type_id
        __props__.__dict__["num_workers"] = num_workers
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["single_user_name"] = single_user_name
        __props__.__dict__["spark_conf"] = spark_conf
        __props__.__dict__["spark_env_vars"] = spark_env_vars
        __props__.__dict__["spark_version"] = spark_version
        __props__.__dict__["ssh_public_keys"] = ssh_public_keys
        __props__.__dict__["state"] = state
        __props__.__dict__["url"] = url
        __props__.__dict__["workload_type"] = workload_type
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyPolicyDefaultValues")
    def apply_policy_default_values(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to use policy default values for missing cluster attributes.
        """
        return pulumi.get(self, "apply_policy_default_values")

    @property
    @pulumi.getter
    def autoscale(self) -> pulumi.Output[Optional['outputs.ClusterAutoscale']]:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="autoterminationMinutes")
    def autotermination_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        Automatically terminate the cluster after being inactive for this time in minutes. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable automatic termination. Defaults to `60`.  _We highly recommend having this setting present for Interactive/BI clusters._
        """
        return pulumi.get(self, "autotermination_minutes")

    @property
    @pulumi.getter(name="awsAttributes")
    def aws_attributes(self) -> pulumi.Output[Optional['outputs.ClusterAwsAttributes']]:
        return pulumi.get(self, "aws_attributes")

    @property
    @pulumi.getter(name="azureAttributes")
    def azure_attributes(self) -> pulumi.Output[Optional['outputs.ClusterAzureAttributes']]:
        return pulumi.get(self, "azure_attributes")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterLogConf")
    def cluster_log_conf(self) -> pulumi.Output[Optional['outputs.ClusterClusterLogConf']]:
        return pulumi.get(self, "cluster_log_conf")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster name, which doesn’t have to be unique. If not specified at creation, the cluster name will be an empty string.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Additional tags for cluster resources. Databricks will tag all cluster resources (e.g., AWS EC2 instances and EBS volumes) with these tags in addition to `default_tags`.
        """
        return pulumi.get(self, "custom_tags")

    @property
    @pulumi.getter(name="dataSecurityMode")
    def data_security_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Select the security features of the cluster. Unity Catalog requires `SINGLE_USER` or `USER_ISOLATION` mode. `LEGACY_PASSTHROUGH` for passthrough cluster and `LEGACY_TABLE_ACL` for Table ACL cluster. Default to `NONE`, i.e. no security feature enabled.
        """
        return pulumi.get(self, "data_security_mode")

    @property
    @pulumi.getter(name="defaultTags")
    def default_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (map) Tags that are added by Databricks by default, regardless of any custom_tags that may have been added. These include: Vendor: Databricks, Creator: <username_of_creator>, ClusterName: <name_of_cluster>, ClusterId: <id_of_cluster>, Name: <Databricks internal use>
        """
        return pulumi.get(self, "default_tags")

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> pulumi.Output[Optional['outputs.ClusterDockerImage']]:
        return pulumi.get(self, "docker_image")

    @property
    @pulumi.getter(name="driverInstancePoolId")
    def driver_instance_pool_id(self) -> pulumi.Output[str]:
        """
        similar to `instance_pool_id`, but for driver node. If omitted, and `instance_pool_id` is specified, then the driver will be allocated from that pool.
        """
        return pulumi.get(self, "driver_instance_pool_id")

    @property
    @pulumi.getter(name="driverNodeTypeId")
    def driver_node_type_id(self) -> pulumi.Output[str]:
        """
        The node type of the Spark driver. This field is optional; if unset, API will set the driver node type to the same value as `node_type_id` defined above.
        """
        return pulumi.get(self, "driver_node_type_id")

    @property
    @pulumi.getter(name="enableElasticDisk")
    def enable_elastic_disk(self) -> pulumi.Output[bool]:
        """
        If you don’t want to allocate a fixed number of EBS volumes at cluster creation time, use autoscaling local storage. With autoscaling local storage, Databricks monitors the amount of free disk space available on your cluster’s Spark workers. If a worker begins to run too low on disk, Databricks automatically attaches a new EBS volume to the worker before it runs out of disk space. EBS volumes are attached up to a limit of 5 TB of total disk space per instance (including the instance’s local storage). To scale down EBS usage, make sure you have `autotermination_minutes` and `autoscale` attributes set. More documentation available at [cluster configuration page](https://docs.databricks.com/clusters/configure.html#autoscaling-local-storage-1).
        """
        return pulumi.get(self, "enable_elastic_disk")

    @property
    @pulumi.getter(name="enableLocalDiskEncryption")
    def enable_local_disk_encryption(self) -> pulumi.Output[bool]:
        """
        Some instance types you use to run clusters may have locally attached disks. Databricks may store shuffle data or temporary data on these locally attached disks. To ensure that all data at rest is encrypted for all storage types, including shuffle data stored temporarily on your cluster’s local disks, you can enable local disk encryption. When local disk encryption is enabled, Databricks generates an encryption key locally unique to each cluster node and uses it to encrypt all data stored on local disks. The scope of the key is local to each cluster node and is destroyed along with the cluster node itself. During its lifetime, the key resides in memory for encryption and decryption and is stored encrypted on the disk. _Your workloads may run more slowly because of the performance impact of reading and writing encrypted data to and from local volumes. This feature is not available for all Azure Databricks subscriptions. Contact your Microsoft or Databricks account representative to request access._
        """
        return pulumi.get(self, "enable_local_disk_encryption")

    @property
    @pulumi.getter(name="gcpAttributes")
    def gcp_attributes(self) -> pulumi.Output[Optional['outputs.ClusterGcpAttributes']]:
        return pulumi.get(self, "gcp_attributes")

    @property
    @pulumi.getter(name="idempotencyToken")
    def idempotency_token(self) -> pulumi.Output[Optional[str]]:
        """
        An optional token to guarantee the idempotency of cluster creation requests. If an active cluster with the provided token already exists, the request will not create a new cluster, but it will return the existing running cluster's ID instead. If you specify the idempotency token, upon failure, you can retry until the request succeeds. Databricks platform guarantees to launch exactly one cluster with that idempotency token. This token should have at most 64 characters.
        """
        return pulumi.get(self, "idempotency_token")

    @property
    @pulumi.getter(name="initScripts")
    def init_scripts(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterInitScript']]]:
        return pulumi.get(self, "init_scripts")

    @property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> pulumi.Output[Optional[str]]:
        """
        - To reduce cluster start time, you can attach a cluster to a predefined pool of idle instances. When attached to a pool, a cluster allocates its driver and worker nodes from the pool. If the pool does not have sufficient idle resources to accommodate the cluster’s request, it expands by allocating new instances from the instance provider. When an attached cluster changes its state to `TERMINATED`, the instances it used are returned to the pool and reused by a different cluster.
        """
        return pulumi.get(self, "instance_pool_id")

    @property
    @pulumi.getter(name="isPinned")
    def is_pinned(self) -> pulumi.Output[Optional[bool]]:
        """
        boolean value specifying if the cluster is pinned (not pinned by default). You must be a Databricks administrator to use this.  The pinned clusters' maximum number is [limited to 70](https://docs.databricks.com/clusters/clusters-manage.html#pin-a-cluster), so `apply` may fail if you have more than that.
        """
        return pulumi.get(self, "is_pinned")

    @property
    @pulumi.getter
    def libraries(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterLibrary']]]:
        return pulumi.get(self, "libraries")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> pulumi.Output[str]:
        """
        Any supported get_node_type id. If `instance_pool_id` is specified, this field is not needed.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "num_workers")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of Cluster Policy to validate cluster and preset certain defaults. *The primary use for cluster policies is to allow users to create policy-scoped clusters via UI rather than sharing configuration for API-created clusters.* For example, when you specify `policy_id` of [external metastore](https://docs.databricks.com/administration-guide/clusters/policies.html#external-metastore-policy) policy, you still have to fill in relevant keys for `spark_conf`.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="singleUserName")
    def single_user_name(self) -> pulumi.Output[Optional[str]]:
        """
        The optional user name of the user to assign to an interactive cluster. This field is required when using standard AAD Passthrough for Azure Data Lake Storage (ADLS) with a single-user cluster (i.e., not high-concurrency clusters).
        """
        return pulumi.get(self, "single_user_name")

    @property
    @pulumi.getter(name="sparkConf")
    def spark_conf(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Map with key-value pairs to fine-tune Spark clusters, where you can provide custom [Spark configuration properties](https://spark.apache.org/docs/latest/configuration.html) in a cluster configuration.
        """
        return pulumi.get(self, "spark_conf")

    @property
    @pulumi.getter(name="sparkEnvVars")
    def spark_env_vars(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Map with environment variable key-value pairs to fine-tune Spark clusters. Key-value pairs of the form (X,Y) are exported (i.e., X='Y') while launching the driver and workers.
        """
        return pulumi.get(self, "spark_env_vars")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> pulumi.Output[str]:
        """
        [Runtime version](https://docs.databricks.com/runtime/index.html) of the cluster. Any supported get_spark_version id.  We advise using Cluster Policies to restrict the list of versions for simplicity while maintaining enough control.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        SSH public key contents that will be added to each Spark node in this cluster. The corresponding private keys can be used to login with the user name ubuntu on port 2200. You can specify up to 10 keys.
        """
        return pulumi.get(self, "ssh_public_keys")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (string) State of the cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> pulumi.Output[Optional['outputs.ClusterWorkloadType']]:
        return pulumi.get(self, "workload_type")

