# -*- coding: utf-8 -*-
############################################################
#
# Autogenerated by the KBase type compiler -
# any changes made here will be overwritten
#
############################################################

from __future__ import print_function

# the following is a hack to get the baseclient to import whether we're in a
# package or not. This makes pep8 unhappy hence the annotations.
try:
    # baseclient and this client are in a package
    from cobrakbase.Workspace.baseclient import (
        BaseClient as _BaseClient,
    )  # @UnusedImport
except ImportError:
    # no they aren't
    from baseclient import BaseClient as _BaseClient  # @Reimport


class AbstractHandle(object):
    def __init__(
        self,
        url=None,
        timeout=30 * 60,
        user_id=None,
        password=None,
        token=None,
        ignore_authrc=False,
        trust_all_ssl_certificates=False,
        auth_svc="https://ci.kbase.us/services/auth/api/legacy/KBase/Sessions/Login",
    ):
        if url is None:
            raise ValueError("A url is required")
        self._service_ver = None
        self._client = _BaseClient(
            url,
            timeout=timeout,
            user_id=user_id,
            password=password,
            token=token,
            ignore_authrc=ignore_authrc,
            trust_all_ssl_certificates=trust_all_ssl_certificates,
            auth_svc=auth_svc,
        )

    def persist_handle(self, handle, context=None):
        """
        The persist_handle writes the handle to a persistent store that can be later retrieved using the list_handles function.
        :param handle: instance of type "Handle" -> structure: parameter
           "hid" of type "HandleId" (Handle provides a unique reference that
           enables access to the data files through functions provided as
           part of the HandleService. In the case of using shock, the id is
           the node id. In the case of using shock the value of type is
           shock. In the future these values should enumerated. The value of
           url is the http address of the shock server, including the
           protocol (http or https) and if necessary the port. The values of
           remote_md5 and remote_sha1 are those computed on the file in the
           remote data store. These can be used to verify uploads and
           downloads.), parameter "file_name" of String, parameter "id" of
           type "NodeId", parameter "type" of String, parameter "url" of
           String, parameter "remote_md5" of String, parameter "remote_sha1"
           of String
        :returns: instance of String
        """
        return self._client.call_method(
            "AbstractHandle.persist_handle", [handle], self._service_ver, context
        )

    def hids_to_handles(self, hids, context=None):
        """
        Given a list of handle ids, this function returns a list of handles.
        This method is replaced by fetch_handles_by.
        :param hids: instance of list of type "HandleId" (Handle provides a
           unique reference that enables access to the data files through
           functions provided as part of the HandleService. In the case of
           using shock, the id is the node id. In the case of using shock the
           value of type is shock. In the future these values should
           enumerated. The value of url is the http address of the shock
           server, including the protocol (http or https) and if necessary
           the port. The values of remote_md5 and remote_sha1 are those
           computed on the file in the remote data store. These can be used
           to verify uploads and downloads.)
        :returns: instance of list of type "Handle" -> structure: parameter
           "hid" of type "HandleId" (Handle provides a unique reference that
           enables access to the data files through functions provided as
           part of the HandleService. In the case of using shock, the id is
           the node id. In the case of using shock the value of type is
           shock. In the future these values should enumerated. The value of
           url is the http address of the shock server, including the
           protocol (http or https) and if necessary the port. The values of
           remote_md5 and remote_sha1 are those computed on the file in the
           remote data store. These can be used to verify uploads and
           downloads.), parameter "file_name" of String, parameter "id" of
           type "NodeId", parameter "type" of String, parameter "url" of
           String, parameter "remote_md5" of String, parameter "remote_sha1"
           of String
        """
        return self._client.call_method(
            "AbstractHandle.hids_to_handles", [hids], self._service_ver, context
        )

    def ids_to_handles(self, ids, context=None):
        """
        Given a list of ids, this function returns a list of handles.
        In case of Shock, the list of ids are shock node ids.
        This method is replaced by fetch_handles_by.
        :param ids: instance of list of type "NodeId"
        :returns: instance of list of type "Handle" -> structure: parameter
           "hid" of type "HandleId" (Handle provides a unique reference that
           enables access to the data files through functions provided as
           part of the HandleService. In the case of using shock, the id is
           the node id. In the case of using shock the value of type is
           shock. In the future these values should enumerated. The value of
           url is the http address of the shock server, including the
           protocol (http or https) and if necessary the port. The values of
           remote_md5 and remote_sha1 are those computed on the file in the
           remote data store. These can be used to verify uploads and
           downloads.), parameter "file_name" of String, parameter "id" of
           type "NodeId", parameter "type" of String, parameter "url" of
           String, parameter "remote_md5" of String, parameter "remote_sha1"
           of String
        """
        return self._client.call_method(
            "AbstractHandle.ids_to_handles", [ids], self._service_ver, context
        )

    def fetch_handles_by(self, params, context=None):
        """
        This function select records if field column entry is in elements and returns a list of handles.
        :param params: instance of type "FetchHandlesParams" -> structure:
           parameter "elements" of list of String, parameter "field_name" of
           String
        :returns: instance of list of type "Handle" -> structure: parameter
           "hid" of type "HandleId" (Handle provides a unique reference that
           enables access to the data files through functions provided as
           part of the HandleService. In the case of using shock, the id is
           the node id. In the case of using shock the value of type is
           shock. In the future these values should enumerated. The value of
           url is the http address of the shock server, including the
           protocol (http or https) and if necessary the port. The values of
           remote_md5 and remote_sha1 are those computed on the file in the
           remote data store. These can be used to verify uploads and
           downloads.), parameter "file_name" of String, parameter "id" of
           type "NodeId", parameter "type" of String, parameter "url" of
           String, parameter "remote_md5" of String, parameter "remote_sha1"
           of String
        """
        return self._client.call_method(
            "AbstractHandle.fetch_handles_by", [params], self._service_ver, context
        )

    def is_owner(self, hids, context=None):
        """
        Given a list of handle ids, this function determines if the underlying data is owned by the caller.
        If any one of the handle ids reference unreadable data this function returns false.
        :param hids: instance of list of type "HandleId" (Handle provides a
           unique reference that enables access to the data files through
           functions provided as part of the HandleService. In the case of
           using shock, the id is the node id. In the case of using shock the
           value of type is shock. In the future these values should
           enumerated. The value of url is the http address of the shock
           server, including the protocol (http or https) and if necessary
           the port. The values of remote_md5 and remote_sha1 are those
           computed on the file in the remote data store. These can be used
           to verify uploads and downloads.)
        :returns: instance of Long
        """
        return self._client.call_method(
            "AbstractHandle.is_owner", [hids], self._service_ver, context
        )

    def delete_handles(self, handles, context=None):
        """
        The delete_handles function takes a list of handles and deletes them on the handle service server.
        :param handles: instance of list of type "Handle" -> structure:
           parameter "hid" of type "HandleId" (Handle provides a unique
           reference that enables access to the data files through functions
           provided as part of the HandleService. In the case of using shock,
           the id is the node id. In the case of using shock the value of
           type is shock. In the future these values should enumerated. The
           value of url is the http address of the shock server, including
           the protocol (http or https) and if necessary the port. The values
           of remote_md5 and remote_sha1 are those computed on the file in
           the remote data store. These can be used to verify uploads and
           downloads.), parameter "file_name" of String, parameter "id" of
           type "NodeId", parameter "type" of String, parameter "url" of
           String, parameter "remote_md5" of String, parameter "remote_sha1"
           of String
        :returns: instance of Long
        """
        return self._client.call_method(
            "AbstractHandle.delete_handles", [handles], self._service_ver, context
        )

    def are_readable(self, hids, context=None):
        """
        Given a list of handle ids, this function determines if the underlying data is readable by the caller.
        If any one of the handle ids reference unreadable data this function returns false.
        :param hids: instance of list of type "HandleId" (Handle provides a
           unique reference that enables access to the data files through
           functions provided as part of the HandleService. In the case of
           using shock, the id is the node id. In the case of using shock the
           value of type is shock. In the future these values should
           enumerated. The value of url is the http address of the shock
           server, including the protocol (http or https) and if necessary
           the port. The values of remote_md5 and remote_sha1 are those
           computed on the file in the remote data store. These can be used
           to verify uploads and downloads.)
        :returns: instance of Long
        """
        return self._client.call_method(
            "AbstractHandle.are_readable", [hids], self._service_ver, context
        )

    def is_readable(self, hid, context=None):
        """
        Given a handle id, this function queries the underlying data store to see if the data being referred to is readable to by the caller.
        :param hid: instance of type "HandleId" (Handle provides a unique
           reference that enables access to the data files through functions
           provided as part of the HandleService. In the case of using shock,
           the id is the node id. In the case of using shock the value of
           type is shock. In the future these values should enumerated. The
           value of url is the http address of the shock server, including
           the protocol (http or https) and if necessary the port. The values
           of remote_md5 and remote_sha1 are those computed on the file in
           the remote data store. These can be used to verify uploads and
           downloads.)
        :returns: instance of Long
        """
        return self._client.call_method(
            "AbstractHandle.is_readable", [hid], self._service_ver, context
        )

    def add_read_acl(self, hids, username, context=None):
        """
        The add_read_acl function will update the acl of the shock node that the handle references.
        The function is only accessible to a specific list of users specified at startup time.
        The underlying shock node will be made readable to the user requested.
        :param hids: instance of list of type "HandleId" (Handle provides a
           unique reference that enables access to the data files through
           functions provided as part of the HandleService. In the case of
           using shock, the id is the node id. In the case of using shock the
           value of type is shock. In the future these values should
           enumerated. The value of url is the http address of the shock
           server, including the protocol (http or https) and if necessary
           the port. The values of remote_md5 and remote_sha1 are those
           computed on the file in the remote data store. These can be used
           to verify uploads and downloads.)
        :param username: instance of String
        :returns: instance of Long
        """
        return self._client.call_method(
            "AbstractHandle.add_read_acl", [hids, username], self._service_ver, context
        )

    def set_public_read(self, hids, context=None):
        """
        The set_public_read function will update the acl of the shock node that the handle references to make the node globally readable.
        The function is only accessible to a specific list of users specified at startup time.
        :param hids: instance of list of type "HandleId" (Handle provides a
           unique reference that enables access to the data files through
           functions provided as part of the HandleService. In the case of
           using shock, the id is the node id. In the case of using shock the
           value of type is shock. In the future these values should
           enumerated. The value of url is the http address of the shock
           server, including the protocol (http or https) and if necessary
           the port. The values of remote_md5 and remote_sha1 are those
           computed on the file in the remote data store. These can be used
           to verify uploads and downloads.)
        :returns: instance of Long
        """
        return self._client.call_method(
            "AbstractHandle.set_public_read", [hids], self._service_ver, context
        )

    def status(self, context=None):
        return self._client.call_method(
            "AbstractHandle.status", [], self._service_ver, context
        )
