<p align="center">
  <img src="https://dev-to-uploads.s3.amazonaws.com/uploads/articles/4trhpkkdbbzutc5ufxi9.png" width="160px">
  <h1 align="center">Masonite</h1>
</p>
<p align="center">
  <img alt="GitHub Workflow Status" src="https://img.shields.io/github/workflow/status/MasoniteFramework/masonite/Test%20Application">
  <img src="https://img.shields.io/badge/python-3.7+-blue.svg" alt="Python Version">
  <img alt="GitHub release (latest by date including pre-releases)" src="https://img.shields.io/github/v/release/MasoniteFramework/masonite?include_prereleases">
  <img src="https://img.shields.io/github/license/MasoniteFramework/masonite.svg" alt="License">
  <a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>
</p>

## About Masonite

Stop using old frameworks with just a few confusing features. Masonite is the developer focused dev tool with all the features you need for the rapid development you deserve. Masonite is perfect for beginners getting their first web app deployed or advanced developers and businesses that need to reach for the full fleet of features available. A short list of the available features are:

* Mail support for sending emails quickly.
* Queue support to speed your application up by sending jobs to run on a queue or asynchronously.
* Notifications for sending notifications to your users simply and effectively.
* Task scheduling to run your jobs on a schedule (like everyday at midnight) so you can set and forget your tasks.
* Events you can listen for to execute listeners that perform your tasks when certain events happen in your app.
* A BEAUTIFUL Active Record style ORM called Masonite ORM. Amazingness at your fingertips.
* Many more features you need which you can find in the docs!

## Learning Masonite

New to Masonite? Read the [Official Documentation](https://docs.masoniteproject.com/).
Masonite strives to have extremely clear documentation 😃. It would be wise to go through the tutorials there.
If you find any discrepencies or anything that doesn't make sense, please open an issue and we will get it cleared up!

Have questions or want to talk? Be sure to join the [Masonite Discord Community](https://discord.gg/TwKeFahmPZ)!

## Getting Started Quickly

Create and activate a virtual environment and if you have a working Python 3.7+ installation then getting started is as quick as typing

```bash
pip install masonite
project start .
python craft serve
```

## Contributing

Contributing to Masonite is simple:

- Hop on [Masonite Discord Community](https://discord.gg/TwKeFahmPZ) to ask any questions you need!
- Read the [How To Contribute](https://docs.masoniteproject.com/prologue/how-to-contribute) documentation to see ways to contribute to the project.
- Read the [Contributing Guide](https://docs.masoniteproject.com/prologue/contributing-guide) to learn how to contribute to the core source code development of the project.
- [Follow Masonite Framework on Twitter](https://twitter.com/masoniteproject) to get updates about tips and tricks, announcement and releases.

## Core Maintainers

- [Joseph Mancuso](https://github.com/josephmancuso) (Author)
- [Samuel Girardin](https://github.com/girardinsamuel)
- [Marlysson Silva](https://github.com/Marlysson)

## Sponsors

To become a sponsor head to our [GitHub Sponsors page](https://github.com/sponsors/MasoniteFramework)!

## Security Vulnerabilities

If you discover a security vulnerability within Masonite please read the [Security Policy](./SECURITY.md). All security vulnerabilities will be promptly addressed.

## License

The Masonite framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
