![tests](https://github.com/fjelltopp/ckanext-emailasusername/actions/workflows/test.yml/badge.svg)

![test coverage](https://coveralls.io/repos/fjelltopp/ckanext-emailasusername/badge.svg)


# ckanext-emailasusername

We have have found that many of our users quickly forget their CKAN username.
We have also observed several users assume they should use their email to
login.  This fails with a bad login error message, which causes some confusion.

This CKAN extension allows users to login or reset their password with either
their email address or their username. It doesn't do away with the username
but just offers the option to use email instead.

Out of the box, CKAN allows multiple accounts to be registered with the same
email address.  This causes a problem for using email to identify the user.
This extension therefore adds a validator to the registration form to stop
new accounts being created if there already exists an account with the same
email.

If multiple accounts are registered to your email, then identifying the user
by email fails - you must use your username to login/reset your password
instead. It's recommended, if feasible, to work with your userbase to phase
out multiple accounts with the same email.

# Requirements
This extension is tested with CKAN 2.9 for both python2 and python3


# Installation

To install ckanext-emailasusername:

1. Activate your CKAN virtual environment, for example::

     . /usr/lib/ckan/default/bin/activate

2. Install the ckanext-emailasusername Python package into your virtual environment::

     pip install ckanext-emailasusername

3. Add ``emailasusername`` to the ``ckan.plugins`` setting in your CKAN
   config file (by default the config file is located at
   ``/etc/ckan/default/production.ini``).

4. Configure CKAN to use the authenticator provided in this plugin. Add
   ``ckanext.emailasusername.authenticator:EmailAsUsernameAuthenticator`` to
   the ``[authenticators] plugins`` configuration in CKAN's who.ini file. In
   ckan core, thise who.ini file is stored in ``ckan/ckan/config`` and linked
   to from ``ckan/``::

       [authenticators]
       plugins =
           auth_tkt
           ckanext.emailasusername.authenticator:EmailAsUsernameAuthenticator

5. Restart CKAN. For example if you've deployed CKAN with Apache on Ubuntu::

     sudo service apache2 reload
6. Optional additional configuration:
```
# additional e-mail confirmation input in user registration form, enabled by default
ckanext.emailasusername.require_user_email_input_confirmation=True

# username autogenerated from fullname, disabled by default
ckanext.emailasusername.auto_generate_username_from_fullname=False
```



# Configuration


See step 4 of *Installation* above for essential CKAN configuration required for this plugin to work.

The plugin also offers the following configuration settings that can be set in your ``ckan.ini`` config file::

    emailasusername.search_by_username_and_email = True

Adding this parameter will allow users to search for other users by entering an email address, wherever the ``user_autocomplete`` action is called. For security reasons the entire email address is required to match the user account (otherwise the feature could be used to infer the email addresses of other users).  This may be useful, for example, when org admins are adding a new member to their org and do not know the username of the user they wish to add.

# Running the Tests

To run the tests, do::

    pytest --ckan-ini=test.ini


# Releasing a New Version of ckanext-emailasusername


ckanext-emailasusername is availabe on PyPI as https://pypi.python.org/pypi/ckanext-emailasusername.
To publish a new version to PyPI follow these steps:

1. Update the version number in the ``setup.py`` file.
   See `PEP 440 <http://legacy.python.org/dev/peps/pep-0440/#public-version-identifiers>`_
   for how to choose version numbers.

2. Create a source distribution of the new version::

     python setup.py sdist bdist_wheel

3. Upload the source distribution to PyPI::

     python -m twine upload dist/*

4. Tag the new release of the project on GitHub with the version number from
   the ``setup.py`` file. For example if the version number in ``setup.py`` is
   0.0.2 then do::

       git tag 0.0.2
       git push --tags



# With thanks...


This extension has been built by Fjelltopp with funding from UNAIDS as part of
the AIDS Data Repository project: [https://adr.unaids.org](https://adr.unaids.org)
