def c12_config(proto="memory://"):
    return {
        "data_table": "default",
        "diag_table": "default",
        "experiment_name": "default",
        "forcing": f"{proto}vcm-fv3config/data/base_forcing/v1.1/",
        "orographic_forcing": f"{proto}vcm-fv3config/data/orographic_data/v1.0",
        "initial_conditions": f"{proto}vcm-fv3config/data/initial_conditions/gfs_c12_example/v1.0",
        "namelist": {
            "amip_interp_nml": {
                "data_set": "reynolds_oi",
                "date_out_of_range": "climo",
                "interp_oi_sst": True,
                "no_anom_sst": False,
                "use_ncep_ice": False,
                "use_ncep_sst": True,
            },
            "atmos_model_nml": {
                "blocksize": 24,
                "chksum_debug": False,
                "dycore_only": False,
                "fdiag": 0.0,
                "fhmax": 1024.0,
                "fhmaxhf": -1.0,
                "fhout": 0.25,
                "fhouthf": 0.0,
            },
            "cires_ugwp_nml": {
                "knob_ugwp_azdir": [2, 4, 4, 4],
                "knob_ugwp_doaxyz": 1,
                "knob_ugwp_doheat": 1,
                "knob_ugwp_dokdis": 0,
                "knob_ugwp_effac": [1, 1, 1, 1],
                "knob_ugwp_ndx4lh": 4,
                "knob_ugwp_solver": 2,
                "knob_ugwp_source": [1, 1, 1, 0],
                "knob_ugwp_stoch": [0, 0, 0, 0],
                "knob_ugwp_version": 0,
                "knob_ugwp_wvspec": [1, 32, 32, 32],
                "launch_level": 55,
            },
            "coupler_nml": {
                "atmos_nthreads": 1,
                "calendar": "julian",
                "current_date": [2016, 8, 1, 0, 0, 0],
                "days": 0,
                "dt_atmos": 900,
                "dt_ocean": 900,
                "hours": 0,
                "memuse_verbose": True,
                "minutes": 30,
                "months": 0,
                "ncores_per_node": 32,
                "seconds": 0,
                "use_hyper_thread": True,
            },
            "diag_manager_nml": {"prepend_date": False},
            "external_ic_nml": {
                "checker_tr": False,
                "filtered_terrain": True,
                "gfs_dwinds": True,
                "levp": 64,
                "nt_checker": 0,
            },
            "fms_io_nml": {
                "checksum_required": False,
                "max_files_r": 100,
                "max_files_w": 100,
            },
            "fms_nml": {
                "clock_grain": "ROUTINE",
                "domains_stack_size": 3000000,
                "print_memory_usage": False,
            },
            "fv_core_nml": {
                "a_imp": 1.0,
                "adjust_dry_mass": False,
                "beta": 0.0,
                "consv_am": False,
                "consv_te": 1.0,
                "d2_bg": 0.0,
                "d2_bg_k1": 0.16,
                "d2_bg_k2": 0.02,
                "d4_bg": 0.15,
                "d_con": 1.0,
                "d_ext": 0.0,
                "dddmp": 0.2,
                "delt_max": 0.002,
                "dnats": 1,
                "do_sat_adj": True,
                "do_vort_damp": True,
                "dwind_2d": False,
                "external_ic": True,
                "fill": True,
                "fv_debug": False,
                "fv_sg_adj": 900,
                "gfs_phil": False,
                "hord_dp": 6,
                "hord_mt": 6,
                "hord_tm": 6,
                "hord_tr": 8,
                "hord_vt": 6,
                "hydrostatic": False,
                "io_layout": [1, 1],
                "k_split": 1,
                "ke_bg": 0.0,
                "kord_mt": 10,
                "kord_tm": -10,
                "kord_tr": 10,
                "kord_wz": 10,
                "layout": [1, 1],
                "make_nh": True,
                "mountain": False,
                "n_split": 6,
                "n_sponge": 4,
                "na_init": 1,
                "ncep_ic": False,
                "nggps_ic": True,
                "no_dycore": False,
                "nord": 2,
                "npx": 13,
                "npy": 13,
                "npz": 63,
                "ntiles": 6,
                "nudge": False,
                "nudge_qv": True,
                "nwat": 6,
                "p_fac": 0.1,
                "phys_hydrostatic": False,
                "print_freq": 3,
                "range_warn": True,
                "reset_eta": False,
                "rf_cutoff": 800.0,
                "rf_fast": False,
                "tau": 5.0,
                "use_hydro_pressure": False,
                "vtdm4": 0.06,
                "warm_start": False,
                "z_tracer": True,
            },
            "fv_grid_nml": {},
            "gfdl_cloud_microphysics_nml": {
                "c_cracw": 0.8,
                "c_paut": 0.5,
                "c_pgacs": 0.01,
                "c_psaci": 0.05,
                "ccn_l": 300.0,
                "ccn_o": 100.0,
                "const_vg": False,
                "const_vi": False,
                "const_vr": False,
                "const_vs": False,
                "de_ice": False,
                "do_qa": True,
                "do_sedi_heat": False,
                "dw_land": 0.16,
                "dw_ocean": 0.1,
                "fast_sat_adj": True,
                "fix_negative": True,
                "icloud_f": 1,
                "mono_prof": True,
                "mp_time": 450.0,
                "prog_ccn": False,
                "qi0_crt": 8e-05,
                "qi_lim": 1.0,
                "ql_gen": 0.001,
                "ql_mlt": 0.001,
                "qs0_crt": 0.001,
                "rad_graupel": True,
                "rad_rain": True,
                "rad_snow": True,
                "rh_inc": 0.3,
                "rh_inr": 0.3,
                "rh_ins": 0.3,
                "rthresh": 1e-05,
                "sedi_transport": False,
                "tau_g2v": 900.0,
                "tau_i2s": 1000.0,
                "tau_l2v": [225.0],
                "tau_v2l": 150.0,
                "use_ccn": True,
                "use_ppm": False,
                "vg_max": 12.0,
                "vi_max": 1.0,
                "vr_max": 12.0,
                "vs_max": 2.0,
                "z_slope_ice": True,
                "z_slope_liq": True,
            },
            "gfs_physics_nml": {
                "cal_pre": False,
                "cdmbgwd": [3.5, 0.25],
                "cnvcld": False,
                "cnvgwd": True,
                "debug": False,
                "dspheat": True,
                "fhcyc": 24.0,
                "fhlwr": 3600.0,
                "fhswr": 3600.0,
                "fhzero": 0.25,
                "hybedmf": True,
                "iaer": 111,
                "ialb": 1,
                "ico2": 2,
                "iems": 1,
                "imfdeepcnv": 2,
                "imfshalcnv": 2,
                "imp_physics": 11,
                "isol": 2,
                "isot": 1,
                "isubc_lw": 2,
                "isubc_sw": 2,
                "ivegsrc": 1,
                "ldiag3d": False,
                "lwhtr": True,
                "ncld": 5,
                "nst_anl": True,
                "pdfcld": False,
                "pre_rad": False,
                "prslrd0": 0.0,
                "random_clds": False,
                "redrag": True,
                "shal_cnv": True,
                "swhtr": True,
                "trans_trac": True,
                "use_ufo": True,
            },
            "interpolator_nml": {"interp_method": "conserve_great_circle"},
            "nam_stochy": {"lat_s": 96, "lon_s": 192, "ntrunc": 94},
            "namsfc": {
                "fabsl": 99999,
                "faisl": 99999,
                "faiss": 99999,
                "fnabsc": "grb/global_mxsnoalb.uariz.t1534.3072.1536.rg.grb",
                "fnacna": "",
                "fnaisc": "grb/CFSR.SEAICE.1982.2012.monthly.clim.grb",
                "fnalbc": "grb/global_snowfree_albedo.bosu.t1534.3072.1536.rg.grb",
                "fnalbc2": "grb/global_albedo4.1x1.grb",
                "fnglac": "grb/global_glacier.2x2.grb",
                "fnmskh": "grb/seaice_newland.grb",
                "fnmxic": "grb/global_maxice.2x2.grb",
                "fnslpc": "grb/global_slope.1x1.grb",
                "fnsmcc": "grb/global_soilmgldas.t1534.3072.1536.grb",
                "fnsnoa": "",
                "fnsnoc": "grb/global_snoclim.1.875.grb",
                "fnsotc": "grb/global_soiltype.statsgo.t1534.3072.1536.rg.grb",
                "fntg3c": "grb/global_tg3clim.2.6x1.5.grb",
                "fntsfa": "",
                "fntsfc": "grb/RTGSST.1982.2012.monthly.clim.grb",
                "fnvegc": "grb/global_vegfrac.0.144.decpercent.grb",
                "fnvetc": "grb/global_vegtype.igbp.t1534.3072.1536.rg.grb",
                "fnvmnc": "grb/global_shdmin.0.144x0.144.grb",
                "fnvmxc": "grb/global_shdmax.0.144x0.144.grb",
                "fnzorc": "igbp",
                "fsicl": 99999,
                "fsics": 99999,
                "fslpl": 99999,
                "fsmcl": [99999, 99999, 99999],
                "fsnol": 99999,
                "fsnos": 99999,
                "fsotl": 99999,
                "ftsfl": 99999,
                "ftsfs": 90,
                "fvetl": 99999,
                "fvmnl": 99999,
                "fvmxl": 99999,
                "ldebug": False,
            },
        },
    }
