"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const targets = require("@aws-cdk/aws-events-targets");
const event_bridge_1 = require("./event-bridge");
/**
 * Use a Lambda function as a Lambda destination.
 *
 * @stability stable
 */
class LambdaDestination {
    /**
     * @stability stable
     */
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
    }
    /**
     * Returns a destination configuration.
     *
     * @stability stable
     */
    bind(scope, fn, options) {
        // Normal Lambda destination (full invocation record)
        if (!this.options.responseOnly) {
            // deduplicated automatically
            this.fn.grantInvoke(fn);
            return {
                destination: this.fn.functionArn,
            };
        }
        // Otherwise add rule to extract the response payload and use EventBridge
        // as destination
        if (!options) { // `options` added to bind() as optionnal to avoid breaking change
            throw new Error('Options must be defined when using `responseOnly`.');
        }
        // Match invocation result of the source function (`fn`) and use it
        // to trigger the destination function (`this.fn`).
        new events.Rule(scope, options.type, {
            eventPattern: {
                detailType: [`Lambda Function Invocation Result - ${options.type}`],
                resources: [`${fn.functionArn}:$LATEST`],
                source: ['lambda'],
            },
            targets: [
                new targets.LambdaFunction(this.fn, {
                    event: events.RuleTargetInput.fromEventPath('$.detail.responsePayload'),
                }),
            ],
        });
        const destination = new event_bridge_1.EventBridgeDestination(); // Use default event bus here
        return destination.bind(scope, fn);
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-lambda-destinations.LambdaDestination", version: "1.113.0" };
//# sourceMappingURL=data:application/json;base64,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