import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultIdentityOidcOpenidConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_openid_config#id DataVaultIdentityOidcOpenidConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_openid_config#name DataVaultIdentityOidcOpenidConfig#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_openid_config#namespace DataVaultIdentityOidcOpenidConfig#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_openid_config vault_identity_oidc_openid_config}
*/
export declare class DataVaultIdentityOidcOpenidConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_identity_oidc_openid_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_openid_config vault_identity_oidc_openid_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultIdentityOidcOpenidConfigConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultIdentityOidcOpenidConfigConfig);
    get authorizationEndpoint(): string;
    get grantTypesSupported(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idTokenSigningAlgValuesSupported(): string[];
    get issuer(): string;
    get jwksUri(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get requestUriParameterSupported(): cdktf.IResolvable;
    get responseTypesSupported(): string[];
    get scopesSupported(): string[];
    get subjectTypesSupported(): string[];
    get tokenEndpoint(): string;
    get tokenEndpointAuthMethodsSupported(): string[];
    get userinfoEndpoint(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
