"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLoadBalancerEndpoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use an Application Load Balancer as a Global Accelerator Endpoint
 */
class ApplicationLoadBalancerEndpoint {
    constructor(loadBalancer, options = {}) {
        this.loadBalancer = loadBalancer;
        this.options = options;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_endpoints_ApplicationLoadBalancerEndpointOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApplicationLoadBalancerEndpoint);
            }
            throw error;
        }
        _util_1.validateWeight(options.weight);
        this.region = loadBalancer.env.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.loadBalancer.loadBalancerArn,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
exports.ApplicationLoadBalancerEndpoint = ApplicationLoadBalancerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
ApplicationLoadBalancerEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.ApplicationLoadBalancerEndpoint", version: "1.190.0" };
//# sourceMappingURL=data:application/json;base64,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