import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigtableGcPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the column family.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#column_family BigtableGcPolicy#column_family}
     *
     * @stability stable
     */
    readonly columnFamily: string;
    /**
     * The name of the Bigtable instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#instance_name BigtableGcPolicy#instance_name}
     *
     * @stability stable
     */
    readonly instanceName: string;
    /**
     * If multiple policies are set, you should choose between UNION OR INTERSECTION.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#mode BigtableGcPolicy#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#project BigtableGcPolicy#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#table BigtableGcPolicy#table}
     *
     * @stability stable
     */
    readonly table: string;
    /**
     * max_age block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#max_age BigtableGcPolicy#max_age}
     *
     * @stability stable
     */
    readonly maxAge?: BigtableGcPolicyMaxAge;
    /**
     * max_version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#max_version BigtableGcPolicy#max_version}
     *
     * @stability stable
     */
    readonly maxVersion?: BigtableGcPolicyMaxVersion[];
}
/**
 * @stability stable
 */
export interface BigtableGcPolicyMaxAge {
    /**
     * Number of days before applying GC policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#days BigtableGcPolicy#days}
     *
     * @stability stable
     */
    readonly days?: number;
    /**
     * Duration before applying GC policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#duration BigtableGcPolicy#duration}
     *
     * @stability stable
     */
    readonly duration?: string;
}
/**
 * @stability stable
 */
export declare class BigtableGcPolicyMaxAgeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number | undefined;
    /**
     * @stability stable
     */
    set days(value: number | undefined);
    /**
     * @stability stable
     */
    resetDays(): void;
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string | undefined;
    /**
     * @stability stable
     */
    set duration(value: string | undefined);
    /**
     * @stability stable
     */
    resetDuration(): void;
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigtableGcPolicyMaxVersion {
    /**
     * Number of version before applying the GC policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html#number BigtableGcPolicy#number}
     *
     * @stability stable
     */
    readonly number: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html google_bigtable_gc_policy}.
 *
 * @stability stable
 */
export declare class BigtableGcPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy.html google_bigtable_gc_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigtableGcPolicyConfig);
    private _columnFamily?;
    /**
     * @stability stable
     */
    get columnFamily(): string;
    /**
     * @stability stable
     */
    set columnFamily(value: string);
    /**
     * @stability stable
     */
    get columnFamilyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceName?;
    /**
     * @stability stable
     */
    get instanceName(): string;
    /**
     * @stability stable
     */
    set instanceName(value: string);
    /**
     * @stability stable
     */
    get instanceNameInput(): string | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string | undefined;
    /**
     * @stability stable
     */
    set mode(value: string | undefined);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _table?;
    /**
     * @stability stable
     */
    get table(): string;
    /**
     * @stability stable
     */
    set table(value: string);
    /**
     * @stability stable
     */
    get tableInput(): string | undefined;
    private _maxAge?;
    private __maxAgeOutput;
    /**
     * @stability stable
     */
    get maxAge(): BigtableGcPolicyMaxAgeOutputReference;
    /**
     * @stability stable
     */
    putMaxAge(value: BigtableGcPolicyMaxAge | undefined): void;
    /**
     * @stability stable
     */
    resetMaxAge(): void;
    /**
     * @stability stable
     */
    get maxAgeInput(): BigtableGcPolicyMaxAge | undefined;
    private _maxVersion?;
    /**
     * @stability stable
     */
    get maxVersion(): BigtableGcPolicyMaxVersion[] | undefined;
    /**
     * @stability stable
     */
    set maxVersion(value: BigtableGcPolicyMaxVersion[] | undefined);
    /**
     * @stability stable
     */
    resetMaxVersion(): void;
    /**
     * @stability stable
     */
    get maxVersionInput(): BigtableGcPolicyMaxVersion[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
