import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionInstanceGroupManagerConfig extends cdktf.TerraformMetaArguments {
    /**
     * The base instance name to use for instances in this group.
     *
     * The value must be a valid RFC1035 name. Supported characters are lowercase letters, numbers, and hyphens (-). Instances are named by appending a hyphen and a random four-character string to the base instance name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#base_instance_name ComputeRegionInstanceGroupManager#base_instance_name}
     *
     * @stability stable
     */
    readonly baseInstanceName: string;
    /**
     * An optional textual description of the instance group manager.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#description ComputeRegionInstanceGroupManager#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#distribution_policy_target_shape ComputeRegionInstanceGroupManager#distribution_policy_target_shape}
     *
     * @stability stable
     */
    readonly distributionPolicyTargetShape?: string;
    /**
     * The distribution policy for this managed instance group. You can specify one or more values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#distribution_policy_zones ComputeRegionInstanceGroupManager#distribution_policy_zones}
     *
     * @stability stable
     */
    readonly distributionPolicyZones?: string[];
    /**
     * The name of the instance group manager.
     *
     * Must be 1-63 characters long and comply with RFC1035. Supported characters include lowercase letters, numbers, and hyphens.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#name ComputeRegionInstanceGroupManager#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#project ComputeRegionInstanceGroupManager#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region where the managed instance group resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#region ComputeRegionInstanceGroupManager#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The full URL of all target pools to which new instances in the group are added.
     *
     * Updating the target pools attribute does not affect existing instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#target_pools ComputeRegionInstanceGroupManager#target_pools}
     *
     * @stability stable
     */
    readonly targetPools?: string[];
    /**
     * The target number of running instances for this managed instance group.
     *
     * This value should always be explicitly set unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#target_size ComputeRegionInstanceGroupManager#target_size}
     *
     * @stability stable
     */
    readonly targetSize?: number;
    /**
     * Whether to wait for all instances to be created/updated before returning.
     *
     * Note that if this is set to true and the operation does not succeed, Terraform will continue trying until it times out.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#wait_for_instances ComputeRegionInstanceGroupManager#wait_for_instances}
     *
     * @stability stable
     */
    readonly waitForInstances?: boolean | cdktf.IResolvable;
    /**
     * When used with wait_for_instances specifies the status to wait for.
     *
     * When STABLE is specified this resource will wait until the instances are stable before returning. When UPDATED is set, it will wait for the version target to be reached and any per instance configs to be effective as well as all instances to be stable before returning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#wait_for_instances_status ComputeRegionInstanceGroupManager#wait_for_instances_status}
     *
     * @stability stable
     */
    readonly waitForInstancesStatus?: string;
    /**
     * auto_healing_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#auto_healing_policies ComputeRegionInstanceGroupManager#auto_healing_policies}
     *
     * @stability stable
     */
    readonly autoHealingPolicies?: ComputeRegionInstanceGroupManagerAutoHealingPolicies;
    /**
     * named_port block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#named_port ComputeRegionInstanceGroupManager#named_port}
     *
     * @stability stable
     */
    readonly namedPort?: ComputeRegionInstanceGroupManagerNamedPort[];
    /**
     * stateful_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#stateful_disk ComputeRegionInstanceGroupManager#stateful_disk}
     *
     * @stability stable
     */
    readonly statefulDisk?: ComputeRegionInstanceGroupManagerStatefulDisk[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#timeouts ComputeRegionInstanceGroupManager#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionInstanceGroupManagerTimeouts;
    /**
     * update_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#update_policy ComputeRegionInstanceGroupManager#update_policy}
     *
     * @stability stable
     */
    readonly updatePolicy?: ComputeRegionInstanceGroupManagerUpdatePolicy;
    /**
     * version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#version ComputeRegionInstanceGroupManager#version}
     *
     * @stability stable
     */
    readonly version: ComputeRegionInstanceGroupManagerVersion[];
}
/**
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigs extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allEffective(): any;
}
/**
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManagerStatusStateful extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hasStatefulConfig(): any;
    /**
     * @stability stable
     */
    get perInstanceConfigs(): any;
}
/**
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManagerStatusVersionTarget extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get isReached(): any;
}
/**
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManagerStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get isStable(): any;
    /**
     * @stability stable
     */
    get stateful(): any;
    /**
     * @stability stable
     */
    get versionTarget(): any;
}
/**
 * @stability stable
 */
export interface ComputeRegionInstanceGroupManagerAutoHealingPolicies {
    /**
     * The health check resource that signals autohealing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#health_check ComputeRegionInstanceGroupManager#health_check}
     *
     * @stability stable
     */
    readonly healthCheck: string;
    /**
     * The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances.
     *
     * Between 0 and 3600.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#initial_delay_sec ComputeRegionInstanceGroupManager#initial_delay_sec}
     *
     * @stability stable
     */
    readonly initialDelaySec: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManagerAutoHealingPoliciesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _healthCheck?;
    /**
     * @stability stable
     */
    get healthCheck(): string;
    /**
     * @stability stable
     */
    set healthCheck(value: string);
    /**
     * @stability stable
     */
    get healthCheckInput(): string | undefined;
    private _initialDelaySec?;
    /**
     * @stability stable
     */
    get initialDelaySec(): number;
    /**
     * @stability stable
     */
    set initialDelaySec(value: number);
    /**
     * @stability stable
     */
    get initialDelaySecInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionInstanceGroupManagerNamedPort {
    /**
     * The name of the port.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#name ComputeRegionInstanceGroupManager#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#port ComputeRegionInstanceGroupManager#port}
     *
     * @stability stable
     */
    readonly port: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionInstanceGroupManagerStatefulDisk {
    /**
     * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
     *
     * The available options are NEVER and ON_PERMANENT_INSTANCE_DELETION. NEVER - detach the disk when the VM is deleted, but do not delete the disk. ON_PERMANENT_INSTANCE_DELETION will delete the stateful disk when the VM is permanently deleted from the instance group. The default is NEVER.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#delete_rule ComputeRegionInstanceGroupManager#delete_rule}
     *
     * @stability stable
     */
    readonly deleteRule?: string;
    /**
     * The device name of the disk to be attached.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#device_name ComputeRegionInstanceGroupManager#device_name}
     *
     * @stability stable
     */
    readonly deviceName: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionInstanceGroupManagerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#create ComputeRegionInstanceGroupManager#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#delete ComputeRegionInstanceGroupManager#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#update ComputeRegionInstanceGroupManager#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManagerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionInstanceGroupManagerUpdatePolicy {
    /**
     * The instance redistribution policy for regional managed instance groups.
     *
     * Valid values are: "PROACTIVE", "NONE". If PROACTIVE (default), the group attempts to maintain an even distribution of VM instances across zones in the region. If NONE, proactive redistribution is disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#instance_redistribution_type ComputeRegionInstanceGroupManager#instance_redistribution_type}
     *
     * @stability stable
     */
    readonly instanceRedistributionType?: string;
    /**
     * The maximum number of instances that can be created above the specified targetSize during the update process.
     *
     * Conflicts with max_surge_percent. It has to be either 0 or at least equal to the number of zones. If fixed values are used, at least one of max_unavailable_fixed or max_surge_fixed must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#max_surge_fixed ComputeRegionInstanceGroupManager#max_surge_fixed}
     *
     * @stability stable
     */
    readonly maxSurgeFixed?: number;
    /**
     * The maximum number of instances(calculated as percentage) that can be created above the specified targetSize during the update process.
     *
     * Conflicts with max_surge_fixed. Percent value is only allowed for regional managed instance groups with size at least 10.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#max_surge_percent ComputeRegionInstanceGroupManager#max_surge_percent}
     *
     * @stability stable
     */
    readonly maxSurgePercent?: number;
    /**
     * The maximum number of instances that can be unavailable during the update process.
     *
     * Conflicts with max_unavailable_percent. It has to be either 0 or at least equal to the number of zones. If fixed values are used, at least one of max_unavailable_fixed or max_surge_fixed must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#max_unavailable_fixed ComputeRegionInstanceGroupManager#max_unavailable_fixed}
     *
     * @stability stable
     */
    readonly maxUnavailableFixed?: number;
    /**
     * The maximum number of instances(calculated as percentage) that can be unavailable during the update process.
     *
     * Conflicts with max_unavailable_fixed. Percent value is only allowed for regional managed instance groups with size at least 10.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#max_unavailable_percent ComputeRegionInstanceGroupManager#max_unavailable_percent}
     *
     * @stability stable
     */
    readonly maxUnavailablePercent?: number;
    /**
     * Minimum number of seconds to wait for after a newly created instance becomes available.
     *
     * This value must be from range [0, 3600].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#min_ready_sec ComputeRegionInstanceGroupManager#min_ready_sec}
     *
     * @stability stable
     */
    readonly minReadySec?: number;
    /**
     * Minimal action to be taken on an instance.
     *
     * You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#minimal_action ComputeRegionInstanceGroupManager#minimal_action}
     *
     * @stability stable
     */
    readonly minimalAction: string;
    /**
     * The instance replacement method for regional managed instance groups.
     *
     * Valid values are: "RECREATE", "SUBSTITUTE". If SUBSTITUTE (default), the group replaces VM instances with new instances that have randomly generated names. If RECREATE, instance names are preserved.  You must also set max_unavailable_fixed or max_unavailable_percent to be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#replacement_method ComputeRegionInstanceGroupManager#replacement_method}
     *
     * @stability stable
     */
    readonly replacementMethod?: string;
    /**
     * The type of update process.
     *
     * You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#type ComputeRegionInstanceGroupManager#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManagerUpdatePolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _instanceRedistributionType?;
    /**
     * @stability stable
     */
    get instanceRedistributionType(): string | undefined;
    /**
     * @stability stable
     */
    set instanceRedistributionType(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstanceRedistributionType(): void;
    /**
     * @stability stable
     */
    get instanceRedistributionTypeInput(): string | undefined;
    private _maxSurgeFixed?;
    /**
     * @stability stable
     */
    get maxSurgeFixed(): number | undefined;
    /**
     * @stability stable
     */
    set maxSurgeFixed(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxSurgeFixed(): void;
    /**
     * @stability stable
     */
    get maxSurgeFixedInput(): number | undefined;
    private _maxSurgePercent?;
    /**
     * @stability stable
     */
    get maxSurgePercent(): number | undefined;
    /**
     * @stability stable
     */
    set maxSurgePercent(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxSurgePercent(): void;
    /**
     * @stability stable
     */
    get maxSurgePercentInput(): number | undefined;
    private _maxUnavailableFixed?;
    /**
     * @stability stable
     */
    get maxUnavailableFixed(): number | undefined;
    /**
     * @stability stable
     */
    set maxUnavailableFixed(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxUnavailableFixed(): void;
    /**
     * @stability stable
     */
    get maxUnavailableFixedInput(): number | undefined;
    private _maxUnavailablePercent?;
    /**
     * @stability stable
     */
    get maxUnavailablePercent(): number | undefined;
    /**
     * @stability stable
     */
    set maxUnavailablePercent(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxUnavailablePercent(): void;
    /**
     * @stability stable
     */
    get maxUnavailablePercentInput(): number | undefined;
    private _minReadySec?;
    /**
     * @stability stable
     */
    get minReadySec(): number | undefined;
    /**
     * @stability stable
     */
    set minReadySec(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinReadySec(): void;
    /**
     * @stability stable
     */
    get minReadySecInput(): number | undefined;
    private _minimalAction?;
    /**
     * @stability stable
     */
    get minimalAction(): string;
    /**
     * @stability stable
     */
    set minimalAction(value: string);
    /**
     * @stability stable
     */
    get minimalActionInput(): string | undefined;
    private _replacementMethod?;
    /**
     * @stability stable
     */
    get replacementMethod(): string | undefined;
    /**
     * @stability stable
     */
    set replacementMethod(value: string | undefined);
    /**
     * @stability stable
     */
    resetReplacementMethod(): void;
    /**
     * @stability stable
     */
    get replacementMethodInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionInstanceGroupManagerVersionTargetSize {
    /**
     * The number of instances which are managed for this version. Conflicts with percent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#fixed ComputeRegionInstanceGroupManager#fixed}
     *
     * @stability stable
     */
    readonly fixed?: number;
    /**
     * The number of instances (calculated as percentage) which are managed for this version.
     *
     * Conflicts with fixed. Note that when using percent, rounding will be in favor of explicitly set target_size values; a managed instance group with 2 instances and 2 versions, one of which has a target_size.percent of 60 will create 2 instances of that version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#percent ComputeRegionInstanceGroupManager#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManagerVersionTargetSizeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _fixed?;
    /**
     * @stability stable
     */
    get fixed(): number | undefined;
    /**
     * @stability stable
     */
    set fixed(value: number | undefined);
    /**
     * @stability stable
     */
    resetFixed(): void;
    /**
     * @stability stable
     */
    get fixedInput(): number | undefined;
    private _percent?;
    /**
     * @stability stable
     */
    get percent(): number | undefined;
    /**
     * @stability stable
     */
    set percent(value: number | undefined);
    /**
     * @stability stable
     */
    resetPercent(): void;
    /**
     * @stability stable
     */
    get percentInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionInstanceGroupManagerVersion {
    /**
     * The full URL to an instance template from which all new instances of this version will be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#instance_template ComputeRegionInstanceGroupManager#instance_template}
     *
     * @stability stable
     */
    readonly instanceTemplate: string;
    /**
     * Version name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#name ComputeRegionInstanceGroupManager#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * target_size block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html#target_size ComputeRegionInstanceGroupManager#target_size}
     *
     * @stability stable
     */
    readonly targetSize?: ComputeRegionInstanceGroupManagerVersionTargetSize;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html google_compute_region_instance_group_manager}.
 *
 * @stability stable
 */
export declare class ComputeRegionInstanceGroupManager extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html google_compute_region_instance_group_manager} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionInstanceGroupManagerConfig);
    private _baseInstanceName?;
    /**
     * @stability stable
     */
    get baseInstanceName(): string;
    /**
     * @stability stable
     */
    set baseInstanceName(value: string);
    /**
     * @stability stable
     */
    get baseInstanceNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _distributionPolicyTargetShape?;
    /**
     * @stability stable
     */
    get distributionPolicyTargetShape(): string | undefined;
    /**
     * @stability stable
     */
    set distributionPolicyTargetShape(value: string | undefined);
    /**
     * @stability stable
     */
    resetDistributionPolicyTargetShape(): void;
    /**
     * @stability stable
     */
    get distributionPolicyTargetShapeInput(): string | undefined;
    private _distributionPolicyZones?;
    /**
     * @stability stable
     */
    get distributionPolicyZones(): string[] | undefined;
    /**
     * @stability stable
     */
    set distributionPolicyZones(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetDistributionPolicyZones(): void;
    /**
     * @stability stable
     */
    get distributionPolicyZonesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceGroup(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    status(index: string): ComputeRegionInstanceGroupManagerStatus;
    private _targetPools?;
    /**
     * @stability stable
     */
    get targetPools(): string[] | undefined;
    /**
     * @stability stable
     */
    set targetPools(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTargetPools(): void;
    /**
     * @stability stable
     */
    get targetPoolsInput(): string[] | undefined;
    private _targetSize?;
    /**
     * @stability stable
     */
    get targetSize(): number | undefined;
    /**
     * @stability stable
     */
    set targetSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetTargetSize(): void;
    /**
     * @stability stable
     */
    get targetSizeInput(): number | undefined;
    private _waitForInstances?;
    /**
     * @stability stable
     */
    get waitForInstances(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set waitForInstances(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetWaitForInstances(): void;
    /**
     * @stability stable
     */
    get waitForInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForInstancesStatus?;
    /**
     * @stability stable
     */
    get waitForInstancesStatus(): string | undefined;
    /**
     * @stability stable
     */
    set waitForInstancesStatus(value: string | undefined);
    /**
     * @stability stable
     */
    resetWaitForInstancesStatus(): void;
    /**
     * @stability stable
     */
    get waitForInstancesStatusInput(): string | undefined;
    private _autoHealingPolicies?;
    private __autoHealingPoliciesOutput;
    /**
     * @stability stable
     */
    get autoHealingPolicies(): ComputeRegionInstanceGroupManagerAutoHealingPoliciesOutputReference;
    /**
     * @stability stable
     */
    putAutoHealingPolicies(value: ComputeRegionInstanceGroupManagerAutoHealingPolicies | undefined): void;
    /**
     * @stability stable
     */
    resetAutoHealingPolicies(): void;
    /**
     * @stability stable
     */
    get autoHealingPoliciesInput(): ComputeRegionInstanceGroupManagerAutoHealingPolicies | undefined;
    private _namedPort?;
    /**
     * @stability stable
     */
    get namedPort(): ComputeRegionInstanceGroupManagerNamedPort[] | undefined;
    /**
     * @stability stable
     */
    set namedPort(value: ComputeRegionInstanceGroupManagerNamedPort[] | undefined);
    /**
     * @stability stable
     */
    resetNamedPort(): void;
    /**
     * @stability stable
     */
    get namedPortInput(): ComputeRegionInstanceGroupManagerNamedPort[] | undefined;
    private _statefulDisk?;
    /**
     * @stability stable
     */
    get statefulDisk(): ComputeRegionInstanceGroupManagerStatefulDisk[] | undefined;
    /**
     * @stability stable
     */
    set statefulDisk(value: ComputeRegionInstanceGroupManagerStatefulDisk[] | undefined);
    /**
     * @stability stable
     */
    resetStatefulDisk(): void;
    /**
     * @stability stable
     */
    get statefulDiskInput(): ComputeRegionInstanceGroupManagerStatefulDisk[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionInstanceGroupManagerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRegionInstanceGroupManagerTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionInstanceGroupManagerTimeouts | undefined;
    private _updatePolicy?;
    private __updatePolicyOutput;
    /**
     * @stability stable
     */
    get updatePolicy(): ComputeRegionInstanceGroupManagerUpdatePolicyOutputReference;
    /**
     * @stability stable
     */
    putUpdatePolicy(value: ComputeRegionInstanceGroupManagerUpdatePolicy | undefined): void;
    /**
     * @stability stable
     */
    resetUpdatePolicy(): void;
    /**
     * @stability stable
     */
    get updatePolicyInput(): ComputeRegionInstanceGroupManagerUpdatePolicy | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): ComputeRegionInstanceGroupManagerVersion[];
    /**
     * @stability stable
     */
    set version(value: ComputeRegionInstanceGroupManagerVersion[]);
    /**
     * @stability stable
     */
    get versionInput(): ComputeRegionInstanceGroupManagerVersion[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
