import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeHaVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html#name DataGoogleComputeHaVpnGateway#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html#project DataGoogleComputeHaVpnGateway#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region this gateway should sit in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html#region DataGoogleComputeHaVpnGateway#region}
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeHaVpnGatewayVpnInterfaces extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): number;
    /**
     * @stability stable
     */
    get interconnectAttachment(): string;
    /**
     * @stability stable
     */
    get ipAddress(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html google_compute_ha_vpn_gateway}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeHaVpnGateway extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html google_compute_ha_vpn_gateway} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeHaVpnGatewayConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get network(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    vpnInterfaces(index: string): DataGoogleComputeHaVpnGatewayVpnInterfaces;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
