import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeSubnetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html#name DataGoogleComputeSubnetwork#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html#project DataGoogleComputeSubnetwork#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html#region DataGoogleComputeSubnetwork#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html#self_link DataGoogleComputeSubnetwork#self_link}.
     *
     * @stability stable
     */
    readonly selfLink?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeSubnetworkSecondaryIpRange extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipCidrRange(): string;
    /**
     * @stability stable
     */
    get rangeName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html google_compute_subnetwork}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeSubnetwork extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html google_compute_subnetwork} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeSubnetworkConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get gatewayAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipCidrRange(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    get privateIpGoogleAccess(): any;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    secondaryIpRange(index: string): DataGoogleComputeSubnetworkSecondaryIpRange;
    private _selfLink?;
    /**
     * @stability stable
     */
    get selfLink(): string | undefined;
    /**
     * @stability stable
     */
    set selfLink(value: string | undefined);
    /**
     * @stability stable
     */
    resetSelfLink(): void;
    /**
     * @stability stable
     */
    get selfLinkInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
