import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#constraint OrganizationPolicy#constraint}
     *
     * @stability stable
     */
    readonly constraint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#org_id OrganizationPolicy#org_id}.
     *
     * @stability stable
     */
    readonly orgId: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#version OrganizationPolicy#version}
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#boolean_policy OrganizationPolicy#boolean_policy}
     *
     * @stability stable
     */
    readonly booleanPolicy?: OrganizationPolicyBooleanPolicy;
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#list_policy OrganizationPolicy#list_policy}
     *
     * @stability stable
     */
    readonly listPolicy?: OrganizationPolicyListPolicy;
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#restore_policy OrganizationPolicy#restore_policy}
     *
     * @stability stable
     */
    readonly restorePolicy?: OrganizationPolicyRestorePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#timeouts OrganizationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OrganizationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#enforced OrganizationPolicy#enforced}
     *
     * @stability stable
     */
    readonly enforced: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class OrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enforced?;
    /**
     * @stability stable
     */
    get enforced(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforced(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#all OrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#values OrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export declare class OrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[] | undefined;
    /**
     * @stability stable
     */
    set values(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#all OrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#values OrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export declare class OrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[] | undefined;
    /**
     * @stability stable
     */
    set values(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#inherit_from_parent OrganizationPolicy#inherit_from_parent}
     *
     * @stability stable
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#suggested_value OrganizationPolicy#suggested_value}
     *
     * @stability stable
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#allow OrganizationPolicy#allow}
     *
     * @stability stable
     */
    readonly allow?: OrganizationPolicyListPolicyAllow;
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#deny OrganizationPolicy#deny}
     *
     * @stability stable
     */
    readonly deny?: OrganizationPolicyListPolicyDeny;
}
/**
 * @stability stable
 */
export declare class OrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _inheritFromParent?;
    /**
     * @stability stable
     */
    get inheritFromParent(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set inheritFromParent(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInheritFromParent(): void;
    /**
     * @stability stable
     */
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    /**
     * @stability stable
     */
    get suggestedValue(): string | undefined;
    /**
     * @stability stable
     */
    set suggestedValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetSuggestedValue(): void;
    /**
     * @stability stable
     */
    get suggestedValueInput(): string | undefined;
    private _allow?;
    private __allowOutput;
    /**
     * @stability stable
     */
    get allow(): OrganizationPolicyListPolicyAllowOutputReference;
    /**
     * @stability stable
     */
    putAllow(value: OrganizationPolicyListPolicyAllow | undefined): void;
    /**
     * @stability stable
     */
    resetAllow(): void;
    /**
     * @stability stable
     */
    get allowInput(): OrganizationPolicyListPolicyAllow | undefined;
    private _deny?;
    private __denyOutput;
    /**
     * @stability stable
     */
    get deny(): OrganizationPolicyListPolicyDenyOutputReference;
    /**
     * @stability stable
     */
    putDeny(value: OrganizationPolicyListPolicyDeny | undefined): void;
    /**
     * @stability stable
     */
    resetDeny(): void;
    /**
     * @stability stable
     */
    get denyInput(): OrganizationPolicyListPolicyDeny | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#default OrganizationPolicy#default}
     *
     * @stability stable
     */
    readonly default: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class OrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    /**
     * @stability stable
     */
    get default(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set default(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#create OrganizationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#delete OrganizationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#read OrganizationPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#update OrganizationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class OrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string | undefined;
    /**
     * @stability stable
     */
    set read(value: string | undefined);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html google_organization_policy}.
 *
 * @stability stable
 */
export declare class OrganizationPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html google_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrganizationPolicyConfig);
    private _constraint?;
    /**
     * @stability stable
     */
    get constraint(): string;
    /**
     * @stability stable
     */
    set constraint(value: string);
    /**
     * @stability stable
     */
    get constraintInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _orgId?;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    get orgIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number | undefined;
    /**
     * @stability stable
     */
    set version(value: number | undefined);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _booleanPolicy?;
    private __booleanPolicyOutput;
    /**
     * @stability stable
     */
    get booleanPolicy(): OrganizationPolicyBooleanPolicyOutputReference;
    /**
     * @stability stable
     */
    putBooleanPolicy(value: OrganizationPolicyBooleanPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetBooleanPolicy(): void;
    /**
     * @stability stable
     */
    get booleanPolicyInput(): OrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy?;
    private __listPolicyOutput;
    /**
     * @stability stable
     */
    get listPolicy(): OrganizationPolicyListPolicyOutputReference;
    /**
     * @stability stable
     */
    putListPolicy(value: OrganizationPolicyListPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetListPolicy(): void;
    /**
     * @stability stable
     */
    get listPolicyInput(): OrganizationPolicyListPolicy | undefined;
    private _restorePolicy?;
    private __restorePolicyOutput;
    /**
     * @stability stable
     */
    get restorePolicy(): OrganizationPolicyRestorePolicyOutputReference;
    /**
     * @stability stable
     */
    putRestorePolicy(value: OrganizationPolicyRestorePolicy | undefined): void;
    /**
     * @stability stable
     */
    resetRestorePolicy(): void;
    /**
     * @stability stable
     */
    get restorePolicyInput(): OrganizationPolicyRestorePolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): OrganizationPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: OrganizationPolicyTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OrganizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
