"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpOrigin = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront = require("@aws-cdk/aws-cloudfront");
/**
 * An Origin for an HTTP server or S3 bucket configured for website hosting.
 */
class HttpOrigin extends cloudfront.OriginBase {
    constructor(domainName, props = {}) {
        super(domainName, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_HttpOriginProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        validateSecondsInRangeOrUndefined('readTimeout', 1, 180, props.readTimeout);
        validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 180, props.keepaliveTimeout);
    }
    renderCustomOriginConfig() {
        var _b, _c, _d, _e;
        return {
            originSslProtocols: (_b = this.props.originSslProtocols) !== null && _b !== void 0 ? _b : [cloudfront.OriginSslPolicy.TLS_V1_2],
            originProtocolPolicy: (_c = this.props.protocolPolicy) !== null && _c !== void 0 ? _c : cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            httpPort: this.props.httpPort,
            httpsPort: this.props.httpsPort,
            originReadTimeout: (_d = this.props.readTimeout) === null || _d === void 0 ? void 0 : _d.toSeconds(),
            originKeepaliveTimeout: (_e = this.props.keepaliveTimeout) === null || _e === void 0 ? void 0 : _e.toSeconds(),
        };
    }
}
exports.HttpOrigin = HttpOrigin;
_a = JSII_RTTI_SYMBOL_1;
HttpOrigin[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.HttpOrigin", version: "1.153.0" };
/**
 * Throws an error if a duration is defined and not an integer number of seconds within a range.
 */
function validateSecondsInRangeOrUndefined(name, min, max, duration) {
    if (duration === undefined) {
        return;
    }
    const value = duration.toSeconds();
    if (!Number.isInteger(value) || value < min || value > max) {
        throw new Error(`${name}: Must be an int between ${min} and ${max} seconds (inclusive); received ${value}.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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