# coding: utf-8

"""
    FlashArray REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 2.10
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re

# python 2 and python 3 compatibility library
import six
from typing import List, Optional

from .. import models

class VirtualMachinesApi(object):

    def __init__(self, api_client):
        self.api_client = api_client

    def api210_virtual_machines_patch_with_http_info(
        self,
        virtual_machine=None,  # type: models.VirtualMachinePost
        authorization=None,  # type: str
        x_request_id=None,  # type: str
        async_req=False,  # type: bool
        _return_http_data_only=False,  # type: bool
        _preload_content=True,  # type: bool
        _request_timeout=None,  # type: Optional[int]
    ):
        # type: (...) -> models.VirtualMachineResponse
        """Modify a virtual machine

        Modifies a virtual machine, recovering it from the destroyed state. If recovering the virtual machine causes a conflict with an existing virtual machine, the operation fails.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api210_virtual_machines_patch_with_http_info(virtual_machine, async_req=True)
        >>> result = thread.get()

        :param VirtualMachinePost virtual_machine: (required)
        :param str authorization: Access token (in JWT format) required to use any API endpoint (except `/oauth2`, `/login`, and `/logout`)
        :param str x_request_id: Supplied by client during request or generated by server.
        :param bool async_req: Request runs in separate thread and method returns multiprocessing.pool.ApplyResult.
        :param bool _return_http_data_only: Returns only data field.
        :param bool _preload_content: Response is converted into objects.
        :param int _request_timeout: Total request timeout in seconds.
                 It can also be a tuple of (connection time, read time) timeouts.
        :return: VirtualMachineResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        params = {k: v for k, v in six.iteritems(locals()) if v is not None}

        # Convert the filter into a string
        if params.get('filter'):
            params['filter'] = str(params['filter'])
        if params.get('sort'):
            params['sort'] = [str(_x) for _x in params['sort']]
        # verify the required parameter 'virtual_machine' is set
        if virtual_machine is None:
            raise TypeError("Missing the required parameter `virtual_machine` when calling `api210_virtual_machines_patch`")

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']
        if 'x_request_id' in params:
            header_params['X-Request-ID'] = params['x_request_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'virtual_machine' in params:
            body_params = params['virtual_machine']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(
            ['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(
            '/api/2.10/virtual-machines', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VirtualMachineResponse',
            auth_settings=auth_settings,
            async_req=async_req,
            _return_http_data_only=_return_http_data_only,
            _preload_content=_preload_content,
            _request_timeout=_request_timeout,
            collection_formats=collection_formats,
        )

    def api210_virtual_machines_post_with_http_info(
        self,
        virtual_machine=None,  # type: models.VirtualMachinePost
        authorization=None,  # type: str
        x_request_id=None,  # type: str
        overwrite=None,  # type: bool
        async_req=False,  # type: bool
        _return_http_data_only=False,  # type: bool
        _preload_content=True,  # type: bool
        _request_timeout=None,  # type: Optional[int]
    ):
        # type: (...) -> models.VirtualMachineResponse
        """Create a virtual machine

        Creates one or more virtual machines from a protection group snapshot. If `overwrite` is specified, an existing virtual machine has its volumes overwritten by the snapshot. Otherwise, a new virtual machine is created from the snapshot. If creating the new virtual machine causes a conflict with an existing virtual machine, the operation fails.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api210_virtual_machines_post_with_http_info(virtual_machine, async_req=True)
        >>> result = thread.get()

        :param VirtualMachinePost virtual_machine: (required)
        :param str authorization: Access token (in JWT format) required to use any API endpoint (except `/oauth2`, `/login`, and `/logout`)
        :param str x_request_id: Supplied by client during request or generated by server.
        :param bool overwrite: If set to `true`, overwrites an existing volume during a volume copy operation. If set to `false` or not set at all and the target name is an existing volume, the volume copy operation fails. Required if the `source: id` or `source: name` body parameter is set and the source overwrites an existing volume during the volume copy operation.
        :param bool async_req: Request runs in separate thread and method returns multiprocessing.pool.ApplyResult.
        :param bool _return_http_data_only: Returns only data field.
        :param bool _preload_content: Response is converted into objects.
        :param int _request_timeout: Total request timeout in seconds.
                 It can also be a tuple of (connection time, read time) timeouts.
        :return: VirtualMachineResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        params = {k: v for k, v in six.iteritems(locals()) if v is not None}

        # Convert the filter into a string
        if params.get('filter'):
            params['filter'] = str(params['filter'])
        if params.get('sort'):
            params['sort'] = [str(_x) for _x in params['sort']]
        # verify the required parameter 'virtual_machine' is set
        if virtual_machine is None:
            raise TypeError("Missing the required parameter `virtual_machine` when calling `api210_virtual_machines_post`")

        collection_formats = {}
        path_params = {}

        query_params = []
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']
        if 'x_request_id' in params:
            header_params['X-Request-ID'] = params['x_request_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'virtual_machine' in params:
            body_params = params['virtual_machine']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(
            ['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(
            '/api/2.10/virtual-machines', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VirtualMachineResponse',
            auth_settings=auth_settings,
            async_req=async_req,
            _return_http_data_only=_return_http_data_only,
            _preload_content=_preload_content,
            _request_timeout=_request_timeout,
            collection_formats=collection_formats,
        )
