"""
A collection of monsters from D&D 5e's SRD

This file was autogenerated by https://github.com/stravajiaxen/5e-srd-to-py
"""

from dungeonsheets.monsters.monsters import Monster
from dungeonsheets.stats import Ability


class FireElemental(Monster):
    """
    Fire Form.
      The elemental can move through a space as narrow as 1 inch wide
      without squeezing. A creature that touches the elemental or hits it
      with a melee attack while within 5 ft. of it takes 5 (1d10) fire
      damage. In addition, the elemental can enter a hostile creature's
      space and stop there. The first time it enters a creature's space on a
      turn, that creature takes 5 (1d10) fire damage and catches fire; until
      someone takes an action to douse the fire, the creature takes 5 (1d10)
      fire damage at the start of each of its turns.
    Illumination.
      The elemental sheds bright light in a 30-foot radius and dim light in
      an additional 30 ft..
    Water Susceptibility.
      For every 5 ft. the elemental moves in water, or for every gallon of
      water splashed on it, it takes 1 cold damage.
    Multiattack.
      The elemental makes two touch attacks.
    Touch.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 10 (2d6
      + 3) fire damage. If the target is a creature or a flammable object,
      it ignites. Until a creature takes an action to douse the fire, the
      target takes 5 (1d10) fire damage at the start of each of its turns.
    """
    name = "Fire Elemental"
    description = "Large elemental, neutral"
    challenge_rating = 5
    armor_class = 13
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 10"
    languages = "Ignan"
    strength = Ability(10)
    dexterity = Ability(17)
    constitution = Ability(16)
    intelligence = Ability(6)
    wisdom = Ability(10)
    charisma = Ability(7)
    speed = 50
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 102
    hit_dice = "12d10"
    spells = []


class FireGiant(Monster):
    """
    Multiattack.
      The giant makes two greatsword attacks.
    Greatsword.
      Melee Weapon Attack: +11 to hit, reach 10 ft., one target. Hit: 28
      (6d6 + 7) slashing damage.
    Rock.
      Ranged Weapon Attack: +11 to hit, range 60/240 ft., one target. Hit:
      29 (4d10 + 7) bludgeoning damage.
    """
    name = "Fire Giant"
    description = "Huge giant, lawful evil"
    challenge_rating = 9
    armor_class = 18
    skills = "Athletics +11, Perception +6"
    senses = "Passive Perception 16"
    languages = "Giant"
    strength = Ability(25)
    dexterity = Ability(9)
    constitution = Ability(23)
    intelligence = Ability(10)
    wisdom = Ability(14)
    charisma = Ability(13)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 162
    hit_dice = "13d12"
    spells = []


class FleshGolem(Monster):
    """
    Berserk.
      Whenever the golem starts its turn with 40 hit points or fewer, roll a
      d6. On a 6, the golem goes berserk. On each of its turns while
      berserk, the golem attacks the nearest creature it can see. If no
      creature is near enough to move to and attack, the golem attacks an
      object, with preference for an object smaller than itself. Once the
      golem goes berserk, it continues to do so until it is destroyed or
      regains all its hit points.
      
      The golem's creator, if within 60 feet of the berserk golem, can try
      to calm it by speaking firmly and persuasively. The golem must be able
      to hear its creator, who must take an action to make a DC 15 Charisma
      (Persuasion) check. If the check succeeds, the golem ceases being
      berserk. If it takes damage while still at 40 hit points or fewer, the
      golem might go berserk again.
    Aversion of Fire.
      If the golem takes fire damage, it has disadvantage on attack rolls
      and ability checks until the end of its next turn.
    Immutable Form.
      The golem is immune to any spell or effect that would alter its form.
    Lightning Absorption.
      Whenever the golem is subjected to lightning damage, it takes no
      damage and instead regains a number of hit points equal to the
      lightning damage dealt.
    Magic Resistance.
      The golem has advantage on saving throws against spells and other
      magical effects.
    Magic Weapons.
      The golem's weapon attacks are magical.
    Multiattack.
      The golem makes two slam attacks.
    Slam.
      Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8
      + 4) bludgeoning damage.
    """
    name = "Flesh Golem"
    description = "Medium construct, neutral"
    challenge_rating = 5
    armor_class = 9
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 10"
    languages = "understands the languages of its creator but can't speak"
    strength = Ability(19)
    dexterity = Ability(9)
    constitution = Ability(18)
    intelligence = Ability(6)
    wisdom = Ability(10)
    charisma = Ability(5)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 93
    hit_dice = "11d8"
    spells = []


class FlyingSnake(Monster):
    """
    Flyby.
      The snake doesn't provoke opportunity attacks when it flies out of an
      enemy's reach.
    Bite.
      Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 1
      piercing damage plus 7 (3d4) poison damage.
    """
    name = "Flying Snake"
    description = "Tiny beast, unaligned"
    challenge_rating = 0.125
    armor_class = 14
    skills = ""
    senses = "Blindsight 10 ft., Passive Perception 11"
    languages = ""
    strength = Ability(4)
    dexterity = Ability(18)
    constitution = Ability(11)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(5)
    speed = 30
    swim_speed = 30
    fly_speed = 60
    climb_speed = 0
    hp_max = 5
    hit_dice = "2d4"
    spells = []


class FlyingSword(Monster):
    """
    Antimagic Susceptibility.
      The sword is incapacitated while in the area of an antimagic field. If
      targeted by dispel magic, the sword must succeed on a Constitution
      saving throw against the caster's spell save DC or fall unconscious
      for 1 minute.
    False Appearance.
      While the sword remains motionless and isn't flying, it is
      indistinguishable from a normal sword.
    Longsword.
      Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 5 (1d8 +
      1) slashing damage.
    """
    name = "Flying Sword"
    description = "Small construct, unaligned"
    challenge_rating = 0.25
    armor_class = 17
    skills = ""
    senses = "Blindsight 60 ft. (blind beyond this radius), Passive Perception 7"
    languages = ""
    strength = Ability(12)
    dexterity = Ability(15)
    constitution = Ability(11)
    intelligence = Ability(1)
    wisdom = Ability(5)
    charisma = Ability(1)
    speed = 0
    swim_speed = 0
    fly_speed = 50
    climb_speed = 0
    hp_max = 17
    hit_dice = "5d6"
    spells = []


class Frog(Monster):
    """
    Amphibious.
      The frog can breathe air and water
    Standing Leap.
      The frog's long jump is up to 10 ft. and its high jump is up to 5 ft.,
      with or without a running start.
    """
    name = "Frog"
    description = "Tiny beast, unaligned"
    challenge_rating = 0
    armor_class = 11
    skills = "Perception +1, Stealth +3"
    senses = "Darkvision 30 ft., Passive Perception 11"
    languages = ""
    strength = Ability(1)
    dexterity = Ability(13)
    constitution = Ability(8)
    intelligence = Ability(1)
    wisdom = Ability(8)
    charisma = Ability(3)
    speed = 20
    swim_speed = 20
    fly_speed = 0
    climb_speed = 0
    hp_max = 1
    hit_dice = "1d4"
    spells = []


class FrostGiant(Monster):
    """
    Multiattack.
      The giant makes two greataxe attacks.
    Greataxe.
      Melee Weapon Attack: +9 to hit, reach 10 ft., one target. Hit: 25
      (3d12 + 6) slashing damage.
    Rock.
      Ranged Weapon Attack: +9 to hit, range 60/240 ft., one target. Hit: 28
      (4d10 + 6) bludgeoning damage.
    """
    name = "Frost Giant"
    description = "Huge giant, neutral evil"
    challenge_rating = 8
    armor_class = 15
    skills = "Athletics +9, Perception +3"
    senses = "Passive Perception 13"
    languages = "Giant"
    strength = Ability(23)
    dexterity = Ability(9)
    constitution = Ability(21)
    intelligence = Ability(9)
    wisdom = Ability(10)
    charisma = Ability(12)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 138
    hit_dice = "12d12"
    spells = []
