#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['sxm_discord']

package_data = \
{'': ['*']}

install_requires = \
['discord.py[voice]',
 'discord-py-slash-command',
 'humanize',
 'sxm-player>=0.2.1',
 'pydantic',
 'tabulate']

extras_require = \
{'dev': ['bandit',
         'black',
         'discord.py-stubs',
         'flake8-bugbear',
         'flake8-builtins',
         'flake8-commas',
         'flake8-comprehensions',
         'flake8',
         'flit',
         'isort',
         'mypy',
         'pip-tools',
         'pylint',
         'pyproject-flake8',
         'rstcheck',
         'sqlalchemy-stubs',
         'types-click',
         'types-psutil',
         'types-PyYAML',
         'typing-extensions~=3.7.4.1',
         'types-tabulate'],
 'doc': ['furo', 'snooty-lextudio', 'sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-socket',
          'pytest-sugar',
          'pytest-clarity',
          'tox',
          'coverage']}

setup(name='sxm_discord',
      version='0.2.4',
      description='Top-level package for sxm-discord.',
      author='Christopher Bailey',
      author_email='cbailey@mort.is',
      url='https://github.com/AngellusMortis/sxm-discord',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.7',
     )
