# coding=utf-8
import random
from otlmow_model.BaseClasses.KeuzelijstField import KeuzelijstField
from otlmow_model.BaseClasses.KeuzelijstWaarde import KeuzelijstWaarde


# Generated with OTLEnumerationCreator. To modify: extend, do not edit
class KlEleAansluitvermogen(KeuzelijstField):
    """Keuzelijst met gangbare waarden voor elektrisch aansluitvermogen."""
    naam = 'KlEleAansluitvermogen'
    label = 'Elektrisch aansluitvermogen'
    objectUri = 'https://wegenenverkeer.data.vlaanderen.be/ns/onderdeel#KlEleAansluitvermogen'
    definition = 'Keuzelijst met gangbare waarden voor elektrisch aansluitvermogen.'
    status = 'ingebruik'
    codelist = 'https://wegenenverkeer.data.vlaanderen.be/id/conceptscheme/KlEleAansluitvermogen'
    options = {
        '16A-230Vdriefasig-6.4kVA': KeuzelijstWaarde(invulwaarde='16A-230Vdriefasig-6.4kVA',
                                                     label='16A 230Vdriefasig-6.4kVA',
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/16A-230Vdriefasig-6.4kVA'),
        '16A-230Veenfasig-3.7kVA': KeuzelijstWaarde(invulwaarde='16A-230Veenfasig-3.7kVA',
                                                    label='16A 230Veenfasig-3.7kVA',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/16A-230Veenfasig-3.7kVA'),
        '16A-400Vdriefasig-11.1kVA': KeuzelijstWaarde(invulwaarde='16A-400Vdriefasig-11.1kVA',
                                                      label='16A 400Vdriefasig-11.1kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/16A-400Vdriefasig-11.1kVA'),
        '20A-230Vdriefasig-8kVA': KeuzelijstWaarde(invulwaarde='20A-230Vdriefasig-8kVA',
                                                   label='20A 230Vdriefasig-8kVA',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/20A-230Vdriefasig-8kVA'),
        '20A-230Veenfasig-4.6kVA': KeuzelijstWaarde(invulwaarde='20A-230Veenfasig-4.6kVA',
                                                    label='20A 230Veenfasig-4.6kVA',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/20A-230Veenfasig-4.6kVA'),
        '20A-400Vdriefasig-13.9kVA': KeuzelijstWaarde(invulwaarde='20A-400Vdriefasig-13.9kVA',
                                                      label='20A 400Vdriefasig-13.9kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/20A-400Vdriefasig-13.9kVA'),
        '25A-230Vdriefasig-10kVA': KeuzelijstWaarde(invulwaarde='25A-230Vdriefasig-10kVA',
                                                    label='25A 230Vdriefasig-10kVA',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/25A-230Vdriefasig-10kVA'),
        '25A-230Veenfasig-5.8kVA': KeuzelijstWaarde(invulwaarde='25A-230Veenfasig-5.8kVA',
                                                    label='25A 230Veenfasig-5.8kVA',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/25A-230Veenfasig-5.8kVA'),
        '25A-400Vdriefasig-17.3kVA': KeuzelijstWaarde(invulwaarde='25A-400Vdriefasig-17.3kVA',
                                                      label='25A 400Vdriefasig-17.3kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/25A-400Vdriefasig-17.3kVA'),
        '32A-230Vdriefasig-12.7kVA': KeuzelijstWaarde(invulwaarde='32A-230Vdriefasig-12.7kVA',
                                                      label='32A 230Vdriefasig-12.7kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/32A-230Vdriefasig-12.7kVA'),
        '32A-230Veenfasig-7.4kVA': KeuzelijstWaarde(invulwaarde='32A-230Veenfasig-7.4kVA',
                                                    label='32A 230Veenfasig-7.4kVA',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/32A-230Veenfasig-7.4kVA'),
        '32A-400Vdriefasig-22.2kVA': KeuzelijstWaarde(invulwaarde='32A-400Vdriefasig-22.2kVA',
                                                      label='32A 400Vdriefasig-22.2kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/32A-400Vdriefasig-22.2kVA'),
        '40A-230Vdriefasig-15.9kVA': KeuzelijstWaarde(invulwaarde='40A-230Vdriefasig-15.9kVA',
                                                      label='40A 230Vdriefasig-15.9kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/40A-230Vdriefasig-15.9kVA'),
        '40A-230Veenfasig-9.2kVA': KeuzelijstWaarde(invulwaarde='40A-230Veenfasig-9.2kVA',
                                                    label='40A 230Veenfasig-9.2kVA',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/40A-230Veenfasig-9.2kVA'),
        '40A-400Vdriefasig-27.7kVA': KeuzelijstWaarde(invulwaarde='40A-400Vdriefasig-27.7kVA',
                                                      label='40A 400Vdriefasig-27.7kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/40A-400Vdriefasig-27.7kVA'),
        '50A-230Vdriefasig-19.9kVA': KeuzelijstWaarde(invulwaarde='50A-230Vdriefasig-19.9kVA',
                                                      label='50A 230Vdriefasig-19.9kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/50A-230Vdriefasig-19.9kVA'),
        '50A-230Veenfasig-11.5kVA': KeuzelijstWaarde(invulwaarde='50A-230Veenfasig-11.5kVA',
                                                     label='50A 230Veenfasig-11.5kVA',
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/50A-230Veenfasig-11.5kVA'),
        '50A-400Vdriefasig-34.6kVA': KeuzelijstWaarde(invulwaarde='50A-400Vdriefasig-34.6kVA',
                                                      label='50A 400Vdriefasig-34.6kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/50A-400Vdriefasig-34.6kVA'),
        '63A-230Vdriefasig-25.1kVA': KeuzelijstWaarde(invulwaarde='63A-230Vdriefasig-25.1kVA',
                                                      label='63A 230Vdriefasig-25.1kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/63A-230Vdriefasig-25.1kVA'),
        '63A-230Veenfasig-14.5kVA': KeuzelijstWaarde(invulwaarde='63A-230Veenfasig-14.5kVA',
                                                     label='63A 230Veenfasig-14.5kVA',
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/63A-230Veenfasig-14.5kVA'),
        '63A-400Vdriefasig-43.6kVA': KeuzelijstWaarde(invulwaarde='63A-400Vdriefasig-43.6kVA',
                                                      label='63A 400Vdriefasig-43.6kVA',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlEleAansluitvermogen/63A-400Vdriefasig-43.6kVA')
    }

    @classmethod
    def create_dummy_data(cls):
        return random.choice(list(map(lambda x: x.invulwaarde,
                                      filter(lambda option: option.status == 'ingebruik', cls.options.values()))))

