"""FluxLED Models Database."""

# Color modes
COLOR_MODE_DIM = "DIM"
COLOR_MODE_CCT = "CCT"
COLOR_MODE_RGB = "RGB"
COLOR_MODE_RGBW = "RGBW"
COLOR_MODE_RGBWW = "RGBWW"
COLOR_MODE_ADDRESSABLE = "ADDRESSABLE"

# Modes
MODE_SWITCH = "switch"
MODE_COLOR = "color"
MODE_WW = "ww"
MODE_CUSTOM = "custom"
MODE_MUSIC = "music"
MODE_PRESET = "preset"

STATIC_MODES = {MODE_COLOR, MODE_WW}

# Non light device models
MODEL_NUM_SWITCH = 0x97

COLOR_MODES_RGB = {COLOR_MODE_RGB, COLOR_MODE_RGBW, COLOR_MODE_RGBWW}
COLOR_MODES_RGB_CCT = {  # AKA Split RGB & CCT modes used for bulbs/lamps
    COLOR_MODE_RGB,
    COLOR_MODE_CCT,
}
COLOR_MODES_RGB_W = {  # AKA RGB/W in the Magic Home Pro app
    COLOR_MODE_RGB,
    COLOR_MODE_DIM,
}

DEFAULT_MODE = COLOR_MODE_RGB
