import astropy.units as apu
import numpy as np
from astropy.constants import c, h, u

one_arcsec = 1.0 / 3600.0

erg_per_eV = apu.eV.to("erg")
erg_per_keV = erg_per_eV * 1.0e3
keV_per_erg = 1.0 / erg_per_keV
eV_per_erg = 1.0 / erg_per_eV
K_per_keV = apu.keV.to("K", equivalencies=apu.temperature_energy())

hc = (h * c).to("keV*angstrom").value
clight = c.to("cm/s").value
ckms = c.to_value("km/s")

sigma_to_fwhm = 2.0 * np.sqrt(2.0 * np.log(2.0))
sqrt2pi = np.sqrt(2.0 * np.pi)

m_u = u.to("g").value

elem_names = [
    "",
    "H",
    "He",
    "Li",
    "Be",
    "B",
    "C",
    "N",
    "O",
    "F",
    "Ne",
    "Na",
    "Mg",
    "Al",
    "Si",
    "P",
    "S",
    "Cl",
    "Ar",
    "K",
    "Ca",
    "Sc",
    "Ti",
    "V",
    "Cr",
    "Mn",
    "Fe",
    "Co",
    "Ni",
    "Cu",
    "Zn",
]

cosmic_elem = [1, 2, 3, 4, 5, 9, 11, 15, 17, 19, 21, 22, 23, 24, 25, 27, 29, 30]
metal_elem = [6, 7, 8, 10, 12, 13, 14, 16, 18, 20, 26, 28]

atomic_weights = np.array(
    [
        0.0,
        1.00794,
        4.00262,
        6.941,
        9.012182,
        10.811,
        12.0107,
        14.0067,
        15.9994,
        18.9984,
        20.1797,
        22.9898,
        24.3050,
        26.9815,
        28.0855,
        30.9738,
        32.0650,
        35.4530,
        39.9480,
        39.0983,
        40.0780,
        44.9559,
        47.8670,
        50.9415,
        51.9961,
        54.9380,
        55.8450,
        58.9332,
        58.6934,
        63.5460,
        65.3800,
    ]
)

abund_tables = {
    "angr": np.array(
        [
            0.0,
            1.00e00,
            9.77e-02,
            1.45e-11,
            1.41e-11,
            3.98e-10,
            3.63e-04,
            1.12e-04,
            8.51e-04,
            3.63e-08,
            1.23e-04,
            2.14e-06,
            3.80e-05,
            2.95e-06,
            3.55e-05,
            2.82e-07,
            1.62e-05,
            3.16e-07,
            3.63e-06,
            1.32e-07,
            2.29e-06,
            1.26e-09,
            9.77e-08,
            1.00e-08,
            4.68e-07,
            2.45e-07,
            4.68e-05,
            8.32e-08,
            1.78e-06,
            1.62e-08,
            3.98e-08,
        ]
    ),
    "aspl": np.array(
        [
            0.0,
            1.00e00,
            8.51e-02,
            1.12e-11,
            2.40e-11,
            5.01e-10,
            2.69e-04,
            6.76e-05,
            4.90e-04,
            3.63e-08,
            8.51e-05,
            1.74e-06,
            3.98e-05,
            2.82e-06,
            3.24e-05,
            2.57e-07,
            1.32e-05,
            3.16e-07,
            2.51e-06,
            1.07e-07,
            2.19e-06,
            1.41e-09,
            8.91e-08,
            8.51e-09,
            4.37e-07,
            2.69e-07,
            3.16e-05,
            9.77e-08,
            1.66e-06,
            1.55e-08,
            3.63e-08,
        ]
    ),
    "wilm": np.array(
        [
            0.0,
            1.00e00,
            9.77e-02,
            0.00,
            0.00,
            0.00,
            2.40e-04,
            7.59e-05,
            4.90e-04,
            0.00,
            8.71e-05,
            1.45e-06,
            2.51e-05,
            2.14e-06,
            1.86e-05,
            2.63e-07,
            1.23e-05,
            1.32e-07,
            2.57e-06,
            0.00,
            1.58e-06,
            0.00,
            6.46e-08,
            0.00,
            3.24e-07,
            2.19e-07,
            2.69e-05,
            8.32e-08,
            1.12e-06,
            0.00,
            0.00,
        ]
    ),
    "feld": np.array(
        [
            0.0,
            1.00e00,
            9.77e-02,
            1.26e-11,
            2.51e-11,
            3.55e-10,
            3.98e-04,
            1.00e-04,
            8.51e-04,
            3.63e-08,
            1.29e-04,
            2.14e-06,
            3.80e-05,
            2.95e-06,
            3.55e-05,
            2.82e-07,
            1.62e-05,
            3.16e-07,
            4.47e-06,
            1.32e-07,
            2.29e-06,
            1.48e-09,
            1.05e-07,
            1.00e-08,
            4.68e-07,
            2.45e-07,
            3.24e-05,
            8.32e-08,
            1.78e-06,
            1.62e-08,
            3.98e-08,
        ]
    ),
    "lodd": np.array(
        [
            0.0,
            1.00e00,
            7.92e-02,
            1.90e-09,
            2.57e-11,
            6.03e-10,
            2.45e-04,
            6.76e-05,
            4.90e-04,
            2.88e-08,
            7.41e-05,
            1.99e-06,
            3.55e-05,
            2.88e-06,
            3.47e-05,
            2.88e-07,
            1.55e-05,
            1.82e-07,
            3.55e-06,
            1.29e-07,
            2.19e-06,
            1.17e-09,
            8.32e-08,
            1.00e-08,
            4.47e-07,
            3.16e-07,
            2.95e-05,
            8.13e-08,
            1.66e-06,
            1.82e-08,
            4.27e-08,
        ]
    ),
    "cl17.03": np.array(
        [
            0.0,
            1.0,
            0.1,
            2.04e-9,
            2.63e-11,
            6.17e-10,
            2.45e-4,
            8.51e-5,
            4.90e-4,
            3.02e-8,
            1.00e-4,
            2.14e-6,
            3.47e-5,
            2.95e-6,
            3.47e-5,
            3.20e-7,
            1.84e-5,
            1.91e-7,
            2.51e-6,
            1.32e-7,
            2.29e-6,
            1.48e-9,
            1.05e-7,
            1.00e-8,
            4.68e-7,
            2.88e-7,
            2.82e-5,
            8.32e-8,
            1.78e-6,
            1.62e-8,
            3.98e-8,
        ]
    ),
}
