#!/usr/bin/env python

"""Run job in parallel using PBS batch system with
   specified number of processors

   Syntax
     run_parallel_job.py 4 <prog>
"""

queue = 'normal'
walltime = '00:10:00'
vmem = '1Mb'

import sys, string, time, os
arg = sys.argv
command = arg[0]
ext = '.py'

if len(arg)<3:
    print __doc__
    print 'Usage:'
    print command + ' p <filename>' + ext
    sys.exit()

numproc = int(arg[1])    
progname = arg[2]


#Create batchfile

s = """
#!/bin/csh

# This file is automatically generated - don't edit
#

#PBS -wd  
#PBS -q %s
#PBS -l ncpus=%d
#PBS -l walltime=%s,vmem=%s
#PBS -l software=python

prun %s""" %(queue, numproc, walltime, vmem, progname)


scriptname = progname + '.run'
fid = open(scriptname, 'w')
fid.write(s)
fid.close()

#Cleanup
os.system('/bin/rm *.o* *.e*')

# Run
os.system('qsub %s' %scriptname)
os.system('/bin/rm %s' %scriptname)

#Create check scripts
fid = open('q', 'w')
fid.write("""#!/bin/csh
#This file is generated automatically.
#Any modifications will be lost.
#Edit runjob.py instead.
echo '--------------------------------------------'
nqstat %s\n""" %queue)
fid.close()

#fid = open('o', 'w')
#fid.write("""#!/bin/csh
##This file is generated automatically.
##Any modifications will be lost.
##Edit runjob.py instead.
#cat %s.e* %s.o*\n""" %((progname,)*2))
#fid.close()


fid = open('o', 'w')
fid.write("""#!/bin/csh
#This file is generated automatically.
#Any modifications will be lost.
#Edit runjob.py instead.
cat *.e* *.o*\n""")

fid.close()

os.system('chmod +x o q')









