# Generated by Django 3.2.7 on 2022-03-01 14:03

from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('simpel_core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=80, unique=True, verbose_name='Category Name')),
                ('slug', models.SlugField(blank=True, editable=False, max_length=80, null=True, unique=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, help_text='Categories, unlike tags, can have a hierarchy. You might have a Jazz category, and under that have children categories for Bebop and Big Band. Totally optional.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='simpel_core.category')),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
                'db_table': 'simpel_template_category',
                'ordering': ['name'],
                'permissions': (('import_category', 'Can import Category'), ('export_category', 'Can export Category')),
            },
        ),
        migrations.CreateModel(
            name='ModelTemplate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('thumbnail', models.ImageField(blank=True, null=True, upload_to='', verbose_name='Thumbnail')),
                ('name', models.CharField(max_length=80, verbose_name='Name')),
                ('category', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='templates', to='simpel_core.category', verbose_name='Category')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_core.modeltemplate_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'Template',
                'verbose_name_plural': 'Templates',
                'db_table': 'simpel_template',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='FileModelTemplate',
            fields=[
                ('modeltemplate_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_core.modeltemplate')),
                ('template', models.FileField(upload_to='templates', verbose_name='Template File')),
            ],
            options={
                'verbose_name': 'File Template',
                'verbose_name_plural': 'File Templates',
                'db_table': 'simpel_template_file',
            },
            bases=('simpel_core.modeltemplate',),
        ),
        migrations.CreateModel(
            name='PathModelTemplate',
            fields=[
                ('modeltemplate_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_core.modeltemplate')),
                ('template', models.CharField(max_length=80, verbose_name='Template Path')),
            ],
            options={
                'verbose_name': 'Path Template',
                'verbose_name_plural': 'Path Templates',
                'db_table': 'simpel_template_path',
            },
            bases=('simpel_core.modeltemplate',),
        ),
        migrations.CreateModel(
            name='StringModelTemplate',
            fields=[
                ('modeltemplate_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_core.modeltemplate')),
                ('template', models.TextField(verbose_name='Template String')),
            ],
            options={
                'verbose_name': 'String Template',
                'verbose_name_plural': 'String Templates',
                'db_table': 'simpel_template_string',
            },
            bases=('simpel_core.modeltemplate',),
        ),
    ]
