# Generated by Django 3.2.7 on 2022-03-04 17:33

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('code', models.CharField(max_length=255, verbose_name='Code')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='department_upline', to='simpel_employs.department', verbose_name='Upline')),
            ],
            options={
                'verbose_name': 'Department',
                'verbose_name_plural': 'Departments',
                'db_table': 'simpel_employs_department',
            },
        ),
        migrations.CreateModel(
            name='Employment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('note', models.TextField(blank=True, max_length=255, null=True, verbose_name='Note')),
            ],
            options={
                'verbose_name': 'Employment',
                'verbose_name_plural': 'Employments',
                'db_table': 'simpel_employs_employment',
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('is_manager', models.BooleanField(default=False, verbose_name='Is Manager')),
                ('is_co_manager', models.BooleanField(default=False, verbose_name='Is Co-Manager')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('employee_required', models.IntegerField(default=1, verbose_name='Employee required')),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('department', mptt.fields.TreeForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='staffs', to='simpel_employs.department', verbose_name='Department')),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='chair_upline', to='simpel_employs.position', verbose_name='Upline')),
            ],
            options={
                'verbose_name': 'Position',
                'verbose_name_plural': 'Positions',
                'db_table': 'simpel_employs_position',
            },
        ),
        migrations.CreateModel(
            name='Employee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('eid', models.CharField(max_length=255, null=True, verbose_name='Employee ID')),
                ('date_registered', models.DateField(default=django.utils.timezone.now, verbose_name='Date registered')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('employment', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='simpel_employs.employment', verbose_name='Employment')),
            ],
            options={
                'verbose_name': 'Employee',
                'verbose_name_plural': 'Employees',
                'db_table': 'simpel_employs_employee',
            },
        ),
        migrations.CreateModel(
            name='Chair',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('group', models.CharField(choices=[('struct', 'Structural'), ('func', 'Functional')], db_index=True, default='struct', max_length=6)),
                ('from_date', models.DateField(default=django.utils.timezone.now)),
                ('to_date', models.DateField(blank=True, default=django.utils.timezone.now, null=True)),
                ('active', models.BooleanField(default=True, verbose_name='Active')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='positions', to='simpel_employs.employee', verbose_name='Employee')),
                ('position', mptt.fields.TreeForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='chairmans', to='simpel_employs.position', verbose_name='Position')),
            ],
            options={
                'verbose_name': 'Chair',
                'verbose_name_plural': 'Chairs',
                'db_table': 'simpel_employs_chair',
            },
        ),
    ]
