# Generated by Django 3.2.7 on 2022-02-28 18:32

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import mptt.fields
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=80, unique=True, verbose_name='Category Name')),
                ('slug', models.SlugField(blank=True, editable=False, max_length=80, null=True, unique=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, help_text='Categories, unlike tags, can have a hierarchy. You might have a Jazz category, and under that have children categories for Bebop and Big Band. Totally optional.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='simpel_products.category')),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
                'db_table': 'simpel_product_category',
                'ordering': ['name'],
                'permissions': (('import_category', 'Can import Category'), ('export_category', 'Can export Category')),
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(default=None, max_length=3, unique=True, verbose_name='Code')),
                ('name', models.CharField(max_length=80, verbose_name='Name')),
            ],
            options={
                'verbose_name': 'Group',
                'verbose_name_plural': 'Groups',
                'db_table': 'simpel_product_group',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('uid', models.CharField(blank=True, editable=False, max_length=255, null=True, verbose_name='Unique ID')),
                ('status', models.CharField(choices=[('Available', 'Available'), ('Frozen', 'Frozen'), ('Deprecated', 'Deprecated')], default='Available', max_length=32)),
                ('name', models.CharField(db_index=True, max_length=255, verbose_name='name')),
                ('alias_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Alias name')),
                ('slug', models.SlugField(blank=True, editable=False, max_length=80, null=True, unique=True)),
                ('description', models.TextField(blank=True, max_length=1000, null=True, verbose_name='Description')),
                ('price', models.DecimalField(decimal_places=2, default=0, max_digits=15, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Price')),
                ('min_order', models.IntegerField(default=1, help_text='Minimum order quantity', verbose_name='Min Order')),
                ('max_order', models.IntegerField(default=999, help_text='Maximum order quantity', verbose_name='Max Order')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('effective_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('modified_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('is_partial', models.BooleanField(blank=True, default=None, help_text='Can be included as bundled items.', null=True, verbose_name='Partial')),
                ('is_deliverable', models.BooleanField(blank=True, default=None, help_text='Has deliverable documents.', null=True, verbose_name='Deliverable')),
                ('is_bundle', models.BooleanField(blank=True, default=None, null=True, verbose_name='Is Bundle')),
                ('is_stockable', models.BooleanField(blank=True, default=None, editable=False, null=True, verbose_name='Has stock')),
                ('is_sellable', models.BooleanField(blank=True, default=None, null=True, verbose_name='Can be Sold')),
                ('is_purchaseable', models.BooleanField(blank=True, default=None, null=True, verbose_name='Can be Purchased')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='products', to='simpel_products.category', verbose_name='Category')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='products', to='simpel_products.group', verbose_name='Group')),
                ('parent', models.ForeignKey(blank=True, help_text='Only for variants', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='variants', to='simpel_products.product', verbose_name='parent')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_products.product_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'Product',
                'verbose_name_plural': 'Products',
                'db_table': 'simpel_product',
                'ordering': ('-created_at',),
                'permissions': (('export_product', 'Can export Product'), ('import_product', 'Can import Product')),
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='name')),
                ('slug', models.SlugField(max_length=100, unique=True, verbose_name='slug')),
            ],
            options={
                'verbose_name': 'Tag',
                'verbose_name_plural': 'Tags',
                'db_table': 'simpel_product_tag',
            },
        ),
        migrations.CreateModel(
            name='Unit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('html', models.CharField(blank=True, max_length=255, null=True, verbose_name='html')),
                ('slug', models.SlugField(blank=True, editable=False, max_length=80, null=True, unique=True)),
            ],
            options={
                'verbose_name': 'Unit',
                'verbose_name_plural': 'Units',
                'db_table': 'simpel_product_unit',
                'permissions': (('import_unit', 'Can import Unit'), ('export_unit', 'Can export Unit')),
            },
        ),
        migrations.CreateModel(
            name='Asset',
            fields=[
                ('product_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_products.product')),
                ('sn', models.CharField(blank=True, max_length=150, null=True, verbose_name='Serial Number')),
                ('min_stock', models.IntegerField(default=0, help_text='Minimum stock quantity', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Min Stock')),
                ('max_stock', models.IntegerField(default=0, help_text='Minimum order quantity', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Max Stock')),
            ],
            options={
                'verbose_name': 'Asset',
                'verbose_name_plural': 'Assets',
                'db_table': 'simpel_product_asset',
                'permissions': (('export_asset', 'Can export Asset'), ('import_asset', 'Can import Asset')),
            },
            bases=('simpel_products.product', models.Model),
        ),
        migrations.CreateModel(
            name='Bundle',
            fields=[
                ('product_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Bundle',
                'verbose_name_plural': 'Bundles',
                'db_table': 'simpel_product_bundle',
                'permissions': (('export_bundle', 'Can export Bundle'), ('import_bundle', 'Can import Bundle')),
            },
            bases=('simpel_products.product',),
        ),
        migrations.CreateModel(
            name='Fee',
            fields=[
                ('product_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Fee',
                'verbose_name_plural': 'Fees',
                'db_table': 'simpel_product_fee',
                'permissions': (('export_fee', 'Can export Fee'), ('import_fee', 'Can import Fee')),
            },
            bases=('simpel_products.product',),
        ),
        migrations.CreateModel(
            name='Inventory',
            fields=[
                ('product_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_products.product')),
                ('sn', models.CharField(blank=True, max_length=150, null=True, verbose_name='Serial Number')),
                ('min_stock', models.IntegerField(default=0, help_text='Minimum stock quantity', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Min Stock')),
                ('max_stock', models.IntegerField(default=0, help_text='Minimum order quantity', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Max Stock')),
                ('display_price', models.DecimalField(decimal_places=2, default=0.0, max_digits=15)),
                ('discount', models.DecimalField(decimal_places=2, default=0.0, max_digits=15)),
            ],
            options={
                'verbose_name': 'Inventory',
                'verbose_name_plural': 'Inventories',
                'db_table': 'simpel_product_inventory',
                'permissions': (('export_inventory', 'Can export Inventory'), ('import_inventory', 'Can import Inventory')),
            },
            bases=('simpel_products.product', models.Model),
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('product_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Service',
                'verbose_name_plural': 'Services',
                'db_table': 'simpel_product_service',
                'permissions': (('export_service', 'Can export Service'), ('import_service', 'Can import Service')),
            },
            bases=('simpel_products.product',),
        ),
        migrations.CreateModel(
            name='TaggedProduct',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_object', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_products', to='simpel_products.product')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_products', to='simpel_products.tag')),
            ],
            options={
                'verbose_name': 'Tagged Product',
                'verbose_name_plural': 'Tagged Products',
                'db_table': 'simpel_product_tagged',
            },
        ),
        migrations.CreateModel(
            name='Specification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feature', models.CharField(max_length=255, verbose_name='Feature')),
                ('description', models.TextField(blank=True, max_length=255, null=True, verbose_name='Description')),
                ('value', models.CharField(max_length=255, verbose_name='Value')),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='specifications', to='simpel_products.product', verbose_name='Product')),
            ],
            options={
                'verbose_name': 'Specification',
                'verbose_name_plural': 'Specifications',
                'db_table': 'simpel_product_specification',
                'permissions': (('export_specification', 'Can export Specification'), ('import_specification', 'Can import Specification')),
            },
        ),
        migrations.AddField(
            model_name='product',
            name='tags',
            field=taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', related_name='products', through='simpel_products.TaggedProduct', to='simpel_products.Tag', verbose_name='Tags'),
        ),
        migrations.AddField(
            model_name='product',
            name='unit',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='simpel_products.unit', verbose_name='Unit'),
        ),
        migrations.CreateModel(
            name='RecommendedItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('required', models.BooleanField(default=False, help_text='Required recommended item.')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='recommended_items', to='simpel_products.product', verbose_name='product')),
                ('product', models.ForeignKey(limit_choices_to={'is_partial': True}, on_delete=django.db.models.deletion.CASCADE, related_name='recommended_for', to='simpel_products.product', verbose_name='Item')),
            ],
            options={
                'verbose_name': 'Recommendation',
                'verbose_name_plural': 'Recommendations',
                'db_table': 'simpel_product_recommended_item',
                'ordering': ('position',),
                'permissions': (('export_recommendeditem', 'Can export Recommended Item'), ('import_recommendeditem', 'Can import Recommended Item')),
                'unique_together': {('product', 'item')},
            },
        ),
        migrations.AlterIndexTogether(
            name='product',
            index_together={('name', 'category')},
        ),
        migrations.CreateModel(
            name='BundleItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Min Quantity')),
                ('required', models.BooleanField(default=False, help_text='Required bundled item.')),
                ('product', models.ForeignKey(limit_choices_to={'is_partial': True}, on_delete=django.db.models.deletion.CASCADE, related_name='bundled_with', to='simpel_products.product', verbose_name='Item')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bundle_items', to='simpel_products.bundle', verbose_name='Product')),
            ],
            options={
                'verbose_name': 'Bundle Item',
                'verbose_name_plural': 'Bundle Items',
                'db_table': 'simpel_product_bundle_item',
                'ordering': ('position',),
                'permissions': (('export_bundleitem', 'Can export Bundle Item'), ('import_bundleitem', 'Can import Bundle Item')),
                'unique_together': {('product', 'item')},
            },
        ),
    ]
