# Generated by Django 3.2.7 on 2022-02-28 18:39

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('simpel_products', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Cart',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Cart',
                'verbose_name_plural': 'Carts',
                'db_table': 'simpel_shop',
            },
        ),
        migrations.CreateModel(
            name='CartItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='name')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('note', models.TextField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('cart', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='simpel_shop.cart')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='cart_items', to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Cart Item',
                'verbose_name_plural': 'Cart Items',
                'db_table': 'simpel_shop_item',
                'ordering': ('position',),
                'index_together': {('cart', 'product')},
            },
        ),
        migrations.CreateModel(
            name='CartItemBundle',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('quantity', models.PositiveIntegerField(default=1, validators=[django.core.validators.MinValueValidator(1, message='Minimal value: 1'), django.core.validators.MaxValueValidator(500, message='Maximal value: 500')], verbose_name='Quantity')),
                ('required', models.BooleanField(default=False, editable=False, help_text='Required bundled item.')),
                ('cart_item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bundles', to='simpel_shop.cartitem')),
                ('product', models.ForeignKey(limit_choices_to={'is_partial': True}, on_delete=django.db.models.deletion.PROTECT, related_name='cart_item_bundles', to='simpel_products.product')),
            ],
            options={
                'verbose_name': 'Cart Item Bundle',
                'verbose_name_plural': 'Cart Item Bundles',
                'db_table': 'simpel_shop_item_bundle',
                'ordering': ('position',),
                'unique_together': {('cart_item', 'product')},
                'index_together': {('cart_item', 'product')},
            },
        ),
    ]
