# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['daml_dit_if', 'daml_dit_if.api', 'daml_dit_if.main']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp',
 'dacite',
 'daml-dit-api==0.4.3',
 'dazl>=7,<8',
 'idna>=2,<3',
 'pyyaml>=5,<6']

setup_kwargs = {
    'name': 'daml-dit-if',
    'version': '0.5.9',
    'description': 'Daml Hub Integration Framework',
    'long_description': 'daml-dit-if\n====\n\nAn application framework for integrations written to be hosted in\nDABL. Integrations are run within DABL itself and serve to mediate the\nrelationship between a DABL ledger and external systems. Integrations\ncan issue and receive network connections, interoperate with a ledger\nas a specific configured party, and maintain small amounts of locally\ncached data. Due to their privileged status within a DABL cluster,\nintegrations require specific permissions to install. Please contact\n[Digital Asset](https://discuss.daml.com/) for more information.\n\n# Integration Packaging\n\nIntegrations are packaged in\n[DIT files](https://github.com/digital-asset/daml-dit-api) and built\nusing the [`ddit` build tool](https://github.com/digital-asset/daml-dit-ddit).\nUnlike most DIT files, integrations are  a special case of DIT file\naugmented with the ability to run as an executable within a DABL cluster.\nThis is done by packaging Python\n[DAZL bot](https://github.com/digital-asset/dazl-client) code into an\n[executable ZIP](https://docs.python.org/3/library/zipapp.html)\nusing [PEX](https://github.com/pantsbuild/pex). This file is then\naugumented with the metadata (`dabl-meta.yaml`) and other resources\nneeded to make it a fully formed DIT file.\n\n# Developing Integrations\n\nLogically speaking, DABL integrations are DAZL bots packaged with\ninformation needed to fit them into the DABL runtime and user\ninterface. The major functional contrast between a DABL integration\nand a Python Bot is that the integration has the external network\naccess needed to connect to an outside system and the Python Bot does\nnot. Due to the security implications of running within DABL with\nexternal network access, integrations can only be deployed with the\napproval of DA staff.\n\nIt is a requirement that DABL integrations are built with the\nframework library defined within this repository. This integration\nframework presents a Python API closely related to the DAZL bot api\nand ensures that integrations follow the conventions required to run\nwithin DABL. The framework parses ledger connection arguments,\ntranslates configuration metadata into a domain object specific to the\nintegration, and exposes the appropriate health check endpoints\nrequired to populate the DABL integration user interface.\n\n## The Integration Framework API\n\nThe integration framework API has two parts - a Python entry point\nthat all integrations must provide and an additional section within\n`dabl-meta.yaml` that describes the properties of a given\nintegration. The metadata section includes the name of the entry point\nfunction for the integration, some descriptive text, and a list of\nall of the configuration arguments that the integration accepts:\n\nThe ledger event log integration is defined like this:\n\n```yaml\ncatalog:\n\n    ... elided ...\n\nintegration_types:\n\n    ... elided ...\n\n    - id: com.projectdabl.integrations.core.ledger_event_log\n      name: Ledger Event Log\n      description: >\n          Writes a log message for all ledger events.\n      entrypoint: core_int.integration_ledger_event_log:integration_ledger_event_log_main\n      env_class: core_int.integration_ledger_event_log:IntegrationLedgerEventLogEnv\n      runtime: python-direct\n      fields:\n          - id: historyBound\n            name: Transaction History Bound\n            description: >\n                Bound on the length of the history maintained by the integration\n                for the purpose of the log fetch endpoint. -1 can be used to remove\n                the bound entirely.\n            field_type: text\n            default_value: "1024"\n```\n\n* `id` - The symbolic identifier used to select the integration type within the DIT.\n* `name` - A user friendly name for the integration.\n* `description` - A description of what the integration does.\n* `entrypoint` - The package qualified name of the entrypoint function.\n* `env_class` - The package qualifies name of the environment class.\n* `runtime` - Always `python-direct`.\n* `fields` - A list of configuration fields. These are passed into the integration at runtime via correspondingly named fields of an instance of the `env_class`.\n\nThe Python definition of the entrypoint is this:\n\n\n```python\n@dataclass\nclass IntegrationLedgerEventLogEnv(IntegrationEnvironment):\n    historyBound: int\n\n\ndef integration_ledger_event_log_main(\n        env: \'IntegrationEnvironment\',\n        events: \'IntegrationEvents\'):\n\n```\n\nAt integration startup, the framework transfers control to\n`integration_ledger_event_log_main` to allow the integration to\ninitialize itself. The first argument, `env`, is a instance of\n`env_class` that contains the runtime values of the various `fields`\nthat the user has specified for the integration through the DABL\nconfiguration UI. The second argument is an instance of\n`IntegrationEvents`, that represents the bulk of the integration API.\n`IntegrationEvents` contains a number of decorators that allow the\nentrypoint function to register handlers for various types of\ninteresting events. These include various DAZL ledger events, HTTPS\nresources, timers, and internal message queues.\n\nFor compelete examples of how the framework is used and integrations\nare constructed , please see the following repositories:\n\n* [Core Pack](https://github.com/digital-asset/daml-dit-integration-core)\n* [Coindesk](https://github.com/digital-asset/daml-dit-integration-coindesk)\n* [Slack](https://github.com/digital-asset/daml-dit-integration-slack)\n* [Exberry](https://github.com/digital-asset/daml-dit-integration-exberry)\n\n## A note on logging\n\nDABL integrations use the default Python logging package, and the\nframework provides specific support for controlling log level at\nruntime. To integrate properly with this logic, it is important that\nintegrations use the `integration` logger. This logger is switched\nfrom `INFO` level to `DEBUG` level at a `DABL_LOG_LEVEL` setting of 10\nor above.\n\n```python\nimport logging\n\nLOG = logging.getLogger(\'integration\')\n```\n\n# Locally Running an integration DIT.\n\nBecause they can be directly executed by a Python interpreter,\nintegration DIT files can be run directly on a development machine\nlike any other standalone executable. By convention, integrations\naccept a number of environment variables that specify key paramaters.\nIntegrations built with the framework use defaults for these variables\nthat connect to a default locally configured sandbox instance.\n\nAvailable variables include the following:\n\n| Variable | Default | Purpose |\n|----------|---------|---------|\n| `DABL_HEALTH_PORT` | 8089 | Port for Health/Status HTTP endpoint |\n| `DABL_INTEGRATION_METADATA_PATH` | \'int_args.yaml\' | Path to local metadata file |\n| `DABL_INTEGRATION_TYPE_ID` | | Type ID for the specific integration within the DIT to run |\n| `DABL_LEDGER_PARTY` | | Party identifier for network connection |\n| `DABL_LEDGER_URL` | `http://localhost:6865` | Address of local ledger gRPC API |\n| `DABL_LOG_LEVEL` | 0 | Log verbosity level - 0 up to 50. |\n\nSeveral of these are specifically of note for local development scenarios:\n\n* `DABL_INTEGRATION_INTEGRATION_ID` - This is the ID of the\n  integration that would normally come from DABL itself. This needs to\n  be provided, but the specific value doesn\'t matter.\n* `DABL_INTEGRATION_TYPE_ID` - DIT files can contain definitions for\n  multiple types of integrations. Each integration type is described\n  in a `IntegrationTypeInfo` block in the `dabl-meta.yaml` file and\n  identified with an `id`. This ID needs to be specified with\n  `DABL_INTEGRATION_TYPE_ID`, to launch the appropriate integration\n  type within the DIT.\n* `DABL_INTEGRATION_METADATA_PATH` - Integration configuration\n  parameters specified to the integration from the console are\n  communicated to the integration at runtime via a metadata file. By\n  convention, this metadata file is named `int_args.yaml` and must be\n  located in the working directory where the integration is being run.\n* `DABL_HEALTH_PORT` - Each integration exposes health and status over\n  a `healthz` HTTP resource. <http://localhost:8089/healthz> is the\n  default, and the port can be adjusted, if necessary. (This will be\n  the case in scenarios where multiple integrations are being run\n  locally.) Inbound webhook resources defined with webhook handlers\n  will also be exposed on this HTTP endpoint.\n\n## Integration Configuration Arguments\n\nIntegrations accept their runtime configuration parameters through the\nmetadata block of a configuration YAML file. This file is distinct\nfrom `dabl_meta.yaml`, usually named `int_args.yaml` and by default\nshould be located in the working directory of the integration. A file\nand path can be explicitly specified using the\n`DABL_INTEGRATION_METADATA_PATH` environment variable.\n\nThe format of the file is a single string/string map located under the\n`metadata` key. The keys of the metadata map are the are defined by\nthe `field`s specified for the integration in the DIT file\'s\n`dabl-meta.yaml` and the values are the the configuration paramaters\nfor the integration.\n\nNote that historically, integrations have accepted their run as party\nas a metadata attribute. This is visible below under the `runAs`\nkey. However, to better align with the overall DABL automation\narchitecture, this is now deprecated and integrations must take their\nparty via the runtime environment variable `DAML_LEDGER_PARTY`.\n\n```yaml\n"metadata":\n  "interval": "1"\n  "runAs": "ledger-party-f18044e5-6157-47bd-8ba6-7641b54b87ff"\n  "targetTemplate": "9b0a268f4d5c93831e6b3b6d675a5416a8e94015c9bde7263b6ab450e10ae11b:Utility.Sequence:Sequence"\n  "templateChoice": "Sequence_Next"\n```\n',
    'author': 'Mike Schaeffer',
    'author_email': 'mike.schaeffer@digitalasset.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/digital-asset/daml-dit-integration-framework',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
