# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['people_analytics_itsm_sdk',
 'people_analytics_itsm_sdk.sdk',
 'people_analytics_itsm_sdk.sdk.servicenow',
 'people_analytics_itsm_sdk.sdk.servicenow.attachments',
 'people_analytics_itsm_sdk.sdk.servicenow.helpers',
 'people_analytics_itsm_sdk.sdk.servicenow.table']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'people-analytics-itsm-sdk',
    'version': '0.0.16',
    'description': 'People analytics itsm sdk is used to facilitate integrations and also code reuse',
    'long_description': '# people-analytics-itsm-sdk\n[![PyPI Latest Release](https://img.shields.io/pypi/v/people-analytics-itsm-sdk.svg)](https://pypi.org/project/people-analytics-itsm-sdk/)\n[![Downloads](https://pepy.tech/badge/people-analytics-itsm-sdk/month)](https://pepy.tech/project/people-analytics-itsm-sdk)\n\nInteract with various ServiceNow functionality within your python application, includes the ability to perform create, read, update, and delete (CRUD) operations on existing tables, insert data into, retrieve information from and submit tickets.\n## Installation\n```sh\n# or PyPI\npip install people-analytics-itsm-sdk\n```\n\n# Environment variables\nTo use people-analytics-itsm-sdk library, you need set four environment variables:\n```dotenv\n# ---DOTENV EXAMPLE---\nITSM_SERVICENOW_URL=https://service-now.com # base url of you servicenow server\nITSM_SERVICENOW_API_TOKEN= # servicenow auth token\nITSM_SERVICENOW_API_USER= # servicenow user\nITSM_SERVICENOW_API_PASSWORD= # servicenow user password\n\n# you can choose beetwen user and password or api token to authentication\n```\nWe recommended you to create a `.env` file in your project root to set environment variables.\n## Coding in Windows OS\nOn coding in Windows OS, you need set the environment variables before import people-analytics-itsm-sdk library\n```python\nimport os\n# set environment variables before import people-analytics-itsm-sdk library\nos.environ["ITSM_SERVICENOW_URL"] = "https://your-service-now-base-path.com"\nos.environ["ITSM_SERVICENOW_API_TOKEN"] = "Your api token"\nos.environ["ITSM_SERVICENOW_API_USER"] = "your.user.email@domain.com"\nos.environ["ITSM_SERVICENOW_API_PASSWORD"] = "your password"\n\nfrom people_analytics_itsm_sdk.sdk import Records\n```\n# Example Usage\n\n## Get data from servicenow table\nTo get data from servicenow table, we use ``Records`` class.\n```python\nfrom people_analytics_itsm_sdk.sdk import Records\n\n\n# This code get all records in one servicenow table\ntable_name = "sys_user" # replace this with table name are you need\nrecords = Records(table=table_name)\n\ntable_data = records.all() # all() method return all records\n\n```\n## Querying\nYou can apply filters and select columns in the table using ``Records().query`` method. For example:\n```python\nfrom datetime import datetime, timedelta\nfrom people_analytics_itsm_sdk.sdk import Records\n\n\ntable_name = "incident"\nrecords = Records(table=table_name)\n\n# define date interval to filter\nstart = datetime(1970, 1, 1)\nend = datetime.now() - timedelta(days=20)\n\n# query registers of incident with number started with \'INC0123\', created between 1970-01-01 and 20 days old\nrecords.query.field(\'number\').starts_with(\'INC0123\')\\\n    .AND().field(\'sys_created_on\').between(start, end)\\\n    .AND().field(\'sys_updated_on\').order_descending()\n\ndata = records.all() # return all records of query\n```\n\n## Update tables\nto create, delete and update records in a servicenow table, you can use ``Manager`` class.\n```python\nfrom people_analytics_itsm_sdk.sdk import Manager\n\n\ntable_name = "name of table you need update"\nmanager = Manager(table=table_name)\n\n# create new register in table example\nregister_to_create = {\n    "field1": "value1",\n    "field2": "value2",\n}\n\nmanager.create(data=register_to_create)\n\n# update register in table example\nregister_update_sys_id = "id of register you need update"\nregister_data_to_update = {\n    "field1": "value4"\n}\nmanager.update(sys_id=register_update_sys_id, data=register_data_to_update)\n\n# delete register in table example\nregister_delete_sys_id = "id of register you need delete"\nmanager.delete(sys_id=register_delete_sys_id)\n\n```\n\n## Submit tickets\nTo submit tickets, you can use ``ProducerServiceCatalog`` class.\n```python\nfrom people_analytics_itsm_sdk.sdk import ProducerServiceCatalog\n\n\nsurvey_catalog_id = "id of your ticket survey in servicenow catalog"\nvariables = {\n    "question1": "value1",\n    "question2": "value2"\n}\n\nproducer_catalog = ProducerServiceCatalog()\n\nresult = producer_catalog.store(catalog_id=survey_catalog_id, variables=variables)\n\n```\n# Query params\n\n### field(field)\nDefine the field to operate\n\n**parameters**: field – field (str) to operate\n\n### order_descending()\nDefine a order descending of field\n\n### order_ascending()\nDefine a order ascending of field\n\n### starts_with(starts_with)\nadds new STARTSWITH condition\n\n**parameters**: starts_with – field of correspondence starts with a value provided\n\n### ends_with(ends_with)\nadds new ENDSWITH condition\n\n**parameters**: ends_with – field of correspondence ends with a value provided\n\n### contains(contains)\nadds new LIKE condition\n\n**parameters**: contains – field of correspondence contains the value provided\n\n### not_contains(not_contains)\nadds new NOTLIKE condition\n\n**parameters**: not_contains – field of correspondence not contains the value provided\n\n### is_empty()\nadds new ISEMPTY condition\n\n### is_not_empty()\nadds new ISNOTEMPTY condition\n\n### equals(data)\nadds new IN or EQUALS condition depending on whether a list or string had provided\n\n**parameters**:\ndata – *string* or *list* of values\n\n**raise**:\nQueryTypeError: if the data provided are of an unexpected kind\n\n### not_equals(data)\nadds a new NOT IN ou EQUALS condition depending on whether a *list* or *string* had provided\n\n**parameters**:\ndata – *string* or *list* of values\n\n**raise**:\nQueryTypeError: if the data provided are of an unexpected kind\n\n### greater_than(greater_than)\nadds a new GREATER THAN condition\n\n**parameters**:\ngreater_than – object compatible with *string* or *datetime* (naive UTC datetime or tz-aware datetime)\n\n**raise**:\nQueryTypeError: if greater_than provided are of an unexpected kind\n\n### less_than(less_than)\nadds new LESS THAN condition\n\n**parameters**:\nless_than – object compatible with *string* or *datetime* (naive UTC datetime or tz-aware datetime)\n\n**raise**:\nQueryTypeError: if less_than provided are of an unexpected kind\n\n### between(start, end)\nadds a new BETWEEN condition\n\n**parameters**:\nstart – object compatible with *integer* or *datetime* (in the user\'s time zone SNOW)\nend – object compatible with *integer* or *datetime* (in the user\'s time zoneSNOW)\n\n**raise**:\nQueryTypeError: if the initial or final arguments are of an invalid type\n\n### AND()\nadds a new AND operator\n\n### OR()\nadds a new OR operator\n\n### NQ()\nadds a new NQ operator (new query)\n',
    'author': 'Stone People Analytics',
    'author_email': 'systems-techpeople@stone.com.br',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
