# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[str],
                 private_key: Optional[pulumi.Input[str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[str] certificate: should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        :param pulumi.Input[str] private_key: should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snis: a list of SNIs (alternative hosts on the certificate), under the bonnet this will create an SNI object in kong
        """
        pulumi.set(__self__, "certificate", certificate)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if snis is not None:
            pulumi.set(__self__, "snis", snis)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[str]:
        """
        should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def snis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        a list of SNIs (alternative hosts on the certificate), under the bonnet this will create an SNI object in kong
        """
        return pulumi.get(self, "snis")

    @snis.setter
    def snis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "snis", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[str] certificate: should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        :param pulumi.Input[str] private_key: should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snis: a list of SNIs (alternative hosts on the certificate), under the bonnet this will create an SNI object in kong
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if snis is not None:
            pulumi.set(__self__, "snis", snis)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def snis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        a list of SNIs (alternative hosts on the certificate), under the bonnet this will create an SNI object in kong
        """
        return pulumi.get(self, "snis")

    @snis.setter
    def snis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "snis", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## # Certificate

        For more information on creating certificates in Kong [see their documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#certificate-object)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        certificate = kong.Certificate("certificate",
            certificate="public key --- 123 ----",
            private_key="private key --- 456 ----",
            snis=[
                "foo.com",
                "bar.com",
            ])
        ```

        ## Import

        To import a certificate

        ```sh
         $ pulumi import kong:index/certificate:Certificate <certifcate_identifier> <certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        :param pulumi.Input[str] private_key: should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snis: a list of SNIs (alternative hosts on the certificate), under the bonnet this will create an SNI object in kong
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Certificate

        For more information on creating certificates in Kong [see their documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#certificate-object)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        certificate = kong.Certificate("certificate",
            certificate="public key --- 123 ----",
            private_key="private key --- 456 ----",
            snis=[
                "foo.com",
                "bar.com",
            ])
        ```

        ## Import

        To import a certificate

        ```sh
         $ pulumi import kong:index/certificate:Certificate <certifcate_identifier> <certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["snis"] = snis
        super(Certificate, __self__).__init__(
            'kong:index/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        :param pulumi.Input[str] private_key: should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snis: a list of SNIs (alternative hosts on the certificate), under the bonnet this will create an SNI object in kong
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["snis"] = snis
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        should be the public key of your certificate it is mapped to the `Cert` parameter on the Kong API.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[str]]:
        """
        should be the private key of your certificate it is mapped to the `Key` parameter on the Kong API.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def snis(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        a list of SNIs (alternative hosts on the certificate), under the bonnet this will create an SNI object in kong
        """
        return pulumi.get(self, "snis")

