# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ConsumerArgs', 'Consumer']

@pulumi.input_type
class ConsumerArgs:
    def __init__(__self__, *,
                 custom_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Consumer resource.
        :param pulumi.Input[str] custom_id: A custom id for the consumer, you must set either the username or custom_id
        :param pulumi.Input[str] username: The username to use, you must set either the username or custom_id
        """
        if custom_id is not None:
            pulumi.set(__self__, "custom_id", custom_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="customId")
    def custom_id(self) -> Optional[pulumi.Input[str]]:
        """
        A custom id for the consumer, you must set either the username or custom_id
        """
        return pulumi.get(self, "custom_id")

    @custom_id.setter
    def custom_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username to use, you must set either the username or custom_id
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _ConsumerState:
    def __init__(__self__, *,
                 custom_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Consumer resources.
        :param pulumi.Input[str] custom_id: A custom id for the consumer, you must set either the username or custom_id
        :param pulumi.Input[str] username: The username to use, you must set either the username or custom_id
        """
        if custom_id is not None:
            pulumi.set(__self__, "custom_id", custom_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="customId")
    def custom_id(self) -> Optional[pulumi.Input[str]]:
        """
        A custom id for the consumer, you must set either the username or custom_id
        """
        return pulumi.get(self, "custom_id")

    @custom_id.setter
    def custom_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username to use, you must set either the username or custom_id
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class Consumer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Consumer

        The consumer resource maps directly onto the json for creating a Consumer in Kong.  For more information on the parameters [see the Kong Consumer create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#consumer-object).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        consumer = kong.Consumer("consumer",
            custom_id="123",
            username="User1")
        ```

        ## Import

        To import a consumer

        ```sh
         $ pulumi import kong:index/consumer:Consumer <consumer_identifier> <consumer_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_id: A custom id for the consumer, you must set either the username or custom_id
        :param pulumi.Input[str] username: The username to use, you must set either the username or custom_id
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConsumerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Consumer

        The consumer resource maps directly onto the json for creating a Consumer in Kong.  For more information on the parameters [see the Kong Consumer create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#consumer-object).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        consumer = kong.Consumer("consumer",
            custom_id="123",
            username="User1")
        ```

        ## Import

        To import a consumer

        ```sh
         $ pulumi import kong:index/consumer:Consumer <consumer_identifier> <consumer_id>
        ```

        :param str resource_name: The name of the resource.
        :param ConsumerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConsumerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConsumerArgs.__new__(ConsumerArgs)

            __props__.__dict__["custom_id"] = custom_id
            __props__.__dict__["username"] = username
        super(Consumer, __self__).__init__(
            'kong:index/consumer:Consumer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'Consumer':
        """
        Get an existing Consumer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_id: A custom id for the consumer, you must set either the username or custom_id
        :param pulumi.Input[str] username: The username to use, you must set either the username or custom_id
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConsumerState.__new__(_ConsumerState)

        __props__.__dict__["custom_id"] = custom_id
        __props__.__dict__["username"] = username
        return Consumer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customId")
    def custom_id(self) -> pulumi.Output[Optional[str]]:
        """
        A custom id for the consumer, you must set either the username or custom_id
        """
        return pulumi.get(self, "custom_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        The username to use, you must set either the username or custom_id
        """
        return pulumi.get(self, "username")

