# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 protocols: pulumi.Input[Sequence[pulumi.Input[str]]],
                 service_id: pulumi.Input[str],
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_host: Optional[pulumi.Input[bool]] = None,
                 regex_priority: Optional[pulumi.Input[int]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]] = None,
                 strip_path: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The list of protocols to use
        :param pulumi.Input[str] service_id: Service ID to map to
        :param pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]] destinations: A list of destination `ip` and `port`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: A list of domain names that match this Route
        :param pulumi.Input[Sequence[pulumi.Input[str]]] methods: A list of HTTP methods that match this Route
        :param pulumi.Input[str] name: The name of the route
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: A list of paths that match this Route
        :param pulumi.Input[bool] preserve_host: When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        :param pulumi.Input[int] regex_priority: A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snis: A list of SNIs that match this Route when using stream routing.
        :param pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]] sources: A list of source `ip` and `port`
        :param pulumi.Input[bool] strip_path: When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "service_id", service_id)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if preserve_host is not None:
            pulumi.set(__self__, "preserve_host", preserve_host)
        if regex_priority is not None:
            pulumi.set(__self__, "regex_priority", regex_priority)
        if snis is not None:
            pulumi.set(__self__, "snis", snis)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if strip_path is not None:
            pulumi.set(__self__, "strip_path", strip_path)

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of protocols to use
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        Service ID to map to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]]:
        """
        A list of destination `ip` and `port`
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of domain names that match this Route
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of HTTP methods that match this Route
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "methods", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of paths that match this Route
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="preserveHost")
    def preserve_host(self) -> Optional[pulumi.Input[bool]]:
        """
        When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        """
        return pulumi.get(self, "preserve_host")

    @preserve_host.setter
    def preserve_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_host", value)

    @property
    @pulumi.getter(name="regexPriority")
    def regex_priority(self) -> Optional[pulumi.Input[int]]:
        """
        A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        """
        return pulumi.get(self, "regex_priority")

    @regex_priority.setter
    def regex_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "regex_priority", value)

    @property
    @pulumi.getter
    def snis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of SNIs that match this Route when using stream routing.
        """
        return pulumi.get(self, "snis")

    @snis.setter
    def snis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "snis", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]]:
        """
        A list of source `ip` and `port`
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="stripPath")
    def strip_path(self) -> Optional[pulumi.Input[bool]]:
        """
        When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        return pulumi.get(self, "strip_path")

    @strip_path.setter
    def strip_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_path", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_host: Optional[pulumi.Input[bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regex_priority: Optional[pulumi.Input[int]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]] = None,
                 strip_path: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]] destinations: A list of destination `ip` and `port`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: A list of domain names that match this Route
        :param pulumi.Input[Sequence[pulumi.Input[str]]] methods: A list of HTTP methods that match this Route
        :param pulumi.Input[str] name: The name of the route
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: A list of paths that match this Route
        :param pulumi.Input[bool] preserve_host: When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The list of protocols to use
        :param pulumi.Input[int] regex_priority: A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        :param pulumi.Input[str] service_id: Service ID to map to
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snis: A list of SNIs that match this Route when using stream routing.
        :param pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]] sources: A list of source `ip` and `port`
        :param pulumi.Input[bool] strip_path: When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if preserve_host is not None:
            pulumi.set(__self__, "preserve_host", preserve_host)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if regex_priority is not None:
            pulumi.set(__self__, "regex_priority", regex_priority)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if snis is not None:
            pulumi.set(__self__, "snis", snis)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if strip_path is not None:
            pulumi.set(__self__, "strip_path", strip_path)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]]:
        """
        A list of destination `ip` and `port`
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of domain names that match this Route
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of HTTP methods that match this Route
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "methods", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of paths that match this Route
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="preserveHost")
    def preserve_host(self) -> Optional[pulumi.Input[bool]]:
        """
        When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        """
        return pulumi.get(self, "preserve_host")

    @preserve_host.setter
    def preserve_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_host", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of protocols to use
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="regexPriority")
    def regex_priority(self) -> Optional[pulumi.Input[int]]:
        """
        A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        """
        return pulumi.get(self, "regex_priority")

    @regex_priority.setter
    def regex_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "regex_priority", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        Service ID to map to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def snis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of SNIs that match this Route when using stream routing.
        """
        return pulumi.get(self, "snis")

    @snis.setter
    def snis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "snis", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]]:
        """
        A list of source `ip` and `port`
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="stripPath")
    def strip_path(self) -> Optional[pulumi.Input[bool]]:
        """
        When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        return pulumi.get(self, "strip_path")

    @strip_path.setter
    def strip_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_path", value)


class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteDestinationArgs']]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_host: Optional[pulumi.Input[bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regex_priority: Optional[pulumi.Input[int]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteSourceArgs']]]]] = None,
                 strip_path: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## # Route

        The route resource maps directly onto the json for the route endpoint in Kong. For more information on the parameters [see the Kong Route create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#route-object).

        To create a tcp/tls route you set `sources` and `destinations` by repeating the corresponding element (`source` or `destination`) for each source or destination you want.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        route = kong.Route("route",
            protocols=[
                "http",
                "https",
            ],
            methods=[
                "GET",
                "POST",
            ],
            hosts=["example2.com"],
            paths=["/test"],
            strip_path=False,
            preserve_host=True,
            regex_priority=1,
            service_id=kong_service["service"]["id"])
        ```

        To create a tcp/tls route you set `sources` and `destinations` by repeating the corresponding element (`source` or `destination`) for each source or destination you want, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        route = kong.Route("route",
            protocols=["tcp"],
            strip_path=True,
            preserve_host=False,
            sources=[
                kong.RouteSourceArgs(
                    ip="192.168.1.1",
                    port=80,
                ),
                kong.RouteSourceArgs(
                    ip="192.168.1.2",
                ),
            ],
            destinations=[kong.RouteDestinationArgs(
                ip="172.10.1.1",
                port=81,
            )],
            snis=["foo.com"],
            service_id=kong_service["service"]["id"])
        ```

        ## Import

        To import a route

        ```sh
         $ pulumi import kong:index/route:Route <route_identifier> <route_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteDestinationArgs']]]] destinations: A list of destination `ip` and `port`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: A list of domain names that match this Route
        :param pulumi.Input[Sequence[pulumi.Input[str]]] methods: A list of HTTP methods that match this Route
        :param pulumi.Input[str] name: The name of the route
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: A list of paths that match this Route
        :param pulumi.Input[bool] preserve_host: When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The list of protocols to use
        :param pulumi.Input[int] regex_priority: A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        :param pulumi.Input[str] service_id: Service ID to map to
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snis: A list of SNIs that match this Route when using stream routing.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteSourceArgs']]]] sources: A list of source `ip` and `port`
        :param pulumi.Input[bool] strip_path: When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Route

        The route resource maps directly onto the json for the route endpoint in Kong. For more information on the parameters [see the Kong Route create documentation](https://docs.konghq.com/gateway-oss/2.5.x/admin-api/#route-object).

        To create a tcp/tls route you set `sources` and `destinations` by repeating the corresponding element (`source` or `destination`) for each source or destination you want.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_kong as kong

        route = kong.Route("route",
            protocols=[
                "http",
                "https",
            ],
            methods=[
                "GET",
                "POST",
            ],
            hosts=["example2.com"],
            paths=["/test"],
            strip_path=False,
            preserve_host=True,
            regex_priority=1,
            service_id=kong_service["service"]["id"])
        ```

        To create a tcp/tls route you set `sources` and `destinations` by repeating the corresponding element (`source` or `destination`) for each source or destination you want, for example:

        ```python
        import pulumi
        import pulumi_kong as kong

        route = kong.Route("route",
            protocols=["tcp"],
            strip_path=True,
            preserve_host=False,
            sources=[
                kong.RouteSourceArgs(
                    ip="192.168.1.1",
                    port=80,
                ),
                kong.RouteSourceArgs(
                    ip="192.168.1.2",
                ),
            ],
            destinations=[kong.RouteDestinationArgs(
                ip="172.10.1.1",
                port=81,
            )],
            snis=["foo.com"],
            service_id=kong_service["service"]["id"])
        ```

        ## Import

        To import a route

        ```sh
         $ pulumi import kong:index/route:Route <route_identifier> <route_id>
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteDestinationArgs']]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preserve_host: Optional[pulumi.Input[bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 regex_priority: Optional[pulumi.Input[int]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteSourceArgs']]]]] = None,
                 strip_path: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["methods"] = methods
            __props__.__dict__["name"] = name
            __props__.__dict__["paths"] = paths
            __props__.__dict__["preserve_host"] = preserve_host
            if protocols is None and not opts.urn:
                raise TypeError("Missing required property 'protocols'")
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["regex_priority"] = regex_priority
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["snis"] = snis
            __props__.__dict__["sources"] = sources
            __props__.__dict__["strip_path"] = strip_path
        super(Route, __self__).__init__(
            'kong:index/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteDestinationArgs']]]]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            preserve_host: Optional[pulumi.Input[bool]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            regex_priority: Optional[pulumi.Input[int]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            snis: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteSourceArgs']]]]] = None,
            strip_path: Optional[pulumi.Input[bool]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteDestinationArgs']]]] destinations: A list of destination `ip` and `port`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: A list of domain names that match this Route
        :param pulumi.Input[Sequence[pulumi.Input[str]]] methods: A list of HTTP methods that match this Route
        :param pulumi.Input[str] name: The name of the route
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: A list of paths that match this Route
        :param pulumi.Input[bool] preserve_host: When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The list of protocols to use
        :param pulumi.Input[int] regex_priority: A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        :param pulumi.Input[str] service_id: Service ID to map to
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snis: A list of SNIs that match this Route when using stream routing.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteSourceArgs']]]] sources: A list of source `ip` and `port`
        :param pulumi.Input[bool] strip_path: When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["methods"] = methods
        __props__.__dict__["name"] = name
        __props__.__dict__["paths"] = paths
        __props__.__dict__["preserve_host"] = preserve_host
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["regex_priority"] = regex_priority
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["snis"] = snis
        __props__.__dict__["sources"] = sources
        __props__.__dict__["strip_path"] = strip_path
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Optional[Sequence['outputs.RouteDestination']]]:
        """
        A list of destination `ip` and `port`
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of domain names that match this Route
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def methods(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of HTTP methods that match this Route
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the route
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of paths that match this Route
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="preserveHost")
    def preserve_host(self) -> pulumi.Output[Optional[bool]]:
        """
        When matching a Route via one of the hosts domain names, use the request Host header in the upstream request headers. If set to false, the upstream Host header will be that of the Service’s host.
        """
        return pulumi.get(self, "preserve_host")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of protocols to use
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="regexPriority")
    def regex_priority(self) -> pulumi.Output[Optional[int]]:
        """
        A number used to choose which route resolves a given request when several routes match it using regexes simultaneously.
        """
        return pulumi.get(self, "regex_priority")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        Service ID to map to
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def snis(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of SNIs that match this Route when using stream routing.
        """
        return pulumi.get(self, "snis")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.RouteSource']]]:
        """
        A list of source `ip` and `port`
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="stripPath")
    def strip_path(self) -> pulumi.Output[Optional[bool]]:
        """
        When matching a Route via one of the paths, strip the matching prefix from the upstream request URL. Default: true.
        """
        return pulumi.get(self, "strip_path")

