# -*- coding: utf-8 -*-
from setuptools import setup, find_packages


def get_long_description():
    with open('README.rst', encoding='utf-8') as f:
        readme = f.read()
    return readme


setup(
    name='pyinfluxql',
    version='0.1.2',
    url='https://github.com/daq-tools/pyinfluxql',
    author='Jeremiah Malina <me@jerem.io>, Michael Pérez <mpuhrez@gmail.com>',
    author_email='me@jerem.io',
    maintainer='Andreas Motl',
    maintainer_email='andreas.motl@getkotori.org',
    description='A query generator for the SQL dialect of the Influx Query Language (InfluxQL)',
    long_description=get_long_description(),
    keywords='influxdb influxql sql query generator acquisition graphing export engine',
    license="MIT",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Environment :: Console",
        "Environment :: Web Environment",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Intended Audience :: Information Technology",
        "Intended Audience :: Manufacturing",
        "Intended Audience :: Science/Research",
        "Intended Audience :: System Administrators",
        "Intended Audience :: Telecommunications Industry",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Topic :: Communications",
        "Topic :: Database",
        "Topic :: Internet",
        "Topic :: Internet :: WWW/HTTP",
        "Topic :: Scientific/Engineering :: Atmospheric Science",
        "Topic :: Scientific/Engineering :: GIS",
        "Topic :: Scientific/Engineering :: Human Machine Interfaces",
        "Topic :: Scientific/Engineering :: Information Analysis",
        "Topic :: Scientific/Engineering :: Interface Engine/Protocol Translator",
        "Topic :: Scientific/Engineering :: Visualization",
        "Topic :: Software Development :: Libraries",
        "Topic :: System :: Archiving",
        "Topic :: System :: Networking :: Monitoring",
        "Topic :: Text Processing",
        "Topic :: Utilities",
        "Operating System :: POSIX",
        "Operating System :: Unix",
        "Operating System :: MacOS",
    ],
    packages=find_packages(),
    zip_safe=False,
    include_package_data=True,
    platforms=['any'],
    install_requires=[
        "six>=1.9.0,<2",
        "influxdb>=2.8.0,<6",
    ],
    extras_require={
        "test": [
            "pytest>=4.6.11,<7",
        ],
    },
)
