# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

- Any unreleased changes

## [3.2.8] - 9-6-2022

- Update docker image

## [3.2.7] - 4-30-2022

- Add Traitor
- Upgrade Docker Python version

## [3.2.6] - 9-29-2021

- Fix Sherlock
- Bump Dev Deps

## [3.2.5] - 5-5-2021

- Switched default branch from `master` to `main`
- Pinned dependencies versions
- Switched from `pylint` to `flake8`
- Added `mypy` and `flake8` config
- Updated command completion
- Increased typing support

## [3.2.4] - 11-12-2020

- Updated `rich`
- Misc fixes

## [3.2.3] - 06-09-2020

- Update Docs
- Misc fixes

## [3.2.2] - 06-08-2020

- Update Docs
- Misc fixes
- Replaced `colorama` with `rich`
- Added `GitPython` package
- Python Dependency graph

## [3.2.1] - 06-02-2020

- Update Docs
- Misc fixes

## [3.1.9] - 05-30-2020

- Implement Pylint
- Refactor
- Update Docs
- Random Banner

## [3.1.8] - 05-28-2020

- Fixed config
- Cleaned up workflow
- Added [Striker](https://github.com/s0md3v/Striker)
- Added [HydraRecon](https://github.com/aufzayed/HydraRecon)

## [3.1.5] - 05-28-2020

- Added Networking category
- Added [bettercap](https://github.com/bettercap/bettercap)
- Moved [nmap](https://github.com/nmap/nmap) to Networking
- Added [Photon](https://github.com/s0md3v/Photon)
- Added [gitGraber](https://github.com/hisxo/gitGraber)

## [3.1.4] - 05-28-2020

- Added `--suggest` argument

## [3.1.3] - 05-23-2020

- Added GitHub Templates
- Added Docker Support
- New Icon
- Changed ASCII art
- Added `--info` argument
- Added `base64_decode` to utilities

## [3.1.2] - 05-20-2020

- Added [changeme](https://github.com/ztgrace/changeme)
- Added nmap scripts

## [3.1.1] - 05-19-2020

- Added [sqlmap](https://github.com/sqlmapproject/sqlmap)
- Added `utility`

## [3.1.0] - 05-19-2020

- Fixed `packages` in `setup.py`

## [3.0.9] - 05-19-2020

- Fixed `setup.py`

## [3.0.8] - 05-18-2020

- Added [Hash-Buster](https://github.com/s0md3v/Hash-Buster)
- Added [Sublist3r](https://github.com/aboul3la/Sublist3r)
- Added [S3Scanner](https://github.com/sa7mon/S3Scanner)
- Added [Cr3d0v3r](https://github.com/D4Vinci/Cr3d0v3r)
- Added [Cuteit](https://github.com/D4Vinci/Cuteit)

## [3.0.7] - 05-18-2020

- Created [Docs](https://fsociety.dev/) with `pmarsceill/just-the-docs`

## [3.0.6] - 05-17-2020

- Added [XSStrike](https://github.com/s0md3v/XSStrike)

## [3.0.5] - 05-17-2020

- Changed minimum Python version to 3.7
- Added PyPi Badge to `README.md`

## [3.0.4] - 05-17-2020

- Added hosts file at `~/.fsociety/hosts.txt`
- Added usernames file at `~/.fsociety/usernames.txt`
- Added [nmap](https://github.com/nmap/nmap)
- Added [sherlock](https://github.com/sherlock-project/sherlock)

## [3.0.3] - 05-17-2020

- Added `argparse`

## [3.0.2] - 05-17-2020

- Published to `pypi`
- Added upload script to `setup.py`
- Added config file at `~/.fsociety/fsociety.cfg`
- Added `colorama` package
- Added `GitHubRepo` class
- Added [cupp](https://github.com/Mebus/cupp)

## [3.0.0] - 05-16-2020

- Initial Release

<!-- References -->
[unreleased]: https://github.com/fsociety-team/fsociety/compare/v3.2.8...HEAD
[3.2.8]: https://github.com/fsociety-team/fsociety/compare/v3.2.7...v3.2.8
[3.2.7]: https://github.com/fsociety-team/fsociety/compare/v3.2.6...v3.2.7
[3.2.6]: https://github.com/fsociety-team/fsociety/compare/v3.2.5...v3.2.6
[3.2.5]: https://github.com/fsociety-team/fsociety/compare/v3.2.4...v3.2.5
[3.2.4]: https://github.com/fsociety-team/fsociety/compare/v3.2.3...v3.2.4
[3.2.3]: https://github.com/fsociety-team/fsociety/compare/v3.2.2...v3.2.3
[3.2.2]: https://github.com/fsociety-team/fsociety/compare/v3.2.1...v3.2.2
[3.2.1]: https://github.com/fsociety-team/fsociety/compare/v3.1.9...v3.2.1
[3.1.9]: https://github.com/fsociety-team/fsociety/compare/v3.1.8...v3.1.9
[3.1.8]: https://github.com/fsociety-team/fsociety/compare/v3.1.5...v3.1.8
[3.1.5]: https://github.com/fsociety-team/fsociety/compare/v3.1.4...v3.1.5
[3.1.4]: https://github.com/fsociety-team/fsociety/compare/v3.1.3...v3.1.4
[3.1.3]: https://github.com/fsociety-team/fsociety/compare/v3.1.2...v3.1.3
[3.1.2]: https://github.com/fsociety-team/fsociety/compare/v3.1.1...v3.1.2
[3.1.1]: https://github.com/fsociety-team/fsociety/compare/v3.1.0...v3.1.1
[3.1.0]: https://github.com/fsociety-team/fsociety/compare/v3.0.9...v3.1.0
[3.0.9]: https://github.com/fsociety-team/fsociety/compare/v3.0.8...v3.0.9
[3.0.8]: https://github.com/fsociety-team/fsociety/compare/v3.0.7...v3.0.8
[3.0.7]: https://github.com/fsociety-team/fsociety/compare/v3.0.6...v3.0.7
[3.0.6]: https://github.com/fsociety-team/fsociety/compare/v3.0.5...v3.0.6
[3.0.5]: https://github.com/fsociety-team/fsociety/compare/v3.0.4...v3.0.5
[3.0.4]: https://github.com/fsociety-team/fsociety/compare/v3.0.3...v3.0.4
[3.0.3]: https://github.com/fsociety-team/fsociety/compare/v3.0.2...v3.0.3
[3.0.2]: https://github.com/fsociety-team/fsociety/compare/v3.0.0...v3.0.2
[3.0.0]: https://github.com/fsociety-team/fsociety/releases/tag/v3.0.0
